/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.classfile.instructions;

import com.sun.javacard.classfile.constants.JConstantPool;
import com.sun.javacard.classfile.instructions.JInstrSwitch;
import java.io.DataInputStream;
import java.io.IOException;

public class JInstrLookupSwitch
extends JInstrSwitch {
    private int[] match_offsets;
    private int[] match_values;

    public JInstrLookupSwitch(JConstantPool cp, int pc, int opcode) {
        super(cp, pc, opcode);
    }

    public int getInstrSize() {
        return this.size_in_bytes;
    }

    public int[] getMatchOffsets() {
        return this.match_offsets;
    }

    public int[] getMatchValues() {
        return this.match_values;
    }

    public int getSizeInBytes() {
        return this.size_in_bytes;
    }

    public void parse(DataInputStream dis) throws IOException {
        super.parse(dis);
        int num_pairs = dis.readInt();
        this.match_values = new int[num_pairs];
        this.match_offsets = new int[num_pairs];
        int i = 0;
        while (i < num_pairs) {
            this.match_values[i] = dis.readInt();
            this.match_offsets[i] = dis.readInt();
            ++i;
        }
        this.size_in_bytes = 1 + this.num_padding + 8 + num_pairs * 8;
    }
}

