/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.util;

import com.sun.javacard.converter.util.MethodDescriptor;

public class Names {
    public static String getPackageName(String class_name) {
        int index = class_name.lastIndexOf(47);
        if (index == -1) {
            return new String("");
        }
        return class_name.substring(0, index);
    }

    public static String getClassName(String class_name) {
        int index = class_name.lastIndexOf(47);
        if (index == -1) {
            return class_name;
        }
        return class_name.substring(index + 1);
    }

    public static String getClassNameFromDescriptor(String descriptor) {
        if (descriptor.startsWith("L")) {
            return descriptor.substring(1, descriptor.length() - 1);
        }
        if (descriptor.startsWith("[L")) {
            return descriptor.substring(2, descriptor.length() - 1);
        }
        return null;
    }

    public static String getPartialPackageName(String package_name) {
        int index = package_name.lastIndexOf(47);
        if (index == -1) {
            return package_name;
        }
        return package_name.substring(++index, package_name.length());
    }

    public static String getMethodNameInJavaStyle(String method_name, String descriptor) {
        StringBuffer sb = new StringBuffer();
        sb.append(method_name + "(");
        String[] param_descs = MethodDescriptor.getParamDescriptors(descriptor);
        int i = 0;
        while (i < param_descs.length) {
            sb.append(Names.getTypeStringInJavaStyle(param_descs[i]));
            if (i != param_descs.length - 1) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public static String getTypeStringInJavaStyle(String descriptor) {
        if (descriptor.equals("V")) {
            return "void";
        }
        if (descriptor.equals("B")) {
            return "byte";
        }
        if (descriptor.equals("S")) {
            return "short";
        }
        if (descriptor.equals("I")) {
            return "int";
        }
        if (descriptor.equals("Z")) {
            return "boolean";
        }
        if (descriptor.equals("[B")) {
            return "byte[]";
        }
        if (descriptor.equals("[S")) {
            return "short[]";
        }
        if (descriptor.equals("[I")) {
            return "int[]";
        }
        if (descriptor.equals("[Z")) {
            return "boolean[]";
        }
        if (descriptor.equals("J")) {
            return "long";
        }
        if (descriptor.equals("F")) {
            return "float";
        }
        if (descriptor.equals("D")) {
            return "double";
        }
        if (descriptor.equals("C")) {
            return "char";
        }
        if (descriptor.startsWith("L") || descriptor.startsWith("[L")) {
            return Names.getClassNameFromDescriptor(descriptor).replace('/', '.');
        }
        if (descriptor.equals("[J")) {
            return "long[]";
        }
        if (descriptor.equals("[F")) {
            return "float[]";
        }
        if (descriptor.equals("[D")) {
            return "double[]";
        }
        if (descriptor.equals("[C")) {
            return "char[]";
        }
        return null;
    }

    public static String getExportFileName(String package_name) {
        return new String(Names.getPartialPackageName(package_name) + ".exp");
    }

    public static String getJcaFileName(String package_name) {
        return new String(Names.getPartialPackageName(package_name) + ".jca");
    }

    public static String getCAPFileName(String package_name) {
        return new String(Names.getPartialPackageName(package_name) + ".cap");
    }
}

