/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.Info;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.PackageIdentifier;

public class StaticMethodRefInfo
extends Info {
    protected int staticMethodToken;

    StaticMethodRefInfo(PackageIdentifier packageId, String name) {
        super(6, packageId, name, name.substring(name.lastIndexOf(40)));
    }

    StaticMethodRefInfo(PackageIdentifier packageId, int classToken, int staticMethodToken, String descriptor) {
        super(6, packageId, classToken, descriptor);
        this.staticMethodToken = staticMethodToken;
    }

    public int getStaticMethodToken() {
        return this.staticMethodToken;
    }

    public byte[] toByteArray(JCPackage p) {
        byte[] array = super.toByteArray(p);
        if (this.isPackageInternal()) {
            int offset = this.resolvedTo.getRelocAddr();
            array[1] = 0;
            array[2] = (byte)(offset >> 8 & 0xFF);
            array[3] = (byte)(offset & 0xFF);
        } else {
            array[1] = (byte)p.getPackageToken(this.packageIdentifier);
            array[1] = (byte)(array[1] | 0x80);
            array[2] = (byte)this.classToken;
            array[3] = (byte)this.staticMethodToken;
        }
        return array;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append("." + Integer.toHexString(this.staticMethodToken));
        return sb.toString();
    }
}

