/*
 * Decompiled with CFR 0.152.
 */
package javacard.framework;

import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.impl.PackedBoolean;
import com.sun.javacard.impl.PrivAccess;
import javacard.framework.APDUComm;
import javacard.framework.APDUException;
import javacard.framework.ISOException;
import javacard.framework.JCSystem;
import javacard.framework.Util;

class T1APDUImpl
implements APDUComm {
    private static final short BUFFERSIZE = 133;
    private static APDUComm theAPDU;
    private byte[] buffer = NativeMethods.initAPDUBuffer();
    private static byte[] ramByteVars;
    private static short[] ramShortVars;
    private static final byte LE = 0;
    private static final byte LR = 1;
    private static final byte LC = 2;
    private static final byte LS = 3;
    private static final byte LO = 4;
    private static final byte PRE_READ_LENGTH = 5;
    private static final byte INCOMIMG_LENGTH = 6;
    private static final byte DATA_PROCESSED_LENGTH = 7;
    private static final byte RAM_SHORT_VARS_LENGTH = 8;
    private static final byte CURRENT_STATE = 0;
    private static final byte LOGICAL_CHN = 1;
    private static final byte RAM_BYTE_VARS_LENGTH = 2;
    private static final short CASE_1 = 1;
    private static final short CASE_2S = 2;
    private static final short CASE_3S = 3;
    private static final short CASE_4S = 4;
    private static final short CASE_2E = 6;
    private static final short CASE_3E = 7;
    private static final short CASE_4E = 8;
    private static final byte T1_EVENT_NONE = 0;
    private static final byte T1_EVENT_POWERUP = 1;
    private static final byte T1_EVENT_POWERDOWN = 2;
    private static final byte T1_EVENT_POWERRESET = 3;
    private static final short MAX_LE = 256;
    private static final short MAX_EXT_LE = Short.MAX_VALUE;
    private PackedBoolean thePackedBoolean;
    private byte incomingFlag;
    private byte outgoingFlag;
    private byte outgoingLenSetFlag;
    private byte sendInProgressFlag;
    private byte noChainingFlag;
    private byte extendedAPDUFlag;
    private byte determinedLE;
    private byte type16Flag;
    private byte extendedSupportFlag;

    private short getLe() {
        if (ramShortVars[0] == 0 && this.getDeterminedLEFlag()) {
            if (this.getExtendedAPDUFlag()) {
                return Short.MAX_VALUE;
            }
            return 256;
        }
        return ramShortVars[0];
    }

    private void setLe(short data) {
        T1APDUImpl.ramShortVars[0] = data;
    }

    private short getIL() {
        return ramShortVars[6];
    }

    private void setIL(short data) {
        T1APDUImpl.ramShortVars[6] = data;
    }

    private short getLr() {
        return ramShortVars[1];
    }

    private void setLr(short data) {
        T1APDUImpl.ramShortVars[1] = data;
    }

    private short getLc() {
        return ramShortVars[2];
    }

    private void setLc(short data) {
        T1APDUImpl.ramShortVars[2] = data;
    }

    private short getLs() {
        return ramShortVars[3];
    }

    private void setLs(short data) {
        T1APDUImpl.ramShortVars[3] = (short)(data & Short.MAX_VALUE);
    }

    private short getLo() {
        return ramShortVars[4];
    }

    private void setLo(short data) {
        T1APDUImpl.ramShortVars[4] = data;
    }

    private short getPreReadLength() {
        return ramShortVars[5];
    }

    private void setPreReadLength(short data) {
        T1APDUImpl.ramShortVars[5] = data;
    }

    private byte getCurrState() {
        return ramByteVars[0];
    }

    private void setCurrState(byte data) {
        T1APDUImpl.ramByteVars[0] = data;
    }

    private void resetCurrState() {
        T1APDUImpl.ramByteVars[0] = 0;
    }

    private void setLogicalChannel(byte data) {
        T1APDUImpl.ramByteVars[1] = data;
    }

    private boolean getIncomingFlag() {
        return this.thePackedBoolean.get(this.incomingFlag);
    }

    private void setIncomingFlag() {
        this.thePackedBoolean.set(this.incomingFlag);
    }

    private void resetIncomingFlag() {
        this.thePackedBoolean.reset(this.incomingFlag);
    }

    private boolean getDeterminedLEFlag() {
        return this.thePackedBoolean.get(this.determinedLE);
    }

    private void setDeterminedLEFlag() {
        this.thePackedBoolean.set(this.determinedLE);
    }

    private void resetDeterminedLEFlag() {
        this.thePackedBoolean.reset(this.determinedLE);
    }

    private boolean getSendInProgressFlag() {
        return this.thePackedBoolean.get(this.sendInProgressFlag);
    }

    private void setSendInProgressFlag() {
        this.thePackedBoolean.set(this.sendInProgressFlag);
    }

    private void resetSendInProgressFlag() {
        this.thePackedBoolean.reset(this.sendInProgressFlag);
    }

    private boolean getOutgoingFlag() {
        return this.thePackedBoolean.get(this.outgoingFlag);
    }

    private void setOutgoingFlag() {
        this.thePackedBoolean.set(this.outgoingFlag);
    }

    private void resetOutgoingFlag() {
        this.thePackedBoolean.reset(this.outgoingFlag);
    }

    private boolean getOutgoingLenSetFlag() {
        return this.thePackedBoolean.get(this.outgoingLenSetFlag);
    }

    private void setOutgoingLenSetFlag() {
        this.thePackedBoolean.set(this.outgoingLenSetFlag);
    }

    private void resetOutgoingLenSetFlag() {
        this.thePackedBoolean.reset(this.outgoingLenSetFlag);
    }

    private boolean getExtendedAPDUFlag() {
        return this.thePackedBoolean.get(this.extendedAPDUFlag);
    }

    private void setExtendedAPDUFlag() {
        this.thePackedBoolean.set(this.extendedAPDUFlag);
    }

    private void resetExtendedAPDUFlag() {
        this.thePackedBoolean.reset(this.extendedAPDUFlag);
    }

    private boolean getType16Flag() {
        return this.thePackedBoolean.get(this.type16Flag);
    }

    private void setType16Flag() {
        this.thePackedBoolean.set(this.type16Flag);
    }

    private void resetType16Flag() {
        this.thePackedBoolean.reset(this.type16Flag);
    }

    private boolean getExtendedSupportFlag() {
        return this.thePackedBoolean.get(this.extendedSupportFlag);
    }

    private void setExtendedSupportFlag() {
        this.thePackedBoolean.set(this.extendedSupportFlag);
    }

    private void resetExtendedSupportFlag() {
        this.thePackedBoolean.reset(this.extendedSupportFlag);
    }

    T1APDUImpl() {
        ramByteVars = JCSystem.makeTransientByteArray((short)2, (byte)1);
        ramShortVars = JCSystem.makeTransientShortArray((short)8, (byte)1);
        this.thePackedBoolean = PrivAccess.getPackedBoolean();
        this.incomingFlag = this.thePackedBoolean.allocate();
        this.sendInProgressFlag = this.thePackedBoolean.allocate();
        this.outgoingFlag = this.thePackedBoolean.allocate();
        this.outgoingLenSetFlag = this.thePackedBoolean.allocate();
        this.extendedAPDUFlag = this.thePackedBoolean.allocate();
        this.noChainingFlag = this.thePackedBoolean.allocate();
        this.determinedLE = this.thePackedBoolean.allocate();
        this.type16Flag = this.thePackedBoolean.allocate();
        this.extendedSupportFlag = this.thePackedBoolean.allocate();
        theAPDU = this;
    }

    private byte getChannelInfo() {
        byte theAPDUChannel;
        if (this.isType16CLA()) {
            theAPDUChannel = (byte)(this.buffer[0] & 0xF);
            theAPDUChannel = (byte)(theAPDUChannel + 4);
        } else {
            theAPDUChannel = (byte)(this.buffer[0] & 0x20) != 0 ? (byte)0 : (byte)(this.buffer[0] & 3);
        }
        return theAPDUChannel;
    }

    public byte getLogicalChannel() {
        return ramByteVars[1];
    }

    public boolean getNoChainingFlag() {
        return this.thePackedBoolean.get(this.noChainingFlag);
    }

    private void setNoChainingFlag() {
        this.thePackedBoolean.set(this.noChainingFlag);
    }

    private void resetNoChainingFlag() {
        this.thePackedBoolean.reset(this.noChainingFlag);
    }

    public void resetAPDU() {
        this.resetIncomingFlag();
        this.resetOutgoingFlag();
        this.resetOutgoingLenSetFlag();
        this.resetSendInProgressFlag();
        this.resetType16Flag();
        this.resetExtendedAPDUFlag();
        this.resetDeterminedLEFlag();
        this.resetNoChainingFlag();
        this.setPreReadLength((short)0);
        T1APDUImpl.ramShortVars[7] = 0;
    }

    private void setAPDUParameters(short Lc, short Le, short Lr, short preReadLength, short incomingLength) {
        this.setLe(Le);
        this.setLc(Lc);
        this.setLr(Lr);
        this.setIL(incomingLength);
        this.resetCurrState();
        this.setPreReadLength(preReadLength);
        if (this.isType16CLA()) {
            this.setType16Flag();
        }
        this.setLogicalChannel(this.getChannelInfo());
    }

    private void preProcessAPDU(short recvBytes) {
        if (recvBytes == 4) {
            this.setAPDUParameters((short)0, (short)0, (short)0, (short)0, (short)0);
            this.setDeterminedLEFlag();
            return;
        }
        if (recvBytes == 5) {
            short Le = (short)(this.buffer[4] & 0xFF);
            this.setAPDUParameters((short)0, Le, (short)0, (short)0, (short)0);
            this.setDeterminedLEFlag();
            return;
        }
        if (recvBytes == 7) {
            byte bLc = this.buffer[4];
            if (bLc == 0) {
                short Le = (short)(this.buffer[5] & 0xFF);
                Le = (short)((short)(Le << 8) | (short)(this.buffer[6] & 0xFF));
                this.setAPDUParameters((short)0, Le, (short)0, (short)0, (short)0);
                this.setDeterminedLEFlag();
                this.setExtendedAPDUFlag();
                return;
            }
            short Lc = (short)(bLc & 0xFF);
            if (bLc != 2) {
                short Le = (short)(this.buffer[6] & 0xFF);
                Lc = (short)(Lc - 1);
                this.setAPDUParameters(Lc, Le, (short)0, (short)1, (short)1);
                this.setDeterminedLEFlag();
                return;
            }
            Lc = (short)(Lc - 2);
            this.setAPDUParameters(Lc, (short)0, (short)0, (short)2, (short)2);
            this.setDeterminedLEFlag();
            return;
        }
        if (recvBytes > 5) {
            byte bLc = this.buffer[4];
            if (bLc == 0) {
                short Le;
                short pRL;
                int Lc = this.buffer[5] & 0xFF;
                if (recvBytes == (short)((Lc = (short)((short)(Lc << 8) | (short)(this.buffer[6] & 0xFF))) + 9)) {
                    pRL = (short)(recvBytes - 9);
                    Le = (short)(this.buffer[(short)(7 + pRL)] & 0xFF);
                    Le = (short)((short)(Le << 8) | (short)(this.buffer[(short)(7 + pRL + 1)] & 0xFF));
                    Lc = -2;
                } else {
                    pRL = (short)(recvBytes - 7);
                    Le = 0;
                    Lc = (short)(Lc - pRL);
                }
                this.setAPDUParameters((short)Lc, Le, (short)0, pRL, (short)(Lc + pRL));
                this.setExtendedAPDUFlag();
                this.resetDeterminedLEFlag();
                return;
            }
            short Lc = (short)(bLc & 0xFF);
            if (Lc > 128) {
                short pRL = (short)(recvBytes - 5);
                Lc = (short)(Lc - pRL);
                this.setAPDUParameters(Lc, (short)0, (short)0, pRL, (short)(Lc + pRL));
                this.resetDeterminedLEFlag();
                return;
            }
            if (Lc < (short)(recvBytes - 5)) {
                short Le = (short)(this.buffer[(short)(recvBytes - 1)] & 0xFF);
                short pRL = (short)(recvBytes - 6);
                Lc = (short)(Lc - pRL);
                this.setAPDUParameters(Lc, Le, (short)0, pRL, (short)(Lc + pRL));
                this.setDeterminedLEFlag();
                return;
            }
            short Le = 0;
            short pRL = (short)(recvBytes - 5);
            Lc = (short)(Lc - pRL);
            this.setAPDUParameters(Lc, Le, (short)0, pRL, (short)(Lc + pRL));
            this.resetDeterminedLEFlag();
            return;
        }
    }

    public void complete(short status) throws APDUException {
        short result;
        if (status != 0) {
            if (!this.getOutgoingFlag() && !NativeMethods.t1LastBlockReceived() && (result = NativeMethods.t1Abort()) < 0) {
                status = (short)28416;
            }
            if (this.getSendInProgressFlag()) {
                short Lo;
                short Ls = this.getLs();
                if ((short)(Ls + (Lo = this.getLo()) + 1) >= 133) {
                    result = NativeMethods.t1SndBlockRcvAck(Lo, Ls, false, false);
                    Ls = 0;
                    Lo = 0;
                }
                byte sw1 = (byte)((byte)(status >> 8) & 0xFF);
                byte sw2 = (byte)(status & 0xFF);
                this.buffer[(short)(Ls + Lo)] = sw1;
                this.buffer[(short)(Ls + Lo + 1)] = sw2;
                result = NativeMethods.t1SndBlockRcvAck(Lo, (short)(Ls + 2), true, true);
            } else {
                byte sw1 = (byte)((byte)(status >> 8) & 0xFF);
                byte sw2 = (byte)(status & 0xFF);
                this.buffer[0] = sw1;
                this.buffer[1] = sw2;
                result = NativeMethods.t1SndBlockRcvAck((short)0, (short)2, true, true);
            }
            if (result != 0) {
                APDUException.throwIt((short)4);
            }
        }
        Util.arrayFillNonAtomic(this.buffer, (short)0, (short)133, (byte)0);
        byte cardEvent = NativeMethods.getSecondaryInterfaceEvent();
        if (cardEvent == 1) {
            PrivAccess.powerUpContactless();
        } else if (cardEvent == 2) {
            PrivAccess.powerDownContactless();
        } else if (cardEvent == 3) {
            PrivAccess.powerDownContactless();
            PrivAccess.powerUpContactless();
        }
        short bOff = 0;
        short bytesReceived = 0;
        while (bOff < 133 && !NativeMethods.t1LastBlockReceived()) {
            result = NativeMethods.t1RcvBlock(bOff, (short)133);
            if (result < 0) {
                APDUException.throwIt((short)4);
            }
            bOff = (short)(bOff + result);
            bytesReceived = (short)(bytesReceived + result);
        }
        this.resetExtendedSupportFlag();
        this.resetAPDU();
        this.preProcessAPDU(bytesReceived);
    }

    public void undoIncomingAndReceive() {
        this.setPreReadLength((short)(this.buffer[4] - this.getLc() & Short.MAX_VALUE));
        this.setCurrState((byte)0);
    }

    public byte getCLAChannel() {
        return theAPDU.getLogicalChannel();
    }

    public void waitExtension() throws APDUException {
        short result;
        if (theAPDU.getNoChainingFlag()) {
            APDUException.throwIt((short)1);
        }
        if ((result = NativeMethods.t1Wait()) != 0) {
            APDUException.throwIt((short)4);
        }
    }

    private boolean isExtended() {
        return this.getExtendedSupportFlag();
    }

    public boolean isCommandChainingCLA() {
        byte theCLAChaining = (byte)(this.buffer[0] & 0x10);
        return theCLAChaining == 16;
    }

    public boolean isSecureMessagingCLA() {
        byte secureMsgFlag = this.isType16CLA() ? (byte)(this.buffer[0] & 0x20) : (byte)(this.buffer[0] & 0xC);
        return secureMsgFlag != 0;
    }

    public boolean isISOInterindustryCLA() {
        byte theCLAType = (byte)(this.buffer[0] & 0xFFFFFF80);
        return theCLAType == 0;
    }

    private boolean isType16CLA() {
        byte theCLAType = (byte)(this.buffer[0] & 0x40);
        return theCLAType == 64;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public short getInBlockSize() {
        return NativeMethods.t1GetIFSC();
    }

    public short getOutBlockSize() {
        return NativeMethods.t1GetIFSD();
    }

    public byte getProtocol() {
        if (NativeMethods.getCommProtocol(NativeMethods.getActiveInterface()) == 1) {
            return 1;
        }
        if (NativeMethods.getCommProtocol(NativeMethods.getActiveInterface()) == -111) {
            return -127;
        }
        return -1;
    }

    public byte getNAD() {
        return NativeMethods.t1GetNAD();
    }

    private void receiveBytesAndDiscard() {
        short Le;
        short pre;
        if (!this.getIncomingFlag()) {
            this.setIncomingFlag();
        }
        if ((pre = this.getPreReadLength()) != 0) {
            this.setPreReadLength((short)0);
            ramShortVars[7] = (short)(ramShortVars[7] + pre);
        }
        if ((Le = NativeMethods.t1RcvAndDiscardData(this.getIL(), ramShortVars[7])) == -2) {
            ISOException.throwIt((short)26368);
        } else if (Le >= 0) {
            this.setLe(Le);
            this.setDeterminedLEFlag();
        }
    }

    public short setOutgoing() throws APDUException {
        if (this.getOutgoingFlag()) {
            APDUException.throwIt((short)1);
        }
        if (!NativeMethods.t1LastBlockReceived()) {
            this.receiveBytesAndDiscard();
        }
        this.setOutgoingFlag();
        this.setCurrState((byte)3);
        if (this.getLe() < 0) {
            APDUException.throwIt((short)26368);
        }
        return this.getLe();
    }

    public short setOutgoingNoChaining() throws APDUException {
        short result;
        if (this.getOutgoingFlag()) {
            APDUException.throwIt((short)1);
        }
        if (!NativeMethods.t1LastBlockReceived() && (result = NativeMethods.t1Abort()) < 0) {
            APDUException.throwIt((short)4);
        }
        this.setOutgoingFlag();
        this.setNoChainingFlag();
        this.setCurrState((byte)3);
        return this.getLe();
    }

    public void setOutgoingLength(short len) throws APDUException {
        if (!this.getOutgoingFlag()) {
            APDUException.throwIt((short)1);
        }
        if (this.getOutgoingLenSetFlag()) {
            APDUException.throwIt((short)1);
        }
        if (len > 256 && !this.getExtendedSupportFlag()) {
            APDUException.throwIt((short)3);
        }
        if (len > Short.MAX_VALUE) {
            APDUException.throwIt((short)3);
        }
        if (len < 0) {
            APDUException.throwIt((short)3);
        }
        if (len > (short)(NativeMethods.t1GetIFSD() - 2) && this.getNoChainingFlag()) {
            APDUException.throwIt((short)3);
        }
        this.setOutgoingLenSetFlag();
        this.setCurrState((byte)4);
        this.setLr(len);
        this.setDeterminedLEFlag();
        if (len > 256) {
            this.setExtendedAPDUFlag();
        }
    }

    public short receiveBytes(short bOff) throws APDUException {
        short pre;
        if (this.getIL() == 0) {
            APDUException.throwIt((short)4);
        }
        if (!this.getIncomingFlag() || this.getOutgoingFlag()) {
            APDUException.throwIt((short)1);
        }
        short Lc = this.getLc();
        if (bOff < 0) {
            APDUException.throwIt((short)2);
        }
        if ((pre = this.getPreReadLength()) != 0) {
            this.setPreReadLength((short)0);
            if (Lc <= 0) {
                this.setCurrState((byte)2);
            } else {
                this.setCurrState((byte)1);
            }
            ramShortVars[7] = (short)(ramShortVars[7] + pre);
            return pre;
        }
        short len = 0;
        if (Lc > 0) {
            short accumLen = 0;
            short bOff2 = bOff;
            while (bOff2 < 133 && Lc > 0) {
                accumLen = NativeMethods.t1RcvBlock(bOff2, (short)133);
                if (accumLen < 0) {
                    APDUException.throwIt((short)4);
                }
                Lc = (short)(Lc - accumLen);
                bOff2 = (short)(bOff2 + accumLen);
                len = (short)(len + accumLen);
            }
            if (Lc < 0) {
                if (Lc == -1) {
                    if (this.getExtendedAPDUFlag()) {
                        this.setLe((short)((this.buffer[(short)(bOff + len - 1)] & 0xFF) << 8));
                    } else {
                        this.setLe((short)(this.buffer[(short)(bOff + len - 1)] & 0xFF));
                    }
                    Lc = 0;
                    len = (short)(len - 1);
                    this.setDeterminedLEFlag();
                } else {
                    this.setLe((short)((this.buffer[(short)(bOff + len - 2)] & 0xFF) << 8 | (short)(this.buffer[(short)(bOff + len - 1)] & 0xFF)));
                    Lc = 0;
                    len = (short)(len - 2);
                    this.setDeterminedLEFlag();
                }
            }
            this.setLc(Lc);
            if (Lc == 0) {
                this.setCurrState((byte)2);
            } else {
                this.setCurrState((byte)1);
            }
            ramShortVars[7] = (short)(ramShortVars[7] + len);
            return len;
        }
        if (!NativeMethods.t1LastBlockReceived()) {
            len = NativeMethods.t1RcvBlock(bOff, (short)133);
            if (len < 0) {
                APDUException.throwIt((short)4);
            }
            if (this.getExtendedAPDUFlag()) {
                if (this.getDeterminedLEFlag()) {
                    this.setLe((short)(this.getLe() | this.buffer[(short)(bOff + len - 1)] & 0xFF));
                } else {
                    this.setLe((short)((this.buffer[(short)(bOff + len - 2)] & 0xFF) << 8 | (short)(this.buffer[(short)(bOff + len - 1)] & 0xFF)));
                    this.setDeterminedLEFlag();
                }
            } else if (!this.getDeterminedLEFlag()) {
                this.setLe((short)(this.buffer[(short)(bOff + len - 1)] & 0xFF));
            }
        }
        this.setLc((short)0);
        this.setCurrState((byte)2);
        return 0;
    }

    public void sendBytes(short bOff, short len) throws APDUException {
        short result = 0;
        if (bOff < 0 || len < 0 || (short)(bOff + len) > 133) {
            APDUException.throwIt((short)2);
        }
        if (!this.getOutgoingLenSetFlag()) {
            APDUException.throwIt((short)1);
        }
        if (len == 0) {
            return;
        }
        short Lr = this.getLr();
        if (len > Lr) {
            APDUException.throwIt((short)1);
        }
        short Le = this.getLe();
        short blockSize = NativeMethods.t1GetIFSD();
        short lenSent = 0;
        short bOff2 = bOff;
        if (this.getNoChainingFlag() && Lr > blockSize) {
            APDUException.throwIt((short)1);
        }
        short initLen = len;
        while (lenSent < initLen) {
            short sendLen = blockSize;
            if (len < blockSize) {
                sendLen = len;
                if (Lr == len && (short)(len + 2) <= blockSize) {
                    this.setLs(len);
                    this.setLo(bOff2);
                    this.setLr((short)0);
                    this.setLe((short)0);
                    this.setCurrState((byte)6);
                    this.setSendInProgressFlag();
                    return;
                }
            }
            if ((result = NativeMethods.t1SndBlockRcvAck(bOff2, sendLen, false, false)) != 0) {
                APDUException.throwIt((short)4);
            }
            bOff2 = (short)(bOff2 + sendLen);
            lenSent = (short)(sendLen + lenSent);
            Lr = (short)(Lr - sendLen);
            len = (short)(len - sendLen);
        }
        Le = Lr;
        if (Lr == 0) {
            this.setCurrState((byte)6);
        } else {
            this.setCurrState((byte)5);
        }
        this.setLe(Le);
        this.setLr(Lr);
    }

    public void sendBytesLong(byte[] outData, short bOff, short len) throws APDUException, SecurityException {
        NativeMethods.checkArrayArgs(outData, bOff, len);
        NativeMethods.checkPreviousContextAccess(outData);
        short sendLength = (short)this.buffer.length;
        while (len > 0) {
            if (len < sendLength) {
                sendLength = len;
            }
            Util.arrayCopy(outData, bOff, this.buffer, (short)0, sendLength);
            this.sendBytes((short)0, sendLength);
            len = (short)(len - sendLength);
            bOff = (short)(bOff + sendLength);
        }
    }

    private void setIncoming() throws APDUException {
        if (this.getPreReadLength() != 0) {
            this.setIncomingFlag();
            return;
        }
        if (this.getIncomingFlag() || this.getOutgoingFlag()) {
            APDUException.throwIt((short)1);
        }
        this.setIncomingFlag();
        if (!this.getExtendedSupportFlag() && this.getLc() > 256) {
            APDUException.throwIt((short)26368);
        }
        if (this.getLc() < 0) {
            APDUException.throwIt((short)26368);
        }
    }

    public short setIncomingAndReceive() throws APDUException {
        this.setIncoming();
        if (this.getExtendedAPDUFlag()) {
            return this.receiveBytes((short)7);
        }
        return this.receiveBytes((short)5);
    }

    public void setOutgoingAndSend(short bOff, short len) throws APDUException {
        this.setOutgoing();
        this.setOutgoingLength(len);
        this.sendBytes(bOff, len);
    }

    public byte getCurrentState() {
        return this.getCurrState();
    }

    public byte[] getCurrentAPDUBuffer() throws SecurityException {
        return theAPDU.getBuffer();
    }

    public void markExtendedSupport(boolean extAPDUOK) {
        if (!extAPDUOK) {
            this.resetExtendedSupportFlag();
            if (this.getExtendedAPDUFlag()) {
                ISOException.throwIt((short)26368);
            }
        } else {
            this.setExtendedSupportFlag();
        }
    }

    public short getIncomingLength() {
        return this.getIL();
    }

    public short getOffsetCdata() {
        if (!this.getExtendedAPDUFlag()) {
            return 5;
        }
        return 7;
    }

    public void verifyLe() {
        if (this.getLe() < 0) {
            ISOException.throwIt((short)26368);
        }
    }
}

