/*
 * Decompiled with CFR 0.152.
 */
package javacard.framework.service;

import com.sun.javacard.impl.NativeMethods;
import com.sun.javacard.impl.PrivAccess;
import java.io.IOException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javacard.framework.APDU;
import javacard.framework.APDUException;
import javacard.framework.CardException;
import javacard.framework.CardRuntimeException;
import javacard.framework.ISOException;
import javacard.framework.JCSystem;
import javacard.framework.PINException;
import javacard.framework.SystemException;
import javacard.framework.TransactionException;
import javacard.framework.UserException;
import javacard.framework.Util;
import javacard.framework.service.BasicService;
import javacard.framework.service.CardRemoteObject;
import javacard.framework.service.RMINativeMethods;
import javacard.framework.service.RemoteService;
import javacard.framework.service.ServiceException;
import javacard.security.CryptoException;
import javacardx.biometry.BioException;
import javacardx.framework.tlv.TLVException;
import javacardx.framework.util.UtilException;

public class RMIService
extends BasicService
implements RemoteService {
    public static final byte DEFAULT_RMI_INVOKE_INSTRUCTION = 56;
    private static final byte FCI_TAG = 111;
    private static final byte APPLICATION_TAG = 110;
    private static final byte RMI_TAG = 94;
    private static final short RMI_VERSION = 514;
    private static final byte NORMAL_TAG = -127;
    private static final byte EXCEPTION_TAG = -126;
    private static final byte EXCEPTION_SUBCLASS_TAG = -125;
    private static final byte ERROR_TAG = -103;
    private static final short OBJECT_ERROR = 1;
    private static final short METHOD_ERROR = 2;
    private static final short SIGNATURE_ERROR = 3;
    private static final short PARAM_RESOURCES_ERROR = 4;
    private static final short RESPONSE_RESOURCES_ERROR = 5;
    private static final short PROTOCOL_ERROR = 6;
    private static final short OTHER_ERROR = -1;
    private static final byte OBJECT_ID_OFFSET = 5;
    private static final byte METHOD_ID_OFFSET = 7;
    private static final byte PARAM_OFFSET = 9;
    private static final byte TAG_OFFSET = 5;
    private static final byte RESULT_OFFSET = 6;
    private static final byte TYPE_C = 1;
    private static final byte TYPE_I = 2;
    private static final byte UNDEFINED_TYPE = 0;
    private byte ref_type = 0;
    Remote initialObject = null;
    byte invoke_instr;
    byte next_invoke_instr = (byte)56;
    private Object[] expArray;
    private static final byte Throwable_Type = 0;
    private static final byte ArithmeticException_Type = 1;
    private static final byte ArrayIndexOutOfBoundsException_Type = 2;
    private static final byte ArrayStoreException_Type = 3;
    private static final byte ClassCastException_Type = 4;
    private static final byte Exception_Type = 5;
    private static final byte IndexOutOfBoundsException_Type = 6;
    private static final byte NegativeArraySizeException_Type = 7;
    private static final byte NullPointerException_Type = 8;
    private static final byte RuntimeException_Type = 9;
    private static final byte SecurityException_Type = 10;
    private static final byte java_io_IOException_Type = 11;
    private static final byte java_rmi_RemoteException_Type = 12;
    private static final byte APDUException_Type = 32;
    private static final byte CardException_Type = 33;
    private static final byte CardRuntimeException_Type = 34;
    private static final byte ISOException_Type = 35;
    private static final byte PINException_Type = 36;
    private static final byte SystemException_Type = 37;
    private static final byte TransactionException_Type = 38;
    private static final byte UserException_Type = 39;
    private static final byte CryptoException_Type = 48;
    private static final byte ServiceException_Type = 64;
    private static final byte BioException_Type = 80;
    private static final byte TLVException_Type = 112;
    private static final byte UtilException_Type = -128;

    public RMIService(Remote initialObject) throws NullPointerException {
        initialObject.equals(null);
        this.initialObject = initialObject;
        this.expArray = JCSystem.makeTransientObjectArray((short)8, (byte)2);
    }

    public void setInvokeInstructionByte(byte ins) {
        this.next_invoke_instr = ins;
    }

    public boolean processCommand(APDU apdu) {
        if (this.selectingApplet()) {
            return this.processSelect(apdu);
        }
        return this.processInvoke(apdu);
    }

    private boolean processSelect(APDU apdu) {
        this.receiveInData(apdu);
        byte[] buffer = apdu.getBuffer();
        this.ref_type = 0;
        byte P1 = this.getP1(apdu);
        byte P2 = (byte)(this.getP2(apdu) & 0x10);
        if (P1 == 4) {
            if (P2 == 0) {
                this.ref_type = 1;
            } else if (P2 == 16) {
                this.ref_type = (byte)2;
            } else {
                return false;
            }
        }
        this.invoke_instr = this.next_invoke_instr;
        buffer[5] = 111;
        buffer[7] = 110;
        buffer[9] = 94;
        Util.setShort(buffer, (short)11, (short)514);
        buffer[13] = this.invoke_instr;
        short offset = 14;
        try {
            if (this.ref_type == 0) {
                offset = this.writeTagAndError((short)6, buffer, offset);
            } else {
                short s2 = offset;
                offset = (short)(offset + 1);
                buffer[s2] = -127;
                offset = this.writeRef(this.initialObject, buffer, offset);
            }
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            offset = this.writeTagAndError((short)5, buffer, (short)14);
        }
        short len3 = (short)(offset - 11);
        short len2 = (short)(len3 + 2);
        short len1 = (short)(len2 + 2);
        short le = (short)(len1 + 2);
        buffer[6] = (byte)len1;
        buffer[8] = (byte)len2;
        buffer[10] = (byte)len3;
        this.setOutputLength(apdu, le);
        this.succeed(apdu);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processInvoke(APDU command) {
        byte[] buffer = command.getBuffer();
        if (command.isISOInterindustryCLA()) {
            return false;
        }
        if (command.isCommandChainingCLA()) {
            return false;
        }
        if (this.getINS(command) != this.invoke_instr) {
            return false;
        }
        if (this.ref_type == 0) {
            return false;
        }
        this.receiveInData(command);
        try {
            int offset = 5;
            if (Util.getShort(buffer, (short)2) != 514 || buffer[4] < 4) {
                offset = this.writeTagAndError((short)6, buffer, (short)5);
            } else {
                short objID = Util.getShort(buffer, (short)5);
                if (!this.isExportedForSession(objID)) {
                    offset = this.writeTagAndError((short)1, buffer, (short)5);
                } else {
                    short mthdID = Util.getShort(buffer, (short)7);
                    int mthdAddr = RMINativeMethods.getRemoteMethodInfo(objID, mthdID);
                    int mthdType = 100;
                    if (mthdAddr == -253) {
                        offset = this.writeTagAndError((short)2, buffer, (short)5);
                    } else {
                        mthdType = RMINativeMethods.getReturnType(mthdAddr);
                    }
                    boolean result_not_exported = false;
                    try {
                        switch (mthdType) {
                            case 1: {
                                RMINativeMethods.rmi_invoker_void(mthdAddr, objID, buffer, (byte)9);
                                int n2 = offset = 5;
                                offset = (short)(offset + 1);
                                buffer[n2] = -127;
                                break;
                            }
                            case 2: {
                                boolean bo = RMINativeMethods.rmi_invoker_boolean(mthdAddr, objID, buffer, (byte)9);
                                buffer[5] = -127;
                                buffer[6] = bo ? (byte)1 : 0;
                                offset = 7;
                                break;
                            }
                            case 3: {
                                byte by = RMINativeMethods.rmi_invoker_byte(mthdAddr, objID, buffer, (byte)9);
                                buffer[5] = -127;
                                int n3 = offset = 6;
                                offset = (short)(offset + 1);
                                buffer[n3] = by;
                                break;
                            }
                            case 4: {
                                short sh = RMINativeMethods.rmi_invoker_short(mthdAddr, objID, buffer, (byte)9);
                                buffer[5] = -127;
                                offset = Util.setShort(buffer, (short)6, sh);
                                break;
                            }
                            case 5: {
                                int in = RMINativeMethods.rmi_invoker_int(mthdAddr, objID, buffer, (byte)9);
                                buffer[5] = -127;
                                offset = this.writeInt(in, buffer, (short)6);
                                break;
                            }
                            case 10: 
                            case 11: 
                            case 12: 
                            case 13: {
                                Object res_array = RMINativeMethods.rmi_invoker_array(mthdAddr, objID, buffer, (byte)9);
                                buffer[5] = -127;
                                try {
                                    if (res_array == null) {
                                        offset = this.writeNullRef(buffer, (short)6);
                                        break;
                                    }
                                    offset = RMINativeMethods.writeArray(res_array, buffer, (short)6);
                                }
                                catch (ArrayIndexOutOfBoundsException e2) {
                                    offset = this.writeTagAndError((short)5, buffer, (short)5);
                                }
                                break;
                            }
                            case 6: {
                                Remote ref = (Remote)RMINativeMethods.rmi_invoker_reference(mthdAddr, objID, buffer, (byte)9);
                                if (!CardRemoteObject.isExported(ref) && !this.isExportedForSession(NativeMethods.getObjectID(ref))) {
                                    result_not_exported = true;
                                    ServiceException.throwIt((short)7);
                                }
                                try {
                                    buffer[5] = -127;
                                    offset = this.writeRef(ref, buffer, (short)6);
                                }
                                catch (ArrayIndexOutOfBoundsException e3) {
                                    offset = this.writeTagAndError((short)5, buffer, (short)5);
                                }
                                break;
                            }
                            case 100: {
                                break;
                            }
                            default: {
                                offset = this.writeTagAndError((short)-1, buffer, (short)5);
                            }
                        }
                    }
                    catch (Throwable t2) {
                        if (result_not_exported) {
                            ServiceException.throwIt((short)7);
                        }
                        offset = this.writeTagAndThrowable(t2, buffer, (short)5);
                    }
                }
            }
            this.setOutputLength(command, (short)(offset - 5));
            this.succeedWithStatusWord(command, (short)-28672);
            boolean bl = true;
            return bl;
        }
        finally {
            RMINativeMethods.deleteAllTempArrays();
        }
    }

    private short writeTagAndError(short reason, byte[] buffer, short offset) {
        short s2 = offset;
        offset = (short)(offset + 1);
        buffer[s2] = -103;
        return Util.setShort(buffer, offset, reason);
    }

    private short writeTagAndThrowable(Throwable data, byte[] buffer, short offset) {
        int tag = 0;
        int type = 0;
        short reason = 0;
        tag = RMINativeMethods.isAPIException(data) ? -126 : -125;
        try {
            throw data;
        }
        catch (ArithmeticException e2) {
            type = 1;
        }
        catch (ArrayIndexOutOfBoundsException e3) {
            type = 2;
        }
        catch (ArrayStoreException e4) {
            type = 3;
        }
        catch (ClassCastException e5) {
            type = 4;
        }
        catch (IndexOutOfBoundsException e6) {
            type = 6;
        }
        catch (NegativeArraySizeException e7) {
            type = 7;
        }
        catch (NullPointerException e8) {
            type = 8;
        }
        catch (SecurityException e9) {
            type = 10;
        }
        catch (RemoteException e10) {
            type = 12;
        }
        catch (IOException e11) {
            type = 11;
        }
        catch (BioException e12) {
            type = 80;
            reason = e12.getReason();
        }
        catch (TLVException e13) {
            type = 112;
            reason = e13.getReason();
        }
        catch (UtilException e14) {
            type = -128;
            reason = e14.getReason();
        }
        catch (APDUException e15) {
            type = 32;
            reason = e15.getReason();
        }
        catch (ISOException e16) {
            type = 35;
            reason = e16.getReason();
        }
        catch (PINException e17) {
            type = 36;
            reason = e17.getReason();
        }
        catch (SystemException e18) {
            short errorCode = RMINativeMethods.getRMIErrorCode();
            if (errorCode == 3 || errorCode == 4) {
                return this.writeTagAndError(errorCode, buffer, (short)5);
            }
            type = 37;
            reason = e18.getReason();
        }
        catch (TransactionException e19) {
            type = 38;
            reason = e19.getReason();
        }
        catch (UserException e20) {
            type = 39;
            reason = e20.getReason();
        }
        catch (CryptoException e21) {
            type = 48;
            reason = e21.getReason();
        }
        catch (ServiceException e22) {
            type = 64;
            reason = e22.getReason();
        }
        catch (CardRuntimeException e23) {
            type = 34;
            reason = e23.getReason();
        }
        catch (CardException e24) {
            type = 33;
            reason = e24.getReason();
        }
        catch (RuntimeException e25) {
            type = 9;
        }
        catch (Exception e26) {
            type = 5;
        }
        catch (Throwable e27) {
            type = 0;
        }
        short s2 = offset;
        offset = (short)(offset + 1);
        buffer[s2] = tag;
        short s3 = offset;
        offset = (short)(offset + 1);
        buffer[s3] = type;
        return Util.setShort(buffer, offset, reason);
    }

    private short writeRef(Remote data, byte[] buffer, short offset) {
        if (data == null) {
            return this.writeNullRef(buffer, offset);
        }
        short objID = NativeMethods.getObjectID(data);
        if (!CardRemoteObject.isExported(data) && !this.isExportedForSession(objID)) {
            return this.writeNullRef(buffer, offset);
        }
        if (JCSystem.getTransactionDepth() != 0 && NativeMethods.isWithinTransactionLogs(objID)) {
            TransactionException.throwIt((short)1);
        }
        this.exportForSession(data);
        offset = Util.setShort(buffer, offset, objID);
        offset = RMINativeMethods.getAnticollisionString(data, buffer, (byte)offset);
        if (this.ref_type == 1) {
            int nameAddr = RMINativeMethods.getClassNameAddress(data);
            offset = PrivAccess.getPrivAccess().getPkgNameForClass(nameAddr, buffer, (byte)offset);
            offset = RMINativeMethods.copyStringIntoBuffer(nameAddr, buffer, offset);
        } else {
            byte intfCount = RMINativeMethods.getRemoteInterfaceNumber(data);
            short s2 = offset;
            offset = (short)(offset + 1);
            buffer[s2] = intfCount;
            byte lastPkgID = -1;
            for (byte i2 = 0; i2 < intfCount; i2 = (byte)(i2 + 1)) {
                int intfAddr = RMINativeMethods.getRemoteInterfaceAddress(data, i2);
                byte pkgID = PrivAccess.getPrivAccess().getPkgIDForAddress(intfAddr);
                if (pkgID == lastPkgID) {
                    short s3 = offset;
                    offset = (short)(offset + 1);
                    buffer[s3] = 0;
                } else {
                    offset = PrivAccess.getPrivAccess().getPkgNameForClass(intfAddr, buffer, (byte)offset);
                }
                lastPkgID = pkgID;
                offset = RMINativeMethods.copyInterfaceNameIntoBuffer(intfAddr, buffer, offset);
            }
        }
        return offset;
    }

    private short writeNullRef(byte[] buffer, short offset) {
        return Util.setShort(buffer, offset, (short)-1);
    }

    private void exportForSession(Remote obj) throws ArrayIndexOutOfBoundsException {
        short objID = NativeMethods.getObjectID(obj);
        if (!this.isExportedForSession(objID)) {
            int i2 = 0;
            while (true) {
                if (this.expArray[i2] == null) {
                    this.expArray[i2] = obj;
                    return;
                }
                i2 = (short)(i2 + 1);
            }
        }
    }

    private boolean isExportedForSession(short objID) {
        for (short i2 = 0; i2 < (short)this.expArray.length; i2 = (short)(i2 + 1)) {
            if (NativeMethods.getObjectID(this.expArray[i2]) != objID) continue;
            return true;
        }
        return false;
    }

    short writeInt(int data, byte[] buffer, short offset) {
        offset = Util.setShort(buffer, offset, (short)(data >> 16));
        return Util.setShort(buffer, offset, (short)data);
    }
}

