/*
 * Decompiled with CFR 0.152.
 */
package javacardx.biometry;

import com.sun.javacard.implBiometry.PasswordBioImpl;
import javacardx.biometry.BioException;
import javacardx.biometry.OwnerBioTemplate;

public final class BioBuilder {
    public static final byte FACIAL_FEATURE = 1;
    public static final byte VOICE_PRINT = 2;
    public static final byte FINGERPRINT = 3;
    public static final byte IRIS_SCAN = 4;
    public static final byte RETINA_SCAN = 5;
    public static final byte HAND_GEOMETRY = 6;
    public static final byte SIGNATURE = 7;
    public static final byte KEYSTROKES = 8;
    public static final byte LIP_MOVEMENT = 9;
    public static final byte THERMAL_FACE = 10;
    public static final byte THERMAL_HAND = 11;
    public static final byte GAIT_STYLE = 12;
    public static final byte BODY_ODOR = 13;
    public static final byte DNA_SCAN = 14;
    public static final byte EAR_GEOMETRY = 15;
    public static final byte FINGER_GEOMETRY = 16;
    public static final byte PALM_GEOMETRY = 17;
    public static final byte VEIN_PATTERN = 18;
    public static final byte PASSWORD = 31;
    public static final byte DEFAULT_INITPARAM = 0;

    BioBuilder() {
    }

    public static OwnerBioTemplate buildBioTemplate(byte bioType, byte tryLimit) throws BioException {
        return BioBuilder.buildBioTemplate(bioType, tryLimit, null, (byte)0);
    }

    public static OwnerBioTemplate buildBioTemplate(byte bioType, byte tryLimit, byte[] RID, byte initParam) throws BioException {
        if (tryLimit < 1) {
            BioException.throwIt((short)1);
        }
        switch (bioType) {
            case 31: {
                if (!BioBuilder.isSunRid(RID)) break;
                return new PasswordBioImpl(tryLimit);
            }
        }
        BioException.throwIt((short)3);
        return null;
    }

    private static boolean isSunRid(byte[] rid) {
        if (rid == null) {
            return true;
        }
        if ((short)rid.length != 5) {
            return false;
        }
        return rid[0] == -96 && rid[1] == 0 && rid[2] == 0 && rid[3] == 0 && rid[4] == 98;
    }
}

