/*
 * Decompiled with CFR 0.152.
 */
package javacardx.framework.math;

import com.sun.javacard.impl.NativeMethods;
import javacard.framework.Util;

public final class BigNumber {
    public static final byte FORMAT_BCD = 1;
    public static final byte FORMAT_HEX = 2;
    byte[] number;
    byte[] maxValue;
    static final byte MAX_BYTES_SUPPORTED = 8;

    public BigNumber(short maxBytes) {
        NativeMethods.checkForValidBNSize(BigNumber.getMaxBytesSupported(), maxBytes);
        this.number = new byte[maxBytes];
        this.maxValue = new byte[maxBytes];
        Util.arrayFillNonAtomic(this.maxValue, (short)0, maxBytes, (byte)-1);
    }

    public void setMaximum(byte[] maxValue, short bOff, short bLen, byte arrayFormat) {
        NativeMethods.setMaxBNValue(maxValue, bOff, bLen, arrayFormat, this.maxValue, this.number);
    }

    public static short getMaxBytesSupported() {
        return 8;
    }

    public void init(byte[] bArray, short bOff, short bLen, byte arrayFormat) throws NullPointerException, ArrayIndexOutOfBoundsException, ArithmeticException {
        NativeMethods.initBigNumber(bArray, bOff, bLen, arrayFormat, this.number, this.maxValue);
    }

    public void add(byte[] bArray, short bOff, short bLen, byte arrayFormat) throws NullPointerException, ArrayIndexOutOfBoundsException, ArithmeticException {
        NativeMethods.addBigNumbers(bArray, bOff, bLen, arrayFormat, this.number, this.maxValue);
    }

    public void subtract(byte[] bArray, short bOff, short bLen, byte arrayFormat) throws ArithmeticException {
        NativeMethods.subtractBigNumbers(bArray, bOff, bLen, arrayFormat, this.number, this.maxValue);
    }

    public void multiply(byte[] bArray, short bOff, short bLen, byte arrayFormat) throws ArithmeticException {
        NativeMethods.multiplyBigNumbers(bArray, bOff, bLen, arrayFormat, this.number, this.maxValue);
    }

    public byte compareTo(BigNumber operand) {
        return NativeMethods.compareBigNumbers(operand.number, (short)0, (short)operand.number.length, (byte)2, this.number);
    }

    public byte compareTo(byte[] bArray, short bOff, short bLen, byte arrayFormat) {
        return NativeMethods.compareBigNumbers(bArray, bOff, bLen, arrayFormat, this.number);
    }

    public void toBytes(byte[] outBuf, short bOff, short numBytes, byte arrayFormat) throws ArrayIndexOutOfBoundsException, NullPointerException {
        NativeMethods.bigNumberToBytes(outBuf, bOff, numBytes, arrayFormat, this.number);
    }

    public short getByteLength(byte arrayFormat) {
        return NativeMethods.getBNByteLength(this.number, arrayFormat);
    }

    public void reset() {
        Util.arrayFillNonAtomic(this.number, (short)0, (short)this.number.length, (byte)0);
    }
}

