/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.classfile.JMethod;
import com.sun.javacard.classfile.attributes.JCodeAttr;
import com.sun.javacard.classfile.attributes.JExceptionRecord;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.converters.InstrContainer;
import com.sun.javacard.converter.converters.MethodConverter;
import com.sun.javacard.jcfile.JcException;
import com.sun.javacard.jcfile.constants.JcConstantClassRef;
import com.sun.javacard.jcfile.constants.JcConstantPool;

public class ExceptionTableConverter {
    private MethodConverter method_converter;

    public ExceptionTableConverter(MethodConverter method_converter) {
        this.method_converter = method_converter;
    }

    public JcException[] convert() {
        JMethod java_method = this.method_converter.getJavaMethod();
        JCodeAttr code_attr = java_method.getCodeAttr();
        if (code_attr == null) {
            return new JcException[0];
        }
        if (java_method.getCode() == null) {
            return new JcException[0];
        }
        JExceptionRecord[] j_exceptions = code_attr.getExceptions();
        JcConstantPool jc_cp = this.method_converter.getJcConstantPool();
        JcException[] jc_exceptions = new JcException[j_exceptions.length];
        for (int i = 0; i < jc_exceptions.length; ++i) {
            int start_pc = j_exceptions[i].getStartPc();
            int start_label = this.getLabel(start_pc);
            int end_pc = j_exceptions[i].getEndPc();
            int end_label = this.getLabel(end_pc);
            int handler_pc = j_exceptions[i].getHandlerPc();
            int handler_label = this.getLabel(handler_pc);
            String catch_type_class = j_exceptions[i].getCatchTypeClass();
            JcConstantClassRef catch_type_classref = jc_cp.addConstantClassRef(catch_type_class);
            jc_exceptions[i] = new JcException(start_label, end_label, handler_label, catch_type_classref);
        }
        return jc_exceptions;
    }

    private int getLabel(int pc) {
        for (InstrContainer cur_instr_container = this.method_converter.getInstrContainers(); cur_instr_container != null; cur_instr_container = cur_instr_container.getNextInstrContainer()) {
            if (cur_instr_container.getJInstr().getPC() != pc) continue;
            int label = cur_instr_container.getLabel();
            if (label == -1) {
                throw new ConverterInternalError();
            }
            return label;
        }
        throw new ConverterInternalError();
    }
}

