/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.converters.InstrContainer;
import com.sun.javacard.converter.converters.OperandStackEntry;
import java.util.Stack;

public class OperandStack
implements Cloneable {
    private int max_stack_size = 0;
    private int current_stack_size = 0;
    private Stack operand_stack = new Stack();

    public int getMaxStackSize() {
        return this.max_stack_size;
    }

    public int getCurrentStackSize() {
        return this.current_stack_size;
    }

    public OperandStackEntry[] getStackEntries() {
        Object[] stack_entries = new OperandStackEntry[this.operand_stack.size()];
        this.operand_stack.copyInto(stack_entries);
        return stack_entries;
    }

    public void promote(int entry_num) {
        if (entry_num <= 0 || entry_num > this.operand_stack.size()) {
            throw new ConverterInternalError();
        }
        int element_num = this.operand_stack.size() - entry_num;
        OperandStackEntry stack_entry = (OperandStackEntry)this.operand_stack.elementAt(element_num);
        stack_entry.setType(3);
        ++this.current_stack_size;
        if (this.current_stack_size > this.max_stack_size) {
            this.max_stack_size = this.current_stack_size;
        }
    }

    public OperandStackEntry peek(int entry_num) {
        if (entry_num <= 0 || entry_num > this.operand_stack.size()) {
            throw new ConverterInternalError();
        }
        int element_num = this.operand_stack.size() - entry_num;
        return (OperandStackEntry)this.operand_stack.elementAt(element_num);
    }

    public void push(OperandStackEntry stack_entry) {
        this.current_stack_size += stack_entry.getSizeInWords();
        if (this.current_stack_size > this.max_stack_size) {
            this.max_stack_size = this.current_stack_size;
        }
        this.operand_stack.push(stack_entry);
    }

    public void push(int type, InstrContainer instr_container) {
        OperandStackEntry stack_entry = new OperandStackEntry(type, instr_container);
        this.operand_stack.push(stack_entry);
        this.current_stack_size += stack_entry.getSizeInWords();
        if (this.current_stack_size > this.max_stack_size) {
            this.max_stack_size = this.current_stack_size;
        }
    }

    public void push(int type, InstrContainer instr_container, boolean typeKnown) {
        OperandStackEntry stack_entry = new OperandStackEntry(type, instr_container);
        stack_entry.setTypeKnown(typeKnown);
        this.operand_stack.push(stack_entry);
        this.current_stack_size += stack_entry.getSizeInWords();
        if (this.current_stack_size > this.max_stack_size) {
            this.max_stack_size = this.current_stack_size;
        }
    }

    public OperandStackEntry pop() {
        if (this.operand_stack.isEmpty()) {
            return null;
        }
        OperandStackEntry stack_entry = (OperandStackEntry)this.operand_stack.pop();
        this.current_stack_size -= stack_entry.getSizeInWords();
        return stack_entry;
    }

    public void dup(InstrContainer instr_container) {
        OperandStackEntry stack_entry = (OperandStackEntry)this.operand_stack.peek();
        OperandStackEntry dup_stack_entry = (OperandStackEntry)stack_entry.clone();
        dup_stack_entry.setInstrContainer(instr_container);
        if (stack_entry.getType() == 1 || stack_entry.getType() == 2) {
            InstrContainer roll_back_point = stack_entry.getRollBackPoint() != null ? stack_entry.getRollBackPoint() : stack_entry.getInstrContainer();
            dup_stack_entry.setRollBackPoint(roll_back_point);
        }
        this.push(dup_stack_entry);
    }

    public void dup2(InstrContainer instr_container) {
        InstrContainer roll_back_point;
        OperandStackEntry entry1 = this.peek(1);
        OperandStackEntry entry2 = this.peek(2);
        OperandStackEntry dup_entry1 = (OperandStackEntry)entry1.clone();
        dup_entry1.setInstrContainer(instr_container);
        OperandStackEntry dup_entry2 = (OperandStackEntry)entry2.clone();
        dup_entry2.setInstrContainer(instr_container);
        if (entry1.getType() == 1 || entry1.getType() == 2) {
            roll_back_point = entry1.getRollBackPoint() != null ? entry1.getRollBackPoint() : entry1.getInstrContainer();
            dup_entry1.setRollBackPoint(roll_back_point);
        }
        if (entry2.getType() == 1 || entry2.getType() == 2) {
            roll_back_point = entry2.getRollBackPoint() != null ? entry2.getRollBackPoint() : entry2.getInstrContainer();
            dup_entry2.setRollBackPoint(roll_back_point);
        }
        this.push(dup_entry2);
        this.push(dup_entry1);
    }

    public void dup_x1(InstrContainer instr_container) {
        OperandStackEntry entry1 = this.pop();
        OperandStackEntry entry2 = this.pop();
        OperandStackEntry dup_entry1 = (OperandStackEntry)entry1.clone();
        dup_entry1.setInstrContainer(instr_container);
        if (entry1.getType() == 1 || entry1.getType() == 2) {
            InstrContainer roll_back_point = entry1.getRollBackPoint() != null ? entry1.getRollBackPoint() : entry1.getInstrContainer();
            dup_entry1.setRollBackPoint(roll_back_point);
        }
        this.push(dup_entry1);
        this.push(entry2);
        this.push(entry1);
    }

    public void dup_x2(InstrContainer instr_container) {
        OperandStackEntry entry1 = this.pop();
        OperandStackEntry entry2 = this.pop();
        OperandStackEntry entry3 = this.pop();
        OperandStackEntry dup_entry1 = (OperandStackEntry)entry1.clone();
        dup_entry1.setInstrContainer(instr_container);
        if (entry1.getType() == 1 || entry1.getType() == 2) {
            InstrContainer roll_back_point = entry1.getRollBackPoint() != null ? entry1.getRollBackPoint() : entry1.getInstrContainer();
            dup_entry1.setRollBackPoint(roll_back_point);
        }
        this.push(dup_entry1);
        this.push(entry3);
        this.push(entry2);
        this.push(entry1);
    }

    public void dup2_x1(InstrContainer instr_container) {
        InstrContainer roll_back_point;
        OperandStackEntry entry1 = this.pop();
        OperandStackEntry entry2 = this.pop();
        OperandStackEntry entry3 = this.pop();
        OperandStackEntry dup_entry1 = (OperandStackEntry)entry1.clone();
        dup_entry1.setInstrContainer(instr_container);
        OperandStackEntry dup_entry2 = (OperandStackEntry)entry2.clone();
        dup_entry2.setInstrContainer(instr_container);
        if (entry1.getType() == 1 || entry1.getType() == 2) {
            roll_back_point = entry1.getRollBackPoint() != null ? entry1.getRollBackPoint() : entry1.getInstrContainer();
            dup_entry1.setRollBackPoint(roll_back_point);
        }
        if (entry2.getType() == 1 || entry2.getType() == 2) {
            roll_back_point = entry2.getRollBackPoint() != null ? entry2.getRollBackPoint() : entry2.getInstrContainer();
            dup_entry2.setRollBackPoint(roll_back_point);
        }
        this.push(dup_entry2);
        this.push(dup_entry1);
        this.push(entry3);
        this.push(entry2);
        this.push(entry1);
    }

    public void dup2_x2(InstrContainer instr_container) {
        InstrContainer roll_back_point;
        OperandStackEntry entry1 = this.pop();
        OperandStackEntry entry2 = this.pop();
        OperandStackEntry entry3 = this.pop();
        OperandStackEntry entry4 = this.pop();
        OperandStackEntry dup_entry1 = (OperandStackEntry)entry1.clone();
        dup_entry1.setInstrContainer(instr_container);
        OperandStackEntry dup_entry2 = (OperandStackEntry)entry2.clone();
        dup_entry2.setInstrContainer(instr_container);
        if (entry1.getType() == 1 || entry1.getType() == 2) {
            roll_back_point = entry1.getRollBackPoint() != null ? entry1.getRollBackPoint() : entry1.getInstrContainer();
            dup_entry1.setRollBackPoint(roll_back_point);
        }
        if (entry2.getType() == 1 || entry2.getType() == 2) {
            roll_back_point = entry2.getRollBackPoint() != null ? entry2.getRollBackPoint() : entry2.getInstrContainer();
            dup_entry2.setRollBackPoint(roll_back_point);
        }
        this.push(dup_entry2);
        this.push(dup_entry1);
        this.push(entry4);
        this.push(entry3);
        this.push(entry2);
        this.push(entry1);
    }

    public void swap(InstrContainer instr_container) {
        OperandStackEntry entry1 = this.pop();
        OperandStackEntry entry2 = this.pop();
        this.push(entry1);
        this.push(entry2);
    }

    public synchronized Object clone() {
        try {
            OperandStack new_stack = (OperandStack)super.clone();
            new_stack.operand_stack = (Stack)this.operand_stack.clone();
            return new_stack;
        }
        catch (CloneNotSupportedException e) {
            throw new ConverterInternalError();
        }
    }
}

