/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.Aid;
import com.sun.javacard.jcasm.Assert;
import com.sun.javacard.jcasm.JCMethod;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class AppletDeclarator {
    protected Aid aid;
    protected String name;
    protected String installMethod;
    protected short installMethodAddr;
    protected JCMethod resolvedTo;

    public AppletDeclarator(Aid aid, String installMethod, String name) {
        this.aid = aid;
        this.installMethod = installMethod;
        this.name = name;
    }

    public Aid getAid() {
        return this.aid;
    }

    public String getName() {
        return this.name;
    }

    public String getInstallMethodName() {
        return this.installMethod;
    }

    public void setInstallMethodAddr(short addr) {
        this.installMethodAddr = addr;
    }

    public short getInstallMethodAddr() {
        return this.installMethodAddr;
    }

    public void resolve(JCMethod method) {
        this.resolvedTo = method;
    }

    public JCMethod resolve() {
        Assert.PreCondition(this.resolvedTo != null, "resolvedTo != null");
        return this.resolvedTo;
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            dos.writeByte(this.aid.getSize());
            dos.write(this.aid.toByteArray());
            dos.writeShort(this.installMethodAddr);
            dos.flush();
        }
        catch (IOException e) {
            return null;
        }
        return bos.toByteArray();
    }
}

