/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.Assert;
import java.lang.reflect.Modifier;

public abstract class Member {
    protected int attributes;
    protected String name;
    protected int line;
    protected int column;
    protected int relocAddr;
    protected boolean relocated;

    protected Member(int attributes, String name, int line, int column) {
        Assert.PreCondition(name != null, "name != null");
        this.attributes = attributes;
        this.name = name;
        this.line = line;
        this.column = column;
    }

    public int getAttributes() {
        return this.attributes;
    }

    public String getName() {
        return this.name;
    }

    public void relocate(int address) {
        this.relocAddr = address;
        this.relocated = true;
    }

    public boolean isRelocated() {
        return this.relocated;
    }

    public int getRelocAddr() {
        Assert.PreCondition(this.relocated, "!relocated");
        return this.relocAddr;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(Modifier.toString(this.attributes) + " " + this.name);
        return sb.toString();
    }
}

