/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.jcasm.Aid;
import com.sun.javacard.jcasm.AppletDeclarator;
import com.sun.javacard.jcasm.Assert;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.cap.Component;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class AppletComponent
extends Component {
    protected Vector appletVector = new Vector();

    AppletComponent(JCPackage p) {
        super(p);
    }

    void add(AppletDeclarator a) {
        this.appletVector.addElement(new AppletEntry(a.getAid(), a.resolve().getRelocAddr()));
    }

    public int size() {
        if (this.count() == 0) {
            return 0;
        }
        return super.size();
    }

    public int dataSize() {
        if (this.count() == 0) {
            return 0;
        }
        int size = 1;
        Enumeration e = this.appletVector.elements();
        while (e.hasMoreElements()) {
            AppletEntry ae = (AppletEntry)e.nextElement();
            size += ae.getSize();
        }
        return size;
    }

    int count() {
        return this.appletVector.size();
    }

    protected byte[] toByteArray() {
        if (this.size() == 0) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            byte[] header = super.toByteArray();
            dos.write(header, 0, header.length);
            dos.writeByte(this.appletVector.size());
            Enumeration e = this.appletVector.elements();
            while (e.hasMoreElements()) {
                AppletEntry ae = (AppletEntry)e.nextElement();
                byte[] array = ae.toByteArray();
                dos.write(array, 0, array.length);
            }
            dos.flush();
        }
        catch (IOException e) {
            return null;
        }
        Assert.PostCondition(this.size() == bos.size(), "size() != bos.size()");
        return bos.toByteArray();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append("Count: " + this.appletVector.size() + Msg.eol);
        Enumeration e = this.appletVector.elements();
        while (e.hasMoreElements()) {
            AppletEntry ae = (AppletEntry)e.nextElement();
            sb.append(ae.toString() + Msg.eol);
        }
        return sb.toString();
    }

    static class AppletEntry {
        private Aid aid;
        private int offset;

        AppletEntry(Aid aid, int offset) {
            this.aid = aid;
            this.offset = offset;
        }

        int getSize() {
            return this.aid.getSize() + 3;
        }

        byte[] toByteArray() {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            try {
                dos.writeByte(this.aid.getSize());
                byte[] array = this.aid.toByteArray();
                dos.write(array, 0, array.length);
                dos.writeShort(this.offset);
                dos.flush();
            }
            catch (IOException e) {
                return null;
            }
            return bos.toByteArray();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("AID_length: " + this.aid.getSize());
            sb.append(", AID: " + this.aid.toString());
            sb.append(", install_method_offset: " + this.offset);
            return sb.toString();
        }
    }
}

