/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.jcasm.ConstantPool;
import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.Info;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.cap.TypeDescriptorEntry;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class TypeDescriptorInfo {
    protected int token;
    protected TypeDescriptorEntry[] constantPoolTypes;
    protected Vector descVector;
    protected int descOffset;
    private int descBase;

    TypeDescriptorInfo(JCPackage pkg) {
        ConstantPool constantPool = pkg.getConstantPool();
        this.constantPoolTypes = new TypeDescriptorEntry[constantPool.getCount()];
        this.descVector = new Vector(constantPool.getCount());
        this.descBase = this.descOffset = 2 + constantPool.getCount() * 2;
        for (int i = 0; i < this.constantPoolTypes.length; ++i) {
            Info info = constantPool.getConstantPoolEntry(i);
            if (info.getType() == 1) continue;
            TypeDescriptorEntry desc = new TypeDescriptorEntry(pkg, info, this.descOffset);
            int index = this.descVector.indexOf(desc);
            if (index != -1) {
                desc = (TypeDescriptorEntry)this.descVector.elementAt(index);
            } else {
                this.descVector.addElement(desc);
                this.descOffset += desc.size();
            }
            this.constantPoolTypes[i] = desc;
        }
        Enumeration e = pkg.classElements();
        while (e.hasMoreElements()) {
            int index;
            TypeDescriptorEntry desc;
            JCClass c = (JCClass)e.nextElement();
            Enumeration g = c.methodElements();
            while (g.hasMoreElements()) {
                JCMethod m = (JCMethod)g.nextElement();
                desc = new TypeDescriptorEntry(m, this.descOffset);
                index = this.descVector.indexOf(desc);
                if (index != -1) continue;
                this.descVector.addElement(desc);
                this.descOffset += desc.size();
            }
            Enumeration h = c.fieldElements();
            while (h.hasMoreElements()) {
                Field f = (Field)h.nextElement();
                if (f.getDescriptor().isPrimitive() || (index = this.descVector.indexOf(desc = new TypeDescriptorEntry(f, this.descOffset))) != -1) continue;
                this.descVector.addElement(desc);
                this.descOffset += desc.size();
            }
        }
    }

    int getOffset(JCMethod m) {
        TypeDescriptorEntry desc = new TypeDescriptorEntry(m, this.descOffset);
        int index = this.descVector.indexOf(desc);
        if (index == -1) {
            this.descVector.addElement(desc);
            this.descOffset += desc.size();
        } else {
            desc = (TypeDescriptorEntry)this.descVector.elementAt(index);
        }
        return desc.getOffset();
    }

    int getOffset(Field f) {
        TypeDescriptorEntry desc = new TypeDescriptorEntry(f, this.descOffset);
        int index = this.descVector.indexOf(desc);
        if (index == -1) {
            this.descVector.addElement(desc);
            this.descOffset += desc.size();
        } else {
            desc = (TypeDescriptorEntry)this.descVector.elementAt(index);
        }
        return desc.getOffset();
    }

    int size() {
        int size = 2 + this.constantPoolTypes.length * 2;
        Enumeration f = this.descVector.elements();
        while (f.hasMoreElements()) {
            TypeDescriptorEntry desc = (TypeDescriptorEntry)f.nextElement();
            size += desc.size();
        }
        return size;
    }

    byte[] toByteArray() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(this.size());
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            dos.writeShort(this.constantPoolTypes.length);
            for (int i = 0; i < this.constantPoolTypes.length; ++i) {
                if (this.constantPoolTypes[i] == null) {
                    dos.writeShort(65535);
                    continue;
                }
                dos.writeShort(this.constantPoolTypes[i].getOffset());
            }
            Enumeration e = this.descVector.elements();
            while (e.hasMoreElements()) {
                TypeDescriptorEntry desc = (TypeDescriptorEntry)e.nextElement();
                byte[] array = desc.toByteArray();
                dos.write(array, 0, array.length);
            }
            dos.flush();
        }
        catch (IOException e) {
            return null;
        }
        return bos.toByteArray();
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("constant_pool_count: " + this.constantPoolTypes.length + Msg.eol);
        for (i = 0; i < this.constantPoolTypes.length; ++i) {
            if (i % 10 == 0) {
                sb.append("[" + i + "] ");
            }
            if (this.constantPoolTypes[i] == null) {
                sb.append(" " + Msg.toHexString((short)-1));
            } else {
                sb.append(" " + Msg.toHexString((short)this.constantPoolTypes[i].getOffset()));
            }
            if (i % 10 != 9) continue;
            sb.append(Msg.eol);
        }
        if (i % 10 != 0) {
            sb.append(Msg.eol);
        }
        sb.append("type_desc[]: " + Msg.eol);
        int offset = this.descBase;
        Enumeration e = this.descVector.elements();
        while (e.hasMoreElements()) {
            TypeDescriptorEntry desc = (TypeDescriptorEntry)e.nextElement();
            sb.append("[" + Msg.toHexString((short)offset) + "] " + desc + Msg.eol);
            offset += desc.size();
        }
        return sb.toString();
    }
}

