/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.clientsamples.transit;

import com.sun.javacard.clientsamples.transit.Terminal;

public class TransitTerminal
extends Terminal {
    TransitTerminal(String string, int n, byte[] byArray) throws Exception {
        super(string, n, byArray);
    }

    private void processEntry(short s) throws Exception {
        byte[] byArray = new byte[2];
        this.copyShort(s, byArray, 0);
        byte[] byArray2 = this.processRequest((byte)-63, byArray);
        if (byArray2 != null) {
            byte[] byArray3 = new byte[8];
            System.arraycopy(byArray2, 0, byArray3, 0, 8);
            short s2 = this.getShort(byArray2, 2);
            System.out.println("processEntry: [" + s + "] => " + "[ " + new String(byArray3) + ", " + s2 + "]");
        } else {
            System.out.println("processEntry: [" + s + "] => " + "error");
        }
    }

    private void processExit(byte by) throws Exception {
        byte[] byArray = new byte[]{by};
        byte[] byArray2 = this.processRequest((byte)-62, byArray);
        if (byArray2 != null) {
            byte[] byArray3 = new byte[8];
            System.arraycopy(byArray2, 0, byArray3, 0, 8);
            short s = this.getShort(byArray2, 2);
            System.out.println("processEntry: [" + by + "] => " + "[ " + new String(byArray3) + ", " + s + "]");
        } else {
            System.out.println("processEntry: [" + by + "] => " + "error");
        }
    }

    private static void usage() {
        TransitTerminal.commonUsage();
        System.out.println("<command list>: ([PROCESS_ENTRY <entry station id>]|[PROCESS_EXIT <transit fee>])*");
    }

    public static void main(String[] stringArray) throws Exception {
        int n = TransitTerminal.parseCommonArgs(stringArray);
        if (n <= 0) {
            TransitTerminal.usage();
            System.exit(3);
        }
        TransitTerminal transitTerminal = new TransitTerminal(hostName, port, staticKeyData);
        transitTerminal.powerUp();
        transitTerminal.selectApplet();
        transitTerminal.initializeSession();
        while (n < stringArray.length) {
            byte by;
            if (stringArray[n].equals("PROCESS_ENTRY")) {
                if (++n < stringArray.length) {
                    by = new Short(stringArray[n]).shortValue();
                    transitTerminal.processEntry(by);
                } else {
                    TransitTerminal.usage();
                    System.exit(3);
                }
            } else if (stringArray[n].equals("PROCESS_EXIT")) {
                if (++n < stringArray.length) {
                    by = new Byte(stringArray[n]);
                    transitTerminal.processExit(by);
                } else {
                    TransitTerminal.usage();
                    System.exit(3);
                }
            } else {
                TransitTerminal.usage();
                System.exit(3);
            }
            ++n;
        }
        transitTerminal.powerDown();
        System.exit(0);
    }
}

