/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.AbstrInterp;
import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ClassAndFieldDescriptor;
import com.sun.javacard.offcardverifier.ClassAndMethodDescriptor;
import com.sun.javacard.offcardverifier.ClassDescriptor;
import com.sun.javacard.offcardverifier.Classref;
import com.sun.javacard.offcardverifier.ConstantPoolEntry;
import com.sun.javacard.offcardverifier.ExnHandler;
import com.sun.javacard.offcardverifier.ExnHandlerInfo;
import com.sun.javacard.offcardverifier.FieldTypeAndFlags;
import com.sun.javacard.offcardverifier.Fieldref;
import com.sun.javacard.offcardverifier.Instr;
import com.sun.javacard.offcardverifier.InstrLookupSwitch;
import com.sun.javacard.offcardverifier.InstrTableSwitch;
import com.sun.javacard.offcardverifier.MethodDescriptor;
import com.sun.javacard.offcardverifier.MethodInfo;
import com.sun.javacard.offcardverifier.MethodTypeAndFlags;
import com.sun.javacard.offcardverifier.Methodref;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.Type;
import com.sun.javacard.offcardverifier.TypeArray;
import com.sun.javacard.offcardverifier.TypeClass;
import com.sun.javacard.offcardverifier.TypeMethod;
import com.sun.javacard.offcardverifier.Verifier;
import com.sun.javacard.offcardverifier.VerifierError;

class Checkcode {
    Checkcode() {
    }

    static void typecheck(ClassDescriptor classDescriptor, MethodDescriptor methodDescriptor, MethodInfo methodInfo) {
        boolean bl;
        Safeptr safeptr;
        int n;
        int n2;
        int n3;
        if ((methodInfo.flags() & 8) == 0) {
            n3 = methodInfo.maxStackCompact();
            n2 = methodInfo.numArgsCompact();
            n = methodInfo.maxLocalsCompact() + n2;
            safeptr = methodInfo.bytecodeCompact();
        } else {
            n3 = methodInfo.maxStackExtended();
            n2 = methodInfo.numArgsExtended();
            n = methodInfo.maxLocalsExtended() + n2;
            safeptr = methodInfo.bytecodeExtended();
        }
        int n4 = methodDescriptor.bytecodeCount();
        int n5 = methodDescriptor.exnHandlerIndex();
        int n6 = methodDescriptor.exnHandlerCount();
        int n7 = methodDescriptor.flags();
        TypeMethod typeMethod = TypeMethod.parseCap(Cap.TypeDescr.at(methodDescriptor.type()));
        int n8 = typeMethod.args.length;
        if ((n7 & 8) == 0) {
            ++n8;
        }
        if (n2 != n8) {
            throw new VerifierError("Checkcode.1");
        }
        if (n > 255) {
            throw new VerifierError("Checkcode.41");
        }
        Instr[] instrArray = Instr.instrsBetween(safeptr, n4);
        Checkcode.staticCheck(classDescriptor, instrArray, n, typeMethod, n7);
        Checkcode.checkExnHandlers(safeptr, instrArray, n5, n6);
        TypeClass typeClass = (n7 & 8) == 0 ? new TypeClass(classDescriptor.thisClass()) : null;
        boolean bl2 = bl = (n7 & 0x80) != 0;
        if (Verifier.printTrace) {
            System.out.println("** Verifying method " + methodInfo.toString());
        }
        AbstrInterp.simulate(instrArray, n3, n, typeMethod, typeClass, bl, new TypeClass(classDescriptor.thisClass()));
    }

    private static void staticCheck(ClassDescriptor classDescriptor, Instr[] instrArray, int n, TypeMethod typeMethod, int n2) {
        int n3;
        Instr instr;
        block30: for (n3 = 0; n3 < instrArray.length; n3 += instr.length()) {
            try {
                instr = instrArray[n3];
                if (Instr.instrInt[instr.opcode]) {
                    Cap.Header.useInts();
                }
                block1 : switch (instr.opcode) {
                    case 21: 
                    case 22: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 40: 
                    case 41: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 89: 
                    case 114: 
                    case 150: {
                        if (instr.arg < n) break;
                        throw new VerifierError("Checkcode.3", instr.arg);
                    }
                    case 23: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 42: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 90: 
                    case 151: {
                        if (instr.arg + 1 < n) break;
                        throw new VerifierError("Checkcode.4", instr.arg);
                    }
                    case 63: {
                        int n4 = instr.arg;
                        int n5 = instr.arg2;
                        int n6 = Cap.Header.supportInts ? 4 : 2;
                        if (n4 >= 1 && n4 <= n6 && (n5 == 0 || n5 >= n4 && n5 <= n4 + n6)) break;
                        throw new VerifierError("Checkcode.5", n4, n5);
                    }
                    case 64: {
                        int n7 = instr.arg;
                        int n5 = instr.arg2;
                        int n6 = Cap.Header.supportInts ? 2 : 1;
                        if (n7 >= 1 && n7 <= n6 && n5 >= 1 && n5 <= n6) break;
                        throw new VerifierError("Checkcode.6", n7, n5);
                    }
                    case 115: 
                    case 116: {
                        int n5;
                        InstrTableSwitch instrTableSwitch = (InstrTableSwitch)instr;
                        if (instrTableSwitch.high < instrTableSwitch.low || instrTableSwitch.high - instrTableSwitch.low >= 65536) {
                            throw new VerifierError("Checkcode.7");
                        }
                        Checkcode.checkBranchTarget(instrArray, n3, instrTableSwitch.dfl);
                        for (n5 = 0; n5 < instrTableSwitch.offsets.length; ++n5) {
                            Checkcode.checkBranchTarget(instrArray, n3, instrTableSwitch.offsets[n5]);
                        }
                        continue block30;
                    }
                    case 117: 
                    case 118: {
                        int n5;
                        InstrLookupSwitch instrLookupSwitch = (InstrLookupSwitch)instr;
                        if (instrLookupSwitch.ncases >= 65536) {
                            throw new VerifierError("Checkcode.8");
                        }
                        Checkcode.checkBranchTarget(instrArray, n3, instrLookupSwitch.dfl);
                        for (n5 = 0; n5 < instrLookupSwitch.ncases; ++n5) {
                            Checkcode.checkBranchTarget(instrArray, n3, instrLookupSwitch.offsets[n5]);
                        }
                        for (n5 = 1; n5 < instrLookupSwitch.ncases; ++n5) {
                            if (instrLookupSwitch.keys[n5 - 1] < instrLookupSwitch.keys[n5]) continue;
                            throw new VerifierError("Checkcode.37");
                        }
                        continue block30;
                    }
                    case 119: {
                        if (typeMethod.res instanceof TypeClass || typeMethod.res instanceof TypeArray) break;
                        throw new VerifierError("Checkcode.9", typeMethod.res);
                    }
                    case 120: {
                        if (typeMethod.res.equals(Type.Short) || typeMethod.res.equals(Type.Byte) || typeMethod.res.equals(Type.Boolean)) break;
                        throw new VerifierError("Checkcode.10", typeMethod.res);
                    }
                    case 121: {
                        if (typeMethod.res.equals(Type.Int)) break;
                        throw new VerifierError("Checkcode.11", typeMethod.res);
                    }
                    case 122: {
                        if (typeMethod.res.equals(Type.Void)) break;
                        throw new VerifierError("Checkcode.12", typeMethod.res);
                    }
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 152: 
                    case 153: 
                    case 154: 
                    case 155: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: 
                    case 165: 
                    case 166: 
                    case 167: 
                    case 168: {
                        Checkcode.checkBranchTarget(instrArray, n3, instr.arg);
                        break;
                    }
                    case 139: {
                        if (Checkcode.checkCpoolIndex(instr.arg) != 3) {
                            throw new VerifierError("Checkcode.13");
                        }
                        Checkcode.checkAccessVirtualMethod(classDescriptor, instr.arg);
                        break;
                    }
                    case 140: {
                        int n8 = Checkcode.checkCpoolIndex(instr.arg);
                        switch (n8) {
                            case 7: {
                                Checkcode.checkAccessStaticMethod(classDescriptor, instr.arg);
                                break block1;
                            }
                            case 4: {
                                Checkcode.checkAccessSuperMethod(classDescriptor, instr.arg);
                                break block1;
                            }
                        }
                        throw new VerifierError("Checkcode.14");
                    }
                    case 141: {
                        if (Checkcode.checkCpoolIndex(instr.arg) != 6) {
                            throw new VerifierError("Checkcode.15");
                        }
                        Checkcode.checkAccessStaticMethod(classDescriptor, instr.arg);
                        break;
                    }
                    case 142: {
                        if (Checkcode.checkCpoolIndex(instr.arg) != 1) {
                            throw new VerifierError("Checkcode.16");
                        }
                        Checkcode.checkAccessClassref(classDescriptor, instr.arg);
                        break;
                    }
                    case 143: 
                    case 145: {
                        if (Checkcode.checkCpoolIndex(instr.arg) != 1) {
                            throw new VerifierError("Checkcode.17");
                        }
                        Checkcode.checkAccessClassref(classDescriptor, instr.arg);
                        break;
                    }
                    case 144: {
                        int n8 = instr.arg;
                        if (n8 < 10 || n8 > 13) {
                            throw new VerifierError("Checkcode.18", n8);
                        }
                        if (n8 != 13) break;
                        Cap.Header.useInts();
                        break;
                    }
                    case 148: 
                    case 149: {
                        int n8 = instr.arg;
                        if (n8 != 0 && (n8 < 10 || n8 > 14)) {
                            throw new VerifierError("Checkcode.19");
                        }
                        if (n8 == 0 || n8 == 14) {
                            if (Checkcode.checkCpoolIndex(instr.arg2) != 1) {
                                throw new VerifierError("Checkcode.20");
                            }
                            Checkcode.checkAccessClassref(classDescriptor, instr.arg2);
                        } else if (instr.arg2 != 0) {
                            throw new VerifierError("Checkcode.21");
                        }
                        if (n8 != 13) break;
                        Cap.Header.useInts();
                        break;
                    }
                    case 123: 
                    case 124: 
                    case 125: 
                    case 126: 
                    case 127: 
                    case 128: 
                    case 129: 
                    case 130: {
                        int n9 = instr.arg;
                        int n8 = instr.opcode - 123 & 3;
                        if (Checkcode.checkCpoolIndex(n9) != 5) {
                            throw new VerifierError("Checkcode.22");
                        }
                        Checkcode.staticCheckFieldref(n9, n8);
                        Checkcode.checkAccessStaticField(classDescriptor, n9, instr.opcode == 127 || instr.opcode == 128 || instr.opcode == 129 || instr.opcode == 130);
                        break;
                    }
                    case 131: 
                    case 132: 
                    case 133: 
                    case 134: 
                    case 135: 
                    case 136: 
                    case 137: 
                    case 138: {
                        int n9 = instr.arg;
                        int n8 = instr.opcode - 131 & 3;
                        if (Checkcode.checkCpoolIndex(n9) != 2) {
                            throw new VerifierError("Checkcode.23");
                        }
                        Checkcode.staticCheckFieldref(n9, n8);
                        Checkcode.checkAccessInstanceField(classDescriptor, n9, instr.opcode == 135 || instr.opcode == 136 || instr.opcode == 137 || instr.opcode == 138);
                        break;
                    }
                    case 169: 
                    case 170: 
                    case 171: 
                    case 172: 
                    case 177: 
                    case 178: 
                    case 179: 
                    case 180: {
                        int n9 = instr.arg;
                        int n8 = instr.opcode - 169 & 3;
                        if (Checkcode.checkCpoolIndex(n9) != 2) {
                            throw new VerifierError("Checkcode.24");
                        }
                        Checkcode.staticCheckFieldref(n9, n8);
                        Checkcode.checkAccessInstanceField(classDescriptor, n9, instr.opcode == 177 || instr.opcode == 178 || instr.opcode == 179 || instr.opcode == 180);
                        break;
                    }
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: 
                    case 181: 
                    case 182: 
                    case 183: 
                    case 184: {
                        if ((n2 & 8) != 0) {
                            throw new VerifierError("Checkcode.40");
                        }
                        int n9 = instr.arg;
                        int n8 = instr.opcode - 173 & 3;
                        if (Checkcode.checkCpoolIndex(n9) != 2) {
                            throw new VerifierError("Checkcode.26");
                        }
                        Checkcode.staticCheckFieldref(n9, n8);
                        Checkcode.checkAccessInstanceField(classDescriptor, n9, instr.opcode == 181 || instr.opcode == 182 || instr.opcode == 183 || instr.opcode == 184);
                    }
                }
                continue;
            }
            catch (VerifierError verifierError) {
                throw new VerifierError("Checkcode.27", n3, (Object)verifierError.getMessage());
            }
        }
        if (n3 != instrArray.length) {
            throw new VerifierError("Checkcode.28");
        }
    }

    private static void checkExnHandlers(Safeptr safeptr, Instr[] instrArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            ExnHandlerInfo exnHandlerInfo = Cap.Method.exceptionHandler(n + i);
            Safeptr safeptr2 = Cap.Method.methodCode(exnHandlerInfo.startOffset());
            Checkcode.checkExnTarget(instrArray, safeptr, safeptr2);
            Safeptr safeptr3 = Cap.Method.methodCode(exnHandlerInfo.endOffset());
            if (safeptr3.ofs != safeptr.ofs + instrArray.length) {
                Checkcode.checkExnTarget(instrArray, safeptr, safeptr3);
            }
            Safeptr safeptr4 = Cap.Method.methodCode(exnHandlerInfo.handlerOffset());
            Checkcode.checkExnTarget(instrArray, safeptr, safeptr4);
            int n3 = exnHandlerInfo.catchType();
            if (n3 == 0) {
                if (Checkcode.checkCpoolIndex(0) == 1 && Classref.isSubclass(Cap.ConstantPool.entry(0).classRef(), Classref.Throwable)) {
                    throw new VerifierError("Checkcode.43", n + i);
                }
            } else {
                if (Checkcode.checkCpoolIndex(n3) != 1) {
                    throw new VerifierError("Checkcode.29", n3, (Object)exnHandlerInfo);
                }
                if (!Classref.isSubclass(Cap.ConstantPool.entry(n3).classRef(), Classref.Throwable)) {
                    throw new VerifierError("Checkcode.38", n + i);
                }
            }
            int n4 = n3 != 0 ? Cap.ConstantPool.entry(n3).classRef() : Classref.Throwable;
            for (int j = safeptr2.ofs; j < safeptr3.ofs; ++j) {
                Instr instr = instrArray[j - safeptr.ofs];
                if (instr == null) continue;
                instr.handler = new ExnHandler(safeptr4.ofs - safeptr.ofs, n4, instr.handler);
            }
        }
    }

    private static void checkBranchTarget(Instr[] instrArray, int n, int n2) {
        int n3 = n + n2;
        if (n3 < 0 || n3 >= instrArray.length || instrArray[n3] == null) {
            throw new VerifierError("Checkcode.30", n3, n);
        }
    }

    private static void checkExnTarget(Instr[] instrArray, Safeptr safeptr, Safeptr safeptr2) {
        int n = safeptr2.ofs - safeptr.ofs;
        if (n < 0 || n >= instrArray.length || instrArray[n] == null) {
            throw new VerifierError("Checkcode.31", n);
        }
    }

    private static int checkCpoolIndex(int n) {
        if (n >= Cap.ConstantPool.count()) {
            throw new VerifierError("Checkcode.32", n);
        }
        return Cap.ConstantPool.entry(n).tag();
    }

    private static void staticCheckFieldref(int n, int n2) {
        Safeptr safeptr = Cap.TypeDescr.at(Cap.TypeDescr.constantPoolType(n));
        int n3 = safeptr.nibble(2);
        switch (n2) {
            case 0: {
                if (n3 != 6 && (n3 < 10 || n3 > 14)) break;
                return;
            }
            case 1: {
                if (n3 != 2 && n3 != 3) break;
                return;
            }
            case 2: {
                if (n3 != 4) break;
                return;
            }
            case 3: {
                if (n3 != 5) break;
                return;
            }
        }
        throw new VerifierError("Checkcode.33");
    }

    private static void canAccess(int n, int n2, int n3) {
        if ((n & 1) != 0) {
            return;
        }
        if ((n & 2) != 0) {
            if (n2 == n3) {
                return;
            }
            throw new VerifierError("Checkcode.34", n3, n2);
        }
        if ((n & 4) != 0) {
            if (!Classref.isExternal(n3)) {
                return;
            }
            if (Classref.isSubclass(n2, n3)) {
                return;
            }
            throw new VerifierError("Checkcode.35", n3, n2);
        }
        if (!Classref.isExternal(n3)) {
            return;
        }
        throw new VerifierError("Checkcode.36", n3, n2);
    }

    private static void checkAccessClassref(ClassDescriptor classDescriptor, int n) {
        int n2 = Cap.ConstantPool.entry(n).classRef();
        int n3 = Classref.checkAndGetAccessFlags(n2);
        Checkcode.canAccess(n3 & 1, classDescriptor.thisClass(), n2);
    }

    private static void checkAccessInstanceField(ClassDescriptor classDescriptor, int n, boolean bl) {
        ConstantPoolEntry constantPoolEntry = Cap.ConstantPool.entry(n);
        int n2 = constantPoolEntry.classRefVirtualRef();
        FieldTypeAndFlags fieldTypeAndFlags = Fieldref.findByToken(n2, constantPoolEntry.tokenVirtualRef(), false);
        Checkcode.canAccess(fieldTypeAndFlags.flags, classDescriptor.thisClass(), n2);
        if (bl && (fieldTypeAndFlags.flags & 0x10) != 0 && classDescriptor.thisClass() != n2) {
            throw new VerifierError("Checkcode.42");
        }
    }

    private static void checkAccessVirtualMethod(ClassDescriptor classDescriptor, int n) {
        ConstantPoolEntry constantPoolEntry = Cap.ConstantPool.entry(n);
        int n2 = constantPoolEntry.classRefVirtualRef();
        MethodTypeAndFlags methodTypeAndFlags = Methodref.findByToken(n2, constantPoolEntry.tokenVirtualRef(), false);
        Checkcode.canAccess(methodTypeAndFlags.flags, classDescriptor.thisClass(), n2);
    }

    private static void checkAccessSuperMethod(ClassDescriptor classDescriptor, int n) {
        ConstantPoolEntry constantPoolEntry = Cap.ConstantPool.entry(n);
        int n2 = constantPoolEntry.classRefVirtualRef();
        if (n2 != classDescriptor.thisClass()) {
            throw new VerifierError("Checkcode.44");
        }
        MethodTypeAndFlags methodTypeAndFlags = Methodref.findByToken(n2, constantPoolEntry.tokenVirtualRef(), false);
        Checkcode.canAccess(methodTypeAndFlags.flags, classDescriptor.thisClass(), n2);
    }

    private static void checkAccessStaticField(ClassDescriptor classDescriptor, int n, boolean bl) {
        int n2;
        int n3;
        ConstantPoolEntry constantPoolEntry = Cap.ConstantPool.entry(n);
        if (constantPoolEntry.isExternalStaticRef()) {
            n3 = constantPoolEntry.classStaticRef();
            FieldTypeAndFlags fieldTypeAndFlags = Fieldref.findByToken(n3, constantPoolEntry.tokenStaticRef(), true);
            n2 = fieldTypeAndFlags.flags;
        } else {
            ClassAndFieldDescriptor classAndFieldDescriptor = Fieldref.findDescr(constantPoolEntry.internalStaticRef());
            n3 = classAndFieldDescriptor.classDescr.thisClass();
            n2 = classAndFieldDescriptor.fieldDescr.flags();
        }
        Checkcode.canAccess(n2, classDescriptor.thisClass(), n3);
        if (bl && (n2 & 0x10) != 0) {
            throw new VerifierError("Checkcode.39");
        }
    }

    private static void checkAccessStaticMethod(ClassDescriptor classDescriptor, int n) {
        int n2;
        int n3;
        ConstantPoolEntry constantPoolEntry = Cap.ConstantPool.entry(n);
        if (constantPoolEntry.isExternalStaticRef()) {
            n3 = constantPoolEntry.classStaticRef();
            MethodTypeAndFlags methodTypeAndFlags = Methodref.findByToken(n3, constantPoolEntry.tokenStaticRef(), true);
            n2 = methodTypeAndFlags.flags;
        } else {
            ClassAndMethodDescriptor classAndMethodDescriptor = Methodref.findDescr(constantPoolEntry.internalStaticRef());
            n3 = classAndMethodDescriptor.classDescr.thisClass();
            n2 = classAndMethodDescriptor.methodDescr.flags();
        }
        Checkcode.canAccess(n2, classDescriptor.thisClass(), n3);
    }
}

