/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.AID;
import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ClassAndFieldDescriptor;
import com.sun.javacard.offcardverifier.ClassAndMethodDescriptor;
import com.sun.javacard.offcardverifier.ClassDescriptor;
import com.sun.javacard.offcardverifier.ClassInfo;
import com.sun.javacard.offcardverifier.Classref;
import com.sun.javacard.offcardverifier.ExportedClass;
import com.sun.javacard.offcardverifier.FieldDescriptor;
import com.sun.javacard.offcardverifier.FieldTypeAndFlags;
import com.sun.javacard.offcardverifier.Fieldref;
import com.sun.javacard.offcardverifier.ImportComponent;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.MethodDescriptor;
import com.sun.javacard.offcardverifier.MethodTypeAndFlags;
import com.sun.javacard.offcardverifier.Methodref;
import com.sun.javacard.offcardverifier.PackageInfo;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.Type;
import com.sun.javacard.offcardverifier.TypeMethod;
import com.sun.javacard.offcardverifier.Verifier;
import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.EfClass;
import com.sun.javacard.offcardverifier.exportfile.EfElement;
import com.sun.javacard.offcardverifier.exportfile.EfField;
import com.sun.javacard.offcardverifier.exportfile.EfMethod;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;
import java.util.TreeSet;
import java.util.Vector;

class ExportComponent
extends Safeptr {
    ExportFile exportfile = null;
    ExportFile thisExportFile = null;
    Vector alreadyVerified = new Vector();

    ExportComponent(byte[] byArray) {
        super(byArray, "Export");
    }

    int classCount() {
        return this.u1(0);
    }

    ExportedClass firstExportedClass() {
        return new ExportedClass(this.offset(1));
    }

    void findExportFile() {
        PackageInfo packageInfo = Cap.Header.thisPackage();
        this.exportfile = ImportComponent.findExportByAidAndVersion(packageInfo);
        this.thisExportFile = ImportComponent.findExportByAidAndVersion(packageInfo);
        if (this.exportfile == null) {
            throw new VerifierError("ExportComponent.1", (Object)AID.pretty(packageInfo), packageInfo.majorVersion(), packageInfo.minorVersion());
        }
    }

    void verify() {
        if (Verifier.verbose >= 2) {
            Messages.println("ExportComponent.101");
        }
        if (this.classCount() >= 256) {
            throw new VerifierError("ExportComponent.2", this.classCount());
        }
        if (this.classCount() == 0) {
            throw new VerifierError("ExportComponent.44");
        }
        ExportedClass exportedClass = this.firstExportedClass();
        for (int i = 0; i < this.classCount(); ++i) {
            this.verifyClass(i, exportedClass);
            exportedClass.next();
        }
        if (!exportedClass.atComponentEnd()) {
            throw new VerifierError("ExportComponent.3");
        }
        if (Verifier.verbose >= 2) {
            Messages.println("ExportComponent.102", this.exportfile.file);
        }
        this.verifyExport();
    }

    private void verifyClass(int n, ExportedClass exportedClass) {
        Safeptr safeptr;
        Object object;
        int n2;
        int n3;
        ClassDescriptor classDescriptor = Classref.checkInternal(exportedClass.classOffset());
        if ((classDescriptor.flags() & 1) == 0) {
            throw new VerifierError("ExportComponent.6", n);
        }
        if (classDescriptor.token() != n) {
            throw new VerifierError("ExportComponent.7", classDescriptor.token(), n);
        }
        if (exportedClass.staticFieldCount() > 256) {
            throw new VerifierError("ExportComponent.8", n, exportedClass.staticFieldCount());
        }
        for (n3 = 0; n3 < exportedClass.staticFieldCount(); ++n3) {
            n2 = exportedClass.staticFieldOffset(n3);
            object = Fieldref.findDescr(n2);
            safeptr = ((ClassAndFieldDescriptor)object).fieldDescr;
            if ((((FieldDescriptor)safeptr).flags() & 5) == 0) {
                throw new VerifierError("ExportComponent.9", n2);
            }
            if (((FieldDescriptor)safeptr).token() != n3) {
                throw new VerifierError("ExportComponent.10", ((FieldDescriptor)safeptr).token(), n3);
            }
            if (((ClassAndFieldDescriptor)object).classDescr.thisClass() == exportedClass.classOffset()) continue;
            throw new VerifierError("ExportComponent.47", n3, ((ClassAndFieldDescriptor)object).classDescr.thisClass(), exportedClass.classOffset());
        }
        if (exportedClass.staticFieldCount() != classDescriptor.num_exported_static_fields()) {
            throw new VerifierError("ExportComponent.45", exportedClass.classOffset());
        }
        if (exportedClass.staticMethodCount() > 256) {
            throw new VerifierError("ExportComponent.11", n);
        }
        for (n3 = 0; n3 < exportedClass.staticMethodCount(); ++n3) {
            n2 = exportedClass.staticMethodOffset(n3);
            object = Methodref.findDescr(n2);
            safeptr = ((ClassAndMethodDescriptor)object).methodDescr;
            if ((((MethodDescriptor)safeptr).flags() & 0x88) == 0) {
                throw new VerifierError("ExportComponent.12", n2);
            }
            if ((((MethodDescriptor)safeptr).flags() & 5) == 0) {
                throw new VerifierError("ExportComponent.13", n2);
            }
            if (((MethodDescriptor)safeptr).token() != n3) {
                throw new VerifierError("ExportComponent.14", ((MethodDescriptor)safeptr).token(), n3);
            }
            if (((ClassAndMethodDescriptor)object).classDescr.thisClass() == exportedClass.classOffset()) continue;
            throw new VerifierError("ExportComponent.48", n3, ((ClassAndMethodDescriptor)object).classDescr.thisClass(), exportedClass.classOffset());
        }
        if (exportedClass.staticMethodCount() != classDescriptor.num_exported_static_methods()) {
            throw new VerifierError("ExportComponent.46", exportedClass.classOffset());
        }
    }

    private void verifyExport() {
        boolean bl;
        if (!Cap.packageDirectory.equals(this.exportfile.thisName())) {
            throw new VerifierError("ExportComponent.39", (Object)this.exportfile.thisName(), (Object)Cap.packageDirectory);
        }
        boolean bl2 = (this.exportfile.thisPackage().flags & 1) != 0;
        if (bl2 != !(bl = (Cap.Header.flags() & 4) != 0)) {
            throw new VerifierError("ExportComponent.40");
        }
        for (int i = 0; i < this.exportfile.classes.length; ++i) {
            EfClass efClass = this.exportfile.classes[i];
            this.checkExportClass(efClass);
        }
        if (this.exportfile.classes.length != Cap.Export.classCount()) {
            throw new VerifierError("ExportComponent.41");
        }
    }

    private void checkExportClass(EfClass efClass) {
        try {
            EfElement efElement;
            int n;
            int n2 = Classref.forExportToken(efClass.token);
            ClassDescriptor classDescriptor = Classref.checkInternal(n2);
            int n3 = 0;
            if ((efClass.accessFlag & 1) != 0) {
                n3 |= 1;
            }
            if ((efClass.accessFlag & 0x10) != 0) {
                n3 |= 0x10;
            }
            if ((efClass.accessFlag & 0x200) != 0) {
                n3 |= 0x40;
            }
            if ((efClass.accessFlag & 0x400) != 0) {
                n3 |= 0x80;
            }
            if (n3 != classDescriptor.flags()) {
                throw new VerifierError("ExportComponent.18");
            }
            if (!this.allClaimedInterfaces(efClass).equals(this.allActualInterfaces(n2))) {
                throw new VerifierError("ExportComponent.19");
            }
            if (!this.allClaimedSuperclasses(efClass).equals(this.allActualSuperclasses(n2))) {
                throw new VerifierError("ExportComponent.20");
            }
            int n4 = 0;
            for (n = 0; n < efClass.fields.length; ++n) {
                efElement = efClass.fields[n];
                if (efElement.token == 255) {
                    if (!efElement.sig().equals("I")) continue;
                    Cap.Header.useInts();
                    continue;
                }
                this.checkExportField(efClass, (EfField)efElement, classDescriptor.thisClass());
                ++n4;
            }
            if (n4 != this.numPublicFields(classDescriptor)) {
                throw new VerifierError("ExportComponent.42");
            }
            for (n = 0; n < efClass.methods.length; ++n) {
                efElement = efClass.methods[n];
                ExportComponent.checkExportMethod(efClass, (EfMethod)efElement, classDescriptor.thisClass());
            }
            if (efClass.methods.length != this.numPublicMethods(classDescriptor)) {
                throw new VerifierError("ExportComponent.43");
            }
        }
        catch (VerifierError verifierError) {
            throw new VerifierError("ExportComponent.21", (Object)efClass, (Object)verifierError.getMessage());
        }
    }

    private void checkExportField(EfClass efClass, EfField efField, int n) {
        try {
            boolean bl = (efField.accessFlag & 8) != 0;
            FieldTypeAndFlags fieldTypeAndFlags = Fieldref.findByToken(n, efField.token, bl);
            int n2 = 0;
            if ((efField.accessFlag & 1) != 0) {
                n2 |= 1;
            }
            if ((efField.accessFlag & 4) != 0) {
                n2 |= 4;
            }
            if ((efField.accessFlag & 8) != 0) {
                n2 |= 8;
            }
            if ((efField.accessFlag & 0x10) != 0) {
                n2 |= 0x10;
            }
            if (n2 != fieldTypeAndFlags.flags) {
                throw new VerifierError("ExportComponent.28");
            }
            Type type = Type.parseExport(efField.sig());
            if (!type.equals(fieldTypeAndFlags.fty)) {
                throw new VerifierError("ExportComponent.29");
            }
        }
        catch (VerifierError verifierError) {
            throw new VerifierError("ExportComponent.30", (Object)efField, (Object)verifierError.getMessage());
        }
    }

    public static void checkExportMethod(EfClass efClass, EfMethod efMethod, int n) {
        try {
            boolean bl = (efMethod.accessFlag & 8) != 0 || efMethod.name().equals("<init>");
            MethodTypeAndFlags methodTypeAndFlags = Methodref.findByToken(n, efMethod.token, bl);
            if (methodTypeAndFlags == null) {
                throw new VerifierError("ExportComponent.38");
            }
            int n2 = 0;
            if ((efMethod.accessFlag & 1) != 0) {
                n2 |= 1;
            }
            if ((efMethod.accessFlag & 4) != 0) {
                n2 |= 4;
            }
            if ((efMethod.accessFlag & 8) != 0) {
                n2 |= 8;
            }
            if ((efMethod.accessFlag & 0x10) != 0) {
                n2 |= 0x10;
            }
            if ((efMethod.accessFlag & 0x400) != 0) {
                n2 |= 0x40;
            }
            if (efMethod.name().equals("<init>")) {
                n2 |= 0x80;
            }
            if (n2 != methodTypeAndFlags.flags) {
                throw new VerifierError("ExportComponent.33");
            }
            TypeMethod typeMethod = TypeMethod.parseExport(efMethod.sig());
            if (!typeMethod.equals(methodTypeAndFlags.mty)) {
                throw new VerifierError("ExportComponent.34");
            }
        }
        catch (VerifierError verifierError) {
            throw new VerifierError("ExportComponent.35", (Object)efMethod, (Object)verifierError.getMessage());
        }
    }

    private TreeSet allClaimedSuperclasses(EfClass efClass) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < efClass.supers.length; ++i) {
            treeSet.add(efClass.superName(i));
        }
        return treeSet;
    }

    private TreeSet allClaimedInterfaces(EfClass efClass) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < efClass.interfaces.length; ++i) {
            treeSet.add(efClass.interfaceName(i));
        }
        return treeSet;
    }

    private TreeSet allActualSuperclasses(int n) {
        EfClass efClass;
        TreeSet<String> treeSet = new TreeSet<String>();
        if ((Cap.Class.infoOfs(n).flags() & 8) != 0) {
            treeSet.add("java/lang/Object");
            return treeSet;
        }
        do {
            if ((n = Cap.Class.infoOfs(n).superclass()) == 65535) {
                return treeSet;
            }
            efClass = Classref.toExportClass(n);
            if (efClass == null) continue;
            treeSet.add(efClass.thisName());
        } while (!Classref.isExternal(n));
        efClass = Classref.toExportClass(n);
        treeSet.add(efClass.thisName());
        for (int i = 0; i < efClass.supers.length; ++i) {
            treeSet.add(efClass.superName(i));
        }
        return treeSet;
    }

    private TreeSet allActualInterfaces(int n) {
        TreeSet<String> treeSet = new TreeSet<String>();
        ClassInfo classInfo = Cap.Class.infoOfs(n);
        if ((classInfo.flags() & 8) != 0) {
            for (int i = 0; i < classInfo.interfaceCount(); ++i) {
                int n2 = classInfo.superinterface(i);
                this.addInterfaceAndSuperinterfaces(treeSet, n2);
            }
        } else {
            ClassDescriptor classDescriptor = Classref.checkInternal(n);
            for (int i = 0; i < classDescriptor.interfaceCount(); ++i) {
                int n3 = classDescriptor.interfaceRef(i);
                EfClass efClass = Classref.toExportClass(n3);
                if (efClass == null) continue;
                treeSet.add(efClass.thisName());
            }
            treeSet.addAll(this.allActualInterfacesFromSupers(n));
        }
        return treeSet;
    }

    private TreeSet allActualInterfacesFromSupers(int n) {
        TreeSet<String> treeSet = new TreeSet<String>();
        if (n != 65535) {
            EfClass efClass = Classref.toExportClass(n);
            if (Classref.isExternal(n)) {
                for (int i = 0; i < efClass.interfaces.length; ++i) {
                    treeSet.add(efClass.interfaceName(i));
                }
            } else {
                ClassDescriptor classDescriptor = Classref.checkInternal(n);
                for (int i = 0; i < classDescriptor.interfaceCount(); ++i) {
                    int n2 = classDescriptor.interfaceRef(i);
                    EfClass efClass2 = Classref.toExportClass(n2);
                    if (efClass2 == null) continue;
                    treeSet.add(efClass2.thisName());
                }
                ClassInfo classInfo = Cap.Class.infoOfs(classDescriptor.thisClass());
                treeSet.addAll(this.allActualInterfacesFromSupers(classInfo.superclass()));
            }
        }
        return treeSet;
    }

    private void addInterfaceAndSuperinterfaces(TreeSet treeSet, int n) {
        EfClass efClass = Classref.toExportClass(n);
        treeSet.add(efClass.thisName());
        if (Classref.isExternal(n)) {
            for (int i = 0; i < efClass.interfaces.length; ++i) {
                treeSet.add(efClass.interfaceName(i));
            }
        } else {
            ClassInfo classInfo = Cap.Class.infoOfs(n);
            for (int i = 0; i < classInfo.interfaceCount(); ++i) {
                int n2 = classInfo.superinterface(i);
                this.addInterfaceAndSuperinterfaces(treeSet, n2);
            }
        }
    }

    private boolean checkImplementedInterface(int n, String string) {
        if (!Classref.isExternal(n)) {
            ClassDescriptor classDescriptor = Classref.checkInternal(n);
            for (int i = 0; i < classDescriptor.interfaceCount(); ++i) {
                int n2 = classDescriptor.interfaceRef(i);
                EfClass efClass = Classref.toExportClass(n2);
                if (efClass != null && string.equals(efClass.thisName())) {
                    return true;
                }
                if (!this.checkImplementedInterface(n2, string)) continue;
                return true;
            }
            return false;
        }
        EfClass efClass = Classref.toExportClass(n);
        for (int i = 0; i < efClass.interfaces.length; ++i) {
            if (!string.equals(efClass.interfaceName(i))) continue;
            return true;
        }
        return false;
    }

    EfClass exportclassForToken(int n) {
        for (int i = 0; i < this.exportfile.classes.length; ++i) {
            EfClass efClass = this.exportfile.classes[i];
            if (efClass.token != n) continue;
            return efClass;
        }
        throw new VerifierError("ExportComponent.36", n);
    }

    private int numPublicFields(ClassDescriptor classDescriptor) {
        int n = 0;
        for (int i = 0; i < classDescriptor.fieldCount(); ++i) {
            FieldDescriptor fieldDescriptor = classDescriptor.fieldDescr(i);
            if ((fieldDescriptor.flags() & 5) == 0) continue;
            ++n;
        }
        return n;
    }

    private int numPublicMethods(ClassDescriptor classDescriptor) {
        Object object;
        int n;
        int n2 = 0;
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (n = 0; n < classDescriptor.methodCount(); ++n) {
            object = classDescriptor.methodDescr(n);
            if ((((MethodDescriptor)object).flags() & 5) == 0) continue;
            if ((((MethodDescriptor)object).flags() & 0x88) != 0) {
                ++n2;
                continue;
            }
            treeSet.add(new Integer(((MethodDescriptor)object).token()));
        }
        if ((classDescriptor.flags() & 0x40) == 0) {
            Object object2;
            int n3;
            n = classDescriptor.thisClass();
            while (!Classref.isExternal(n = Cap.Class.infoOfs(n).superclass())) {
                object = Classref.checkInternal(n);
                for (n3 = 0; n3 < ((ClassDescriptor)object).methodCount(); ++n3) {
                    object2 = ((ClassDescriptor)object).methodDescr(n3);
                    if ((((MethodDescriptor)object2).flags() & 5) == 0 || (((MethodDescriptor)object2).flags() & 0x88) != 0) continue;
                    treeSet.add(new Integer(((MethodDescriptor)object2).token()));
                }
            }
            if (n != 65535) {
                object = Classref.checkExternal(n);
                for (n3 = 0; n3 < ((EfClass)object).methods.length; ++n3) {
                    object2 = ((EfClass)object).methods[n3];
                    if (((EfMethod)object2).isStaticOrInit()) continue;
                    treeSet.add(new Integer(((EfMethod)object2).token));
                }
            }
        }
        return n2 + treeSet.size();
    }
}

