/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ClassComponent;
import com.sun.javacard.offcardverifier.ClassDescriptor;
import com.sun.javacard.offcardverifier.ClassInfo;
import com.sun.javacard.offcardverifier.Classref;
import com.sun.javacard.offcardverifier.ImplementedInterface;
import com.sun.javacard.offcardverifier.ImportComponent;
import com.sun.javacard.offcardverifier.MethodDescriptor;
import com.sun.javacard.offcardverifier.MethodTypeAndFlags;
import com.sun.javacard.offcardverifier.Methodref;
import com.sun.javacard.offcardverifier.PackageInfo;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.TypeMethod;
import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.EfClass;
import com.sun.javacard.offcardverifier.exportfile.EfElement;
import com.sun.javacard.offcardverifier.exportfile.EfMethod;
import com.sun.javacard.offcardverifier.exportfile.EfNames;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;
import java.util.Vector;

class RemoteInfo
extends Safeptr {
    int hashCollisionStringLength = -1;
    int nameOffset = -1;
    int HCSOffset = -1;
    int irio = -1;

    RemoteInfo(Safeptr safeptr) {
        super(safeptr);
    }

    int getRemoteMethodCount() {
        return this.u1(0);
    }

    Safeptr getRemoteMethodInfo(int n) {
        return this.offset(1 + 5 * n);
    }

    int getHCSOffset() {
        if (this.HCSOffset == -1) {
            this.HCSOffset = 1 + 5 * this.getRemoteMethodCount();
        }
        return this.HCSOffset;
    }

    int getHCSLength() {
        if (this.hashCollisionStringLength == -1) {
            this.hashCollisionStringLength = this.u1(this.getHCSOffset());
        }
        return this.hashCollisionStringLength;
    }

    int getClassNameOffset() {
        if (this.nameOffset == -1) {
            this.nameOffset = 1 + this.getHCSOffset() + this.getHCSLength();
        }
        return this.nameOffset;
    }

    int getClassNameLength() {
        return this.u1(this.getClassNameOffset());
    }

    Safeptr getName(int n) {
        return this.offset(n);
    }

    int getIRIO() {
        if (this.irio == -1) {
            this.irio = this.getClassNameOffset() + this.getClassNameLength() + 1;
        }
        return this.irio;
    }

    int getRemoteInterfaceCount() {
        return this.u1(this.getIRIO());
    }

    int findImplementedRemoteInterface(int n) {
        int n2 = this.getRemoteInterfaceCount();
        int n3 = this.getIRIO() + 1;
        for (int i = 0; i < n2; ++i) {
            int n4 = this.u2(n3 + i * 2);
            if (n4 != n) continue;
            return i;
        }
        return -1;
    }

    int getRemoteDataLength() {
        int n = 0;
        n = 1 + 5 * this.getRemoteMethodCount();
        n += 1 + this.getHCSLength();
        n += 1 + this.getClassNameLength();
        return n += 1 + 2 * this.getRemoteInterfaceCount();
    }

    void verifyRemoteInfo(ClassDescriptor classDescriptor, ClassInfo classInfo) {
        String string = null;
        PackageInfo packageInfo = Cap.Header.thisPackage();
        ExportFile exportFile = ImportComponent.findExportByAidAndVersion(packageInfo);
        if (this.getHCSLength() > 0) {
            Safeptr safeptr = this.offset(this.getHCSOffset() + 1);
            byte[] byArray = new byte[this.getHCSLength()];
            for (int i = 0; i < this.getHCSLength(); ++i) {
                byArray[i] = (byte)safeptr.u1(i);
            }
            string = new String(byArray);
        }
        this.verifyRemoteMethodInfo(classInfo);
        this.verifyClassName(classInfo);
        this.verifyRemoteInterfacesForClass(classDescriptor);
    }

    EfClass findClassByName(String string) {
        for (int i = 0; i < Cap.Import.importedPackages.size(); ++i) {
            ExportFile exportFile = (ExportFile)Cap.Import.importedPackages.get(i);
            EfClass efClass = exportFile.findClassByName(string);
            if (efClass == null) continue;
            return efClass;
        }
        return null;
    }

    boolean isExternalMethodRemote(EfClass efClass, EfMethod efMethod) {
        EfClass efClass2;
        int n;
        Vector<EfClass> vector = new Vector<EfClass>();
        for (n = 0; n < efClass.interfaces.length; ++n) {
            efClass2 = this.findClassByName(efClass.interfaceName(n));
            if (efClass2 == null) continue;
            vector.add(efClass2);
        }
        for (n = 0; n < vector.size(); ++n) {
            efClass2 = (EfClass)vector.elementAt(n);
            for (int i = 0; i < efClass2.methods.length; ++i) {
                if (!efClass2.methods[i].name().equals(efMethod.name()) || !efClass2.methods[i].sig().equals(efMethod.sig())) continue;
                return (efClass2.accessFlag & 0x1000) != 0;
            }
        }
        return false;
    }

    void getMethodsFromExternalSuper(int n, Vector vector) {
        int n2 = Classref.packageToken(n);
        ExportFile exportFile = Cap.Import.exportfileForPackageToken(n2);
        EfClass efClass = Classref.checkExternal(n);
        for (int i = 0; i < efClass.methods.length; ++i) {
            if (!this.isExternalMethodRemote(efClass, efClass.methods[i])) continue;
            vector.add(new Integer(efClass.methods[i].token));
        }
    }

    Vector makeMasterRemoteMethodList(ClassInfo classInfo) {
        Safeptr safeptr;
        Vector<Integer> vector = new Vector<Integer>();
        int n = classInfo.superclass();
        while (n != 65535) {
            if (Classref.isExternal(n)) {
                this.getMethodsFromExternalSuper(n, vector);
                break;
            }
            safeptr = Cap.Class.infoOfs(n);
            vector.addAll(this.makeMasterRemoteMethodList((ClassInfo)safeptr));
            n = ((ClassInfo)safeptr).superclass();
        }
        safeptr = classInfo.firstImplementedInterface();
        for (int i = 0; i < classInfo.interfaceCount(); ++i) {
            Object object;
            boolean bl = false;
            int n2 = ((ImplementedInterface)safeptr).interfaceImpl();
            if (!Classref.isExternal(n2)) {
                object = Cap.Class.infoOfs(((ImplementedInterface)safeptr).interfaceImpl());
                if ((((ClassInfo)object).flags() & 2) > 0) {
                    bl = true;
                }
            } else {
                object = Classref.checkExternal(((ImplementedInterface)safeptr).interfaceImpl());
                if ((((EfClass)object).accessFlag & 0x1000) > 0) {
                    bl = true;
                }
            }
            if (bl) {
                int n3;
                if (n2 != Classref.Remote && (n3 = this.findImplementedRemoteInterface(n2)) < 0) {
                    throw new VerifierError("RemoteInfoError.42");
                }
                for (int j = 0; j < ((ImplementedInterface)safeptr).count(); ++j) {
                    int n4 = ((ImplementedInterface)safeptr).indexMethod(j);
                    if (this.findMethodWithToken(vector, n4) >= 0) continue;
                    vector.add(new Integer(n4));
                }
            }
            ((ImplementedInterface)safeptr).next();
        }
        return vector;
    }

    int findMethodWithToken(Vector vector, int n) {
        for (int i = 0; i < vector.size(); ++i) {
            int n2 = (Integer)vector.elementAt(i);
            if (n2 != n) continue;
            return i;
        }
        return -1;
    }

    void verifyRemoteMethodInfo(ClassInfo classInfo) {
        Vector vector = this.makeMasterRemoteMethodList(classInfo);
        int n = 0;
        int n2 = this.getRemoteMethodCount();
        if (n2 > 128 || n2 < 0) {
            throw new VerifierError("RemoteInfoError.12");
        }
        Vector<Integer> vector2 = new Vector<Integer>(n2);
        for (int i = 0; i < n2; ++i) {
            Safeptr safeptr = this.getRemoteMethodInfo(i);
            Integer n3 = new Integer(safeptr.u2(0));
            if (n > n3) {
                throw new VerifierError("RemoteInfoError.15");
            }
            if (vector2.indexOf(n3) != -1) {
                throw new VerifierError("RemoteInfoError.13");
            }
            n = n3;
            vector2.add(n3);
            int n4 = safeptr.u2(2);
            RemoteInfo.verifyRemoteMethodTypeDescr(Cap.Class.signaturePool.offset(n4));
            int n5 = safeptr.u1(4);
            MethodTypeAndFlags methodTypeAndFlags = Methodref.findByToken(classInfo.ofs, n5, false);
            this.checkIfMethodIsRemote(Cap.Class.signaturePool.offset(n4), n5, classInfo);
            int n6 = this.findMethodWithToken(vector, n5);
            if (n6 < 0) {
                throw new VerifierError("RemoteInfoError.43");
            }
            vector.remove(n6);
        }
        if (vector.size() > 0) {
            throw new VerifierError("RemoteInfoError.44");
        }
    }

    void checkIfMethodIsRemote(Safeptr safeptr, int n, ClassInfo classInfo) {
        while (classInfo != null) {
            int n2;
            int n3 = classInfo.interfaceCount();
            ImplementedInterface implementedInterface = classInfo.firstImplementedInterface();
            for (n2 = 0; n2 < n3; ++n2) {
                for (int i = 0; i < implementedInterface.count(); ++i) {
                    int n4 = implementedInterface.indexMethod(i);
                    if (n4 != n) continue;
                    if (!Classref.isExternal(implementedInterface.interfaceImpl())) {
                        this.checkInternalInterface(i, safeptr, implementedInterface);
                    } else {
                        this.checkExternalInterface(i, safeptr, implementedInterface, classInfo);
                    }
                    return;
                }
                implementedInterface.next();
            }
            n2 = classInfo.superclass();
            if (n2 == 65535) {
                classInfo = null;
                continue;
            }
            if (Classref.isExternal(n2)) {
                this.checkExternalClass(n2, n);
                break;
            }
            classInfo = Cap.Class.infoOfs(n2);
        }
    }

    private void checkInternalInterface(int n, Safeptr safeptr, ImplementedInterface implementedInterface) {
        ClassInfo classInfo = Cap.Class.infoOfs(implementedInterface.interfaceImpl());
        ClassDescriptor classDescriptor = Classref.checkInternal(implementedInterface.interfaceImpl());
        if (!Classref.extendsInterface(classDescriptor.thisClass(), Classref.Remote) && (classInfo.flags() & 2) != 0) {
            throw new VerifierError("RemoteInfoError.26");
        }
        for (int i = 0; i < classDescriptor.methodCount(); ++i) {
            MethodDescriptor methodDescriptor = classDescriptor.methodDescr(i);
            if (methodDescriptor.token() != n) continue;
            int n2 = methodDescriptor.type();
            Safeptr safeptr2 = Cap.TypeDescr.at(n2);
            if (this.matchDescriptors(safeptr, safeptr2)) {
                return;
            }
            throw new VerifierError("RemoteInfoError.40");
        }
    }

    private void checkExternalInterface(int n, Safeptr safeptr, ImplementedInterface implementedInterface, ClassInfo classInfo) {
        EfClass efClass = Classref.checkExternal(implementedInterface.interfaceImpl());
        if ((efClass.accessFlag & 0x1000) == 0) {
            throw new VerifierError("RemoteInfoError.26");
        }
        for (int i = 0; i < efClass.methods.length; ++i) {
            EfMethod efMethod = efClass.methods[i];
            if (efMethod.token != n) continue;
            boolean bl = (efMethod.accessFlag & 8) != 0 || efMethod.name().equals("<init>");
            MethodTypeAndFlags methodTypeAndFlags = Methodref.findByToken(classInfo.ofs, efMethod.token, bl);
            if (methodTypeAndFlags == null) {
                throw new VerifierError("ExportComponent.38");
            }
            TypeMethod typeMethod = TypeMethod.parseExport(efMethod.sig());
            TypeMethod typeMethod2 = TypeMethod.parseCap(safeptr);
            if (!typeMethod2.equals(typeMethod)) continue;
            return;
        }
        throw new VerifierError("RemoteInfoError.27");
    }

    private void checkExternalClass(int n, int n2) {
        EfClass efClass;
        String string = null;
        String string2 = null;
        boolean bl = false;
        int n3 = 0;
        int n4 = Classref.packageToken(n);
        ExportFile exportFile = Cap.Import.exportfileForPackageToken(n4);
        EfClass efClass2 = efClass = Classref.checkExternal(n);
        do {
            EfElement efElement;
            int n5;
            for (n5 = 0; n5 < efClass.methods.length; ++n5) {
                efElement = efClass.methods[n5];
                if (efElement.token != n2) continue;
                string = efElement.name();
                string2 = efElement.sig();
                bl = true;
                break;
            }
            if (bl) {
                for (n5 = 0; n5 < efClass.interfaces.length; ++n5) {
                    efElement = exportFile.findClassByName(efClass.interfaceName(n5));
                    if (efElement == null) continue;
                    for (int i = 0; i < ((EfClass)efElement).methods.length; ++i) {
                        EfMethod efMethod = ((EfClass)efElement).methods[i];
                        if (!string.equals(efMethod.name()) || !string2.equals(efMethod.sig())) continue;
                        if ((((EfClass)efElement).accessFlag & 0x1000) == 0) {
                            throw new VerifierError("RemoteInfoError.26");
                        }
                        return;
                    }
                }
            }
            if (efClass2.supers.length <= n3) {
                throw new VerifierError("RemoteInfoError.4");
            }
            efClass = exportFile.findClassByName(efClass.superName(n3++));
        } while (efClass != null);
    }

    private boolean matchDescriptors(Safeptr safeptr, Safeptr safeptr2) {
        int n;
        int n2 = safeptr.u1(0);
        if (n2 != (n = safeptr2.u1(0))) {
            return false;
        }
        for (int i = 2; i <= n2 + 1; ++i) {
            if (safeptr.nibble(i) == safeptr2.nibble(i)) continue;
            return false;
        }
        return true;
    }

    static void verifyRemoteMethodTypeDescr(Safeptr safeptr) {
        int n;
        Safeptr safeptr2;
        int n2 = safeptr.u1(0);
        boolean bl = false;
        if (n2 >= 5) {
            safeptr2 = safeptr.offset(1);
            n = safeptr2.nibble(n2 - 5);
            if (n == 6) {
                Object object;
                int n3 = 0;
                for (int i = 1; i <= 4; ++i) {
                    n3 = n3 << 4 | safeptr2.nibble(n2 - 5 + i);
                }
                if (!Classref.isExternal(n3)) {
                    object = Cap.Class.infoOfs(n3);
                    if ((((ClassInfo)object).flags() & 2) == 0) {
                        throw new VerifierError("RemoteInfoError.21");
                    }
                    if ((((ClassInfo)object).flags() & 8) == 0) {
                        throw new VerifierError("RemoteInfoError.21");
                    }
                } else {
                    object = Classref.checkExternal(n3);
                    if ((((EfClass)object).accessFlag & 0x1000) == 0) {
                        throw new VerifierError("RemoteInfoError.21");
                    }
                    if ((((EfClass)object).accessFlag & 0x200) == 0) {
                        throw new VerifierError("RemoteInfoError.21");
                    }
                }
                n2 -= 5;
                bl = true;
            } else if (n == 14) {
                throw new VerifierError("RemoteInfoError.19");
            }
        }
        safeptr2 = safeptr.offset(1);
        if (n2 == 0 && !bl) {
            throw new VerifierError("RemoteInfoError.25");
        }
        block5: for (n = 0; n < n2; ++n) {
            switch (safeptr2.nibble(n)) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    continue block5;
                }
                case 6: 
                case 14: {
                    throw new VerifierError("RemoteInfoError.20", null);
                }
            }
            throw new VerifierError("RemoteInfoError.22", safeptr2.nibble(n), (Object)safeptr);
        }
        if (n > n2) {
            throw new VerifierError("RemoteInfoError.23", safeptr);
        }
        if (bl) {
            n2 += 5;
        }
        if ((n2 & 1) == 1 && safeptr2.nibble(n2) != 0) {
            throw new VerifierError("RemoteInfoError.24");
        }
    }

    void verifyClassName(ClassInfo classInfo) {
        String string;
        int n = this.getClassNameOffset() + 1;
        Safeptr safeptr = this.getName(n);
        int n2 = this.getClassNameLength();
        if (n2 > 0) {
            string = ClassInfo.getStringFromBytes(n2, safeptr);
            if (string.indexOf("/") > -1 || !EfNames.validClassName(string)) {
                throw new VerifierError("RemoteInfoError.11", string);
            }
            if (ClassComponent.classNamesVector.contains(string)) {
                throw new VerifierError("RemoteInfoError.14", string);
            }
        } else {
            throw new VerifierError("RemoteInfoError.10");
        }
        ClassComponent.classNamesVector.add(string);
    }

    void verifyRemoteInterfacesForClass(ClassDescriptor classDescriptor) {
        int n = this.getRemoteInterfaceCount();
        if (n > 128 || n < 0) {
            throw new VerifierError("RemoteInfoError.30");
        }
        int n2 = this.getIRIO() + 1;
        for (int i = 0; i < n; ++i) {
            Object object;
            int n3 = this.u2(n2 + i * 2);
            if (!Classref.isExternal(n3)) {
                object = Cap.Class.infoOfs(n3);
                if ((((ClassInfo)object).flags() & 2) == 0) {
                    throw new VerifierError("RemoteInfoError.45");
                }
            } else {
                object = Classref.checkExternal(n3);
                if ((((EfClass)object).accessFlag & 0x1000) == 0) {
                    throw new VerifierError("RemoteInfoError.45");
                }
            }
            if (ClassComponent.classInfoImplementsInterface(classDescriptor.thisClass(), n3)) continue;
            throw new VerifierError("RemoteInfoError.31");
        }
    }

    static void verifyRemoteInterface(ClassDescriptor classDescriptor) {
        if ((classDescriptor.flags() & 1) != 1) {
            throw new VerifierError("RemoteInfoError.41");
        }
        int n = classDescriptor.methodCount();
        for (int i = 0; i < n; ++i) {
            int n2 = classDescriptor.methodDescr(i).type();
            Safeptr safeptr = Cap.TypeDescr.at(n2);
            RemoteInfo.verifyRemoteMethodTypeDescr(safeptr);
        }
    }
}

