/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.ant.tasks;

import com.sun.javacard.ant.tasks.JavaCardServer;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class JCStartServerTask
extends Task {
    private String serverId;
    private String serverURLProperty;
    private String cardManagerURLProperty;
    private String targetProperty;
    private String toolsClassPathProperty;
    private boolean forDebug;
    private String warFile;
    private String serverNameProperty;

    public void setServerNameProperty(String s) {
        this.serverNameProperty = s;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public void setServerUrlProperty(String propertyName) {
        this.serverURLProperty = propertyName;
    }

    public void setCardManagerUrlProperty(String propertyName) {
        this.cardManagerURLProperty = propertyName;
    }

    public void setTargetProperty(String targetProperty) {
        this.targetProperty = targetProperty;
    }

    public void setToolsClassPathProperty(String tc) {
        this.toolsClassPathProperty = tc;
    }

    public boolean isForDebug() {
        return this.forDebug;
    }

    public void setForDebug(boolean forDebug) {
        this.forDebug = forDebug;
    }

    public String getWarFile() {
        return this.warFile;
    }

    public void setWarFile(String warFile) {
        this.warFile = warFile;
    }

    public void execute() throws BuildException {
        JavaCardServer server = JavaCardServer.getServer();
        if (server.getJcdkHome() == null) {
            throw new BuildException("JC_CONNECTED_HOME is not set/correct");
        }
        if (!new File(server.getJcdkHome(), "bin/cjcre.exe").exists()) {
            throw new BuildException("cjcre.exe not found. Make sure JC_CONNECTED_HOME is set correctly.");
        }
        server.startServer();
        if (this.serverURLProperty != null) {
            this.getProject().setProperty(this.serverURLProperty, server.getServerURL());
        }
        if (this.cardManagerURLProperty != null) {
            this.getProject().setProperty(this.cardManagerURLProperty, server.getCardManagerURL());
        }
        if (this.serverNameProperty != null) {
            this.getProject().setProperty(this.serverNameProperty, server.getDisplayName());
        }
        if (this.targetProperty != null) {
            this.getProject().setProperty(this.targetProperty, server.isRi() ? "RI" : "RC");
        }
        if (this.toolsClassPathProperty != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(new File(server.getJcdkHome(), "lib/ant-contrib-1.0b3.jar").getAbsolutePath());
            sb.append(File.pathSeparator);
            sb.append(new File(server.getJcdkHome(), "lib/commons-cli-1.0.jar").getAbsolutePath());
            sb.append(File.pathSeparator);
            sb.append(new File(server.getJcdkHome(), "lib/commons-codec-1.3.jar").getAbsolutePath());
            sb.append(File.pathSeparator);
            sb.append(new File(server.getJcdkHome(), "lib/commons-httpclient-3.0.jar").getAbsolutePath());
            sb.append(File.pathSeparator);
            sb.append(new File(server.getJcdkHome(), "lib/commons-logging-1.1.jar").getAbsolutePath());
            sb.append(File.pathSeparator);
            sb.append(new File(server.getJcdkHome(), "lib/tools.jar").getAbsolutePath());
            this.getProject().setProperty(this.toolsClassPathProperty, sb.toString());
        }
    }
}

