/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.apduio;

import com.sun.javacard.apduio.Apdu;
import com.sun.javacard.apduio.CadClientInterface;
import com.sun.javacard.apduio.CadT0;
import com.sun.javacard.apduio.CadTransportException;
import com.sun.javacard.apduio.ClientProtocol;
import com.sun.javacard.apduio.ClientT0Protocol;
import com.sun.javacard.apduio.TLP224Exception;
import com.sun.javacard.apduio.TLP224Message;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CadT0Client
extends CadT0
implements CadClientInterface {
    protected TLP224Message responseMsg;
    protected TLP224Message commandMsg = new TLP224Message(new byte[258]);
    protected ClientProtocol protocol;

    public CadT0Client(InputStream in, OutputStream out) {
        super(in, out);
        this.responseMsg = new TLP224Message(new byte[258]);
    }

    @Override
    public void exchangeApdu(Apdu apdu) throws IOException, CadTransportException {
        if (this.protocol == null) {
            throw new TLP224Exception(21);
        }
        this.protocol.exchangeApdu(apdu);
    }

    @Override
    public void powerDown() throws IOException, CadTransportException {
        this.powerDown(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void powerDown(boolean disconnect) throws IOException, CadTransportException {
        TLP224Message tLP224Message = this.commandMsg;
        synchronized (tLP224Message) {
            byte[] msgData = this.commandMsg.getData();
            msgData[0] = 96;
            msgData[1] = 1;
            msgData[2] = 77;
            msgData[3] = (byte)this.commandMsg.computeLRC(3);
            this.commandMsg.setLength(4);
            this.sendTLP224Message(this.commandMsg);
            this.receiveTLP224Message(this.responseMsg);
            msgData = this.responseMsg.getData();
            if (msgData[2] != 0) {
                throw new TLP224Exception(msgData[2] & 0xFF);
            }
        }
        this.protocol = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] powerUp() throws IOException, CadTransportException {
        byte[] atr = null;
        TLP224Message tLP224Message = this.commandMsg;
        synchronized (tLP224Message) {
            byte[] msgData = this.commandMsg.getData();
            msgData[0] = 96;
            msgData[1] = 4;
            msgData[2] = 110;
            msgData[3] = 0;
            msgData[4] = 0;
            msgData[5] = 0;
            msgData[6] = (byte)this.commandMsg.computeLRC(6);
            this.commandMsg.setLength(7);
            this.sendTLP224Message(this.commandMsg);
            this.receiveTLP224Message(this.responseMsg);
            msgData = this.responseMsg.getData();
            if (msgData[2] == 0) {
                atr = new byte[msgData[5]];
                System.arraycopy(msgData, 6, atr, 0, msgData[5]);
            } else {
                if (msgData[2] != -9) throw new TLP224Exception(msgData[2] & 0xFF);
                this.sendTLP224Message(this.commandMsg);
                this.receiveTLP224Message(this.responseMsg);
                if (msgData[2] != 0) throw new TLP224Exception(msgData[2] & 0xFF);
                atr = new byte[msgData[5]];
                System.arraycopy(msgData, 6, atr, 0, msgData[5]);
            }
        }
        this.protocol = new ClientT0Protocol(this);
        return atr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int isoIn(byte[] command, byte[] dataIn, int length, byte[] sw1sw2) throws IOException, TLP224Exception {
        if (length > 249) {
            throw new TLP224Exception(18);
        }
        TLP224Message tLP224Message = this.commandMsg;
        synchronized (tLP224Message) {
            byte[] msgData = this.commandMsg.getData();
            msgData[0] = 96;
            msgData[1] = (byte)(length + 6);
            msgData[2] = -38;
            System.arraycopy(command, 0, msgData, 3, 4);
            msgData[7] = (byte)length;
            if (length > 0) {
                System.arraycopy(dataIn, 0, msgData, 8, length);
            }
            msgData[length + 8] = (byte)this.commandMsg.computeLRC(length + 8);
            this.commandMsg.setLength(length + 9);
            this.sendTLP224Message(this.commandMsg);
            this.receiveTLP224Message(this.responseMsg);
            msgData = this.responseMsg.getData();
            sw1sw2[0] = msgData[3];
            sw1sw2[1] = msgData[4];
            return msgData[2] & 0xFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int isoOut(byte[] command, byte[] dataOut, int[] lengths, byte[] sw1sw2) throws IOException, TLP224Exception {
        int length = lengths[0];
        if (length > 249) {
            throw new TLP224Exception(18);
        }
        TLP224Message tLP224Message = this.commandMsg;
        synchronized (tLP224Message) {
            byte[] msgData = this.commandMsg.getData();
            msgData[0] = 96;
            msgData[1] = 6;
            msgData[2] = -37;
            System.arraycopy(command, 0, msgData, 3, 4);
            msgData[7] = (byte)length;
            msgData[8] = (byte)this.commandMsg.computeLRC(8);
            this.commandMsg.setLength(9);
            this.sendTLP224Message(this.commandMsg);
            this.receiveTLP224Message(this.responseMsg);
            msgData = this.responseMsg.getData();
            if (msgData[1] == 3) {
                sw1sw2[0] = msgData[3];
                sw1sw2[1] = msgData[4];
                lengths[1] = 0;
            } else {
                int len = this.responseMsg.getLength() - 6;
                System.arraycopy(msgData, 3, dataOut, 0, len);
                sw1sw2[0] = msgData[3 + len];
                sw1sw2[1] = msgData[4 + len];
                lengths[1] = len;
            }
            return msgData[2] & 0xFF;
        }
    }
}

