/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.classfile;

import com.sun.javacard.basicstructure.MethodDefinition;
import com.sun.javacard.classfile.attributes.JAttribute;
import com.sun.javacard.classfile.attributes.JCodeAttr;
import com.sun.javacard.classfile.attributes.JExceptionsAttr;
import com.sun.javacard.classfile.constants.JConstantPool;
import com.sun.javacard.classfile.instructions.JInstruction;
import java.io.DataInputStream;
import java.io.IOException;

public class JMethod
extends MethodDefinition {
    private JConstantPool constant_pool;
    private int name_index;
    private int descriptor_index;
    private JAttribute[] attributes = null;
    private JCodeAttr code_attr = null;
    private JExceptionsAttr exc_attr = null;

    public JCodeAttr getCodeAttr() {
        return this.code_attr;
    }

    public JInstruction getCode() {
        if (this.code_attr == null) {
            return null;
        }
        return this.code_attr.getCode();
    }

    public JAttribute[] getAttributes() {
        return this.attributes;
    }

    public JMethod(JConstantPool constant_pool) {
        this.constant_pool = constant_pool;
    }

    public JMethod(MethodDefinition md) {
        this.access_flags = 1025;
        this.method_name = md.getMethodName();
        this.descriptor = md.getMethodDescriptor();
        this.token = 255;
    }

    public void parse(DataInputStream dis) throws IOException {
        this.access_flags = dis.readUnsignedShort();
        this.name_index = dis.readUnsignedShort();
        this.descriptor_index = dis.readUnsignedShort();
        int attribute_count = dis.readUnsignedShort();
        this.attributes = new JAttribute[attribute_count];
        for (int i = 0; i < attribute_count; ++i) {
            int index = dis.readUnsignedShort();
            this.attributes[i] = JAttribute.create(this.constant_pool, index);
            this.attributes[i].parse(dis);
        }
    }

    public void resolve() {
        this.method_name = this.constant_pool.getConstantUtf8(this.name_index).getString();
        this.descriptor = this.constant_pool.getConstantUtf8(this.descriptor_index).getString();
        for (JAttribute element : this.attributes) {
            element.resolve();
            if (element instanceof JCodeAttr) {
                this.code_attr = (JCodeAttr)element;
                continue;
            }
            if (!(element instanceof JExceptionsAttr)) continue;
            this.exc_attr = (JExceptionsAttr)element;
        }
    }

    public boolean throwsRemoteExceptionOrSuper() {
        String[] excs;
        if (this.exc_attr == null) {
            return false;
        }
        for (String element : excs = this.exc_attr.getExcNames()) {
            if (!element.equals("java/lang/Throwable") && !element.equals("java/lang/Exception") && !element.equals("java/io/IOException") && !element.equals("java/rmi/RemoteException")) continue;
            return true;
        }
        return false;
    }
}

