/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.clientlib;

import com.sun.javacard.apduio.Apdu;
import com.sun.javacard.apduio.CadClientInterface;
import com.sun.javacard.apduio.CadDevice;
import com.sun.javacard.clientlib.CardAccessor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.Enumeration;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class ApduIOCardAccessor
implements CardAccessor {
    static boolean debug = false;
    private static ResourceBundle _messages = PropertyResourceBundle.getBundle("com/sun/javacard/clientlib/MessagesBundle");
    private ResourceBundle params = ResourceBundle.getBundle("jcclient");
    protected CadClientInterface cad;
    private static String[] dig = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};

    public ApduIOCardAccessor() throws Exception {
        String connection = this.params.getString("connection");
        if (connection.equals("TCP")) {
            String hostName = this.params.getString("TCP_HOST");
            int portNumber = Integer.parseInt(this.params.getString("TCP_PORT"));
            Socket sock = new Socket(hostName, portNumber);
            sock.setTcpNoDelay(true);
            BufferedInputStream bin = new BufferedInputStream(sock.getInputStream());
            BufferedOutputStream bos = new BufferedOutputStream(sock.getOutputStream());
            byte protocolType = 0;
            if (this.params.getString("protocol").equals("T0")) {
                protocolType = 0;
            } else if (this.params.getString("protocol").equals("T1")) {
                protocolType = 1;
            } else {
                throw new Exception(_messages.getString("error.1"));
            }
            this.cad = CadDevice.getCadClientInstance(protocolType, bin, bos);
        } else if (connection.equals("SERIAL")) {
            byte protocolType = 0;
            if (this.params.getString("protocol").equals("T0")) {
                protocolType = 0;
            } else if (this.params.getString("protocol").equals("T1")) {
                protocolType = 1;
            } else {
                throw new Exception(_messages.getString("error.2"));
            }
            this.cad = ApduIOCardAccessor.connectToSerialPort(this.params.getString("SERIAL_PORT"), protocolType);
        } else if (connection.equals("PCSC")) {
            System.out.println(_messages.getString("pcsc.1"));
            this.cad = CadDevice.getCadClientInstance((byte)-85, null, null);
        } else {
            throw new Exception(_messages.getString("error.3"));
        }
        byte[] ATR = this.cad.powerUp();
    }

    @Override
    public byte[] exchangeAPDU(byte[] capdu) throws IOException {
        try {
            Apdu apdu = ApduIOCardAccessor.cAPDUtoCrefapdu(capdu);
            if (debug) {
                System.out.println(apdu);
            }
            this.cad.exchangeApdu(apdu);
            byte[] buf = apdu.getResponseApduBytes();
            if (debug) {
                System.out.println(apdu);
            }
            int realLength = apdu.getLe() + 2;
            byte[] receiveData = new byte[realLength];
            System.arraycopy(buf, buf.length - realLength, receiveData, 0, realLength);
            byte SW1 = receiveData[receiveData.length - 2];
            byte SW2 = receiveData[receiveData.length - 1];
            System.arraycopy(receiveData, 0, receiveData, 2, receiveData.length - 2);
            receiveData[0] = SW1;
            receiveData[1] = SW2;
            if (debug) {
                for (int i = 0; i < receiveData.length; ++i) {
                    System.out.print(Integer.toHexString(receiveData[i] & 0xFF) + " ");
                }
                System.out.println();
                System.out.println();
            }
            return receiveData;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e);
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void closeCard() throws Exception {
        this.cad.powerDown(true);
    }

    private static Apdu cAPDUtoCrefapdu(byte[] capduBuffer) {
        Apdu apdu = new Apdu();
        System.arraycopy(capduBuffer, 0, apdu.command, 0, 4);
        if (capduBuffer.length != 4) {
            if (capduBuffer.length == 5) {
                int Le = capduBuffer[4] & 0xFF;
                if (Le == 0) {
                    Le = 256;
                }
                apdu.setLe(Le);
            } else if (capduBuffer.length == 7) {
                if (capduBuffer[4] == 0) {
                    apdu.setLe(ApduIOCardAccessor.makeShort(capduBuffer[5], capduBuffer[6]));
                    apdu.isExtended = true;
                } else if (capduBuffer[4] == 1) {
                    byte[] dataIn = new byte[]{capduBuffer[5]};
                    apdu.setDataIn(dataIn);
                    apdu.setLe(capduBuffer[6] & 0xFF);
                } else if (capduBuffer[4] == 2) {
                    byte[] dataIn = new byte[]{capduBuffer[5], capduBuffer[6]};
                    apdu.setDataIn(dataIn);
                }
            } else if (capduBuffer.length > 5) {
                if (capduBuffer[4] == 0) {
                    short Lc = ApduIOCardAccessor.makeShort(capduBuffer[5], capduBuffer[6]);
                    byte[] dataIn = new byte[Lc];
                    System.arraycopy(capduBuffer, 7, dataIn, 0, Lc);
                    apdu.setDataIn(dataIn);
                    if (capduBuffer.length == Lc + 9) {
                        short Le = ApduIOCardAccessor.makeShort(capduBuffer[capduBuffer.length - 2], capduBuffer[capduBuffer.length - 1]);
                        apdu.setLe(Le);
                        if (Le > 256) {
                            apdu.isExtended = true;
                        }
                    }
                } else {
                    int Lc = capduBuffer[4] & 0xFF;
                    byte[] dataIn = new byte[Lc];
                    System.arraycopy(capduBuffer, 5, dataIn, 0, Lc);
                    apdu.setDataIn(dataIn);
                    if (capduBuffer.length == Lc + 6) {
                        int Le = capduBuffer[capduBuffer.length - 1] & 0xFF;
                        Le = Le != 0 ? Le : 256;
                        apdu.setLe(Le);
                    }
                }
            }
        }
        return apdu;
    }

    private static short makeShort(byte b1, byte b2) {
        return (short)(((short)b1 << 8) + ((short)b2 & 0xFF));
    }

    private static void printArray(byte[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            if (i != 0 && i % 16 == 0) {
                System.out.println();
            }
            System.out.print(ApduIOCardAccessor.getHexString(arr[i]) + " ");
        }
        System.out.println();
    }

    static String getHexString(byte b) {
        return dig[(b & 0xFF) >> 4] + dig[b & 0xF];
    }

    private static CadClientInterface connectToSerialPort(String serialPortName, byte protocolType) throws Exception {
        try {
            Class<?> commPortClass = Class.forName("javax.comm.CommPort");
            Class<?> commPortIdentifierClass = Class.forName("javax.comm.CommPortIdentifier");
            Method getPortIdentifier = commPortIdentifierClass.getMethod("getPortIdentifier", String.class);
            Object portID = getPortIdentifier.invoke(null, serialPortName);
            Method portID_open = commPortIdentifierClass.getMethod("open", String.class, Integer.TYPE);
            Object commPort = portID_open.invoke(portID, "apdutool", new Integer(30000));
            Method commPortClass_getInputStream = commPortClass.getMethod("getInputStream", new Class[0]);
            Method commPortClass_getOutputStream = commPortClass.getMethod("getOutputStream", new Class[0]);
            InputStream is = (InputStream)commPortClass_getInputStream.invoke(commPort, new Object[0]);
            OutputStream os = (OutputStream)commPortClass_getOutputStream.invoke(commPort, new Object[0]);
            BufferedInputStream bin = new BufferedInputStream(is);
            BufferedOutputStream bos = new BufferedOutputStream(os);
            return CadDevice.getCadClientInstance(protocolType, bin, bos);
        }
        catch (ClassNotFoundException e) {
            throw new Exception(_messages.getString("error.4"));
        }
        catch (Exception e) {
            System.out.println(_messages.getString("error.5"));
            try {
                Class<?> commPortIdentifierClass = Class.forName("javax.comm.CommPortIdentifier");
                Method getPortIdentifiers = commPortIdentifierClass.getMethod("getPortIdentifiers", new Class[0]);
                Method getName = commPortIdentifierClass.getMethod("getName", new Class[0]);
                Enumeration list = (Enumeration)getPortIdentifiers.invoke(null, new Object[0]);
                System.out.println(_messages.getString("error.6"));
                if (list != null && list.hasMoreElements()) {
                    while (list.hasMoreElements()) {
                        Object port = list.nextElement();
                        System.out.println(getName.invoke(port, new Object[0]));
                    }
                } else {
                    System.out.println(_messages.getString("error.7"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new Exception(_messages.getString("error.8"));
        }
    }
}

