/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.components.caputils;

import com.sun.javacard.components.caputils.CPInfo;
import com.sun.javacard.components.caputils.Util;
import java.io.ByteArrayOutputStream;

public class CPClassMemberInfo
extends CPInfo {
    public static final int CONSTANT_Fieldref_tag = 9;
    public static final int CONSTANT_Methodref_tag = 10;
    public static final int CONSTANT_InterfaceMethodref_tag = 11;
    int tag;
    byte[] classIndex;
    byte[] nameAndTypeIndex;

    public CPClassMemberInfo(int tagValue) {
        this.tag = tagValue;
    }

    public CPClassMemberInfo(int tagValue, short classIdx, short nameAndTypeIdx) {
        this.tag = tagValue;
        this.classIndex = Util.getShortBytes(classIdx);
        this.nameAndTypeIndex = Util.getShortBytes(nameAndTypeIdx);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CPClassMemberInfo)) {
            return false;
        }
        CPClassMemberInfo classMemberInfo = (CPClassMemberInfo)obj;
        return this.tag == classMemberInfo.tag && Util.compareByteArrays(this.nameAndTypeIndex, classMemberInfo.nameAndTypeIndex) && Util.compareByteArrays(this.classIndex, classMemberInfo.classIndex);
    }

    @Override
    void write(ByteArrayOutputStream bos) {
        bos.write(this.tag);
        bos.write(this.classIndex, 0, 2);
        bos.write(this.nameAndTypeIndex, 0, 2);
    }

    @Override
    void print() {
        if (this.tag == 9) {
            System.out.println("\tCONSTANT_Field_info");
        } else if (this.tag == 10) {
            System.out.println("\tCONSTANT_Method_info");
        } else if (this.tag == 11) {
            System.out.println("\tCONSTANT_InterfaceMethod_info");
        } else {
            System.out.println("\tUnknown tag");
        }
        Util.printArray("\t\tClass Index: ", this.classIndex, 2);
        Util.printArray("\t\tName And Type Index: ", this.nameAndTypeIndex, 2);
    }
}

