/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.components.caputils;

import com.sun.javacard.components.caputils.CAPUtil;
import com.sun.javacard.components.caputils.ClassConstantPool;
import com.sun.javacard.components.caputils.ClassMemberInfo;
import com.sun.javacard.components.caputils.CodeAttribute;
import com.sun.javacard.components.caputils.ExceptionsAttribute;
import com.sun.javacard.components.caputils.instructions.Instruction;
import com.sun.javacard.components.caputils.instructions.JCConstInstr;
import com.sun.javacard.components.caputils.instructions.JCControlInstr;
import com.sun.javacard.components.caputils.instructions.JCFieldAccessInstr;
import com.sun.javacard.components.caputils.instructions.JCObjectInstr;
import com.sun.javacard.components.caputils.instructions.JCPushInstr;
import com.sun.javacard.components.caputils.instructions.JCStackInstr;
import com.sun.javacard.components.caputils.instructions.JCStoreInstr;
import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ClassDescriptor;
import com.sun.javacard.offcardverifier.FieldDescriptor;
import com.sun.javacard.offcardverifier.InitializedArray;
import com.sun.javacard.offcardverifier.MethodDescriptor;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.exportfile.EfClass;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ClassMethodTable {
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_PRIVATE = 2;
    public static final int ACC_PROTECTED = 4;
    public static final int ACC_STATIC = 8;
    public static final int ACC_FINAL = 16;
    public static final int ACC_SYNCHRONIZED = 32;
    public static final int ACC_NATIVE = 256;
    public static final int ACC_ABSTRACT = 1024;
    public static final int ACC_STRICT = 2048;
    private ClassConstantPool constantPool;
    private ClassDescriptor cdesc;
    Hashtable<String, ClassMemberInfo> classMethods;

    public ClassMethodTable(ClassConstantPool constantPool, ClassDescriptor cdesc, EfClass exportedClass) {
        this.cdesc = cdesc;
        this.constantPool = constantPool;
        this.classMethods = new Hashtable();
        int methodCount = cdesc.methodCount();
        for (int i = 0; i < methodCount; ++i) {
            MethodDescriptor md = cdesc.methodDescr(i);
            int flags = md.flags();
            boolean isStatic = (flags & 8) != 0;
            boolean isInit = (flags & 0x80) != 0;
            String methodName = CAPUtil.getClassMethodName(cdesc, md, isStatic, isInit, exportedClass);
            String methodDesc = CAPUtil.getMethodDescriptorString(md.type());
            int nameIndex = constantPool.getUtf8InfoIndex(methodName);
            int descIndex = constantPool.getUtf8InfoIndex(methodDesc);
            this.addMethod(md, nameIndex, descIndex);
        }
        this.createCLInitMethod(exportedClass);
    }

    public void addMethod(MethodDescriptor md, int nameIndex, int descIndex) {
        ClassMemberInfo methodInfo = new ClassMemberInfo();
        methodInfo.setAccessFlags(this.getMethodFlags((short)md.flags()));
        methodInfo.setNameIndex((short)nameIndex);
        methodInfo.setDescriptorIndex((short)descIndex);
        this.createMethodAttributes(md, methodInfo);
        this.classMethods.put(md.toString(), methodInfo);
    }

    private short getMethodFlags(short flagsFromCap) {
        short methodAccessFlags = 0;
        if ((flagsFromCap & 1) == 1) {
            methodAccessFlags = (short)(methodAccessFlags | 1);
        }
        if ((flagsFromCap & 2) == 2) {
            methodAccessFlags = (short)(methodAccessFlags | 2);
        }
        if ((flagsFromCap & 4) == 4) {
            methodAccessFlags = (short)(methodAccessFlags | 4);
        }
        if ((flagsFromCap & 8) == 8) {
            methodAccessFlags = (short)(methodAccessFlags | 8);
        }
        if ((flagsFromCap & 0x10) == 16) {
            methodAccessFlags = (short)(methodAccessFlags | 0x10);
        }
        if ((flagsFromCap & 0x40) == 64) {
            methodAccessFlags = (short)(methodAccessFlags | 0x400);
        }
        return methodAccessFlags;
    }

    private void createMethodAttributes(MethodDescriptor md, ClassMemberInfo methodInfo) {
        if ((md.flags() & 0x40) == 64) {
            return;
        }
        CodeAttribute codeAttribute = new CodeAttribute(this.constantPool, md);
        methodInfo.addAttribute(codeAttribute);
        ExceptionsAttribute ea = new ExceptionsAttribute(this.constantPool, md);
        if (ea.getExceptionsCount() > 0) {
            // empty if block
        }
    }

    private void createCLInitMethod(EfClass exportedClass) {
        boolean clinitRequired = false;
        int maxStackSize = 0;
        String className = CAPUtil.getRefName(this.cdesc.thisClass());
        Vector<Instruction> instructions = new Vector<Instruction>();
        int fieldCount = this.cdesc.fieldCount();
        for (int i = 0; i < fieldCount; ++i) {
            int j;
            int[] array;
            int arraySize;
            FieldDescriptor fd = this.cdesc.fieldDescr(i);
            String fieldName = CAPUtil.getClassFieldName(fd, exportedClass);
            String descStr = CAPUtil.getFieldDescrStr((short)fd.type());
            if ((fd.flags() & 8) != 8 || !Cap.StaticField.isStaticFieldInitialized(fd)) continue;
            clinitRequired = true;
            int fieldCPEntryIndex = this.constantPool.getCPEntryIndexForClassMember(className, fieldName, descStr, 9);
            int fieldOffset = fd.staticRef();
            if ((fd.type() & 0x8000) == 32768) {
                maxStackSize = maxStackSize < 4 ? 1 : maxStackSize;
                int value = Cap.StaticField.getPrimitiveFieldValue(fd);
                this.getPrimitiveInitInstrs(fieldCPEntryIndex, value, instructions);
                continue;
            }
            maxStackSize = 4;
            InitializedArray initArray = Cap.StaticField.getArrayInitValues(fd.staticRef());
            Safeptr values = initArray.values();
            if (descStr.equals("[Z") || descStr.equals("[B")) {
                arraySize = initArray.count();
                array = new int[arraySize];
                for (j = 0; j < arraySize; ++j) {
                    array[j] = (byte)values.u1(j);
                }
                this.getArrayInitInstrs(fieldCPEntryIndex, array, descStr.equals("[Z") ? 4 : 8, 84, instructions);
                continue;
            }
            if (descStr.equals("[S")) {
                arraySize = initArray.count() / 2;
                array = new int[arraySize];
                for (j = 0; j < arraySize; ++j) {
                    array[j] = values.u2(j * 2);
                }
                this.getArrayInitInstrs(fieldCPEntryIndex, array, 9, 86, instructions);
                continue;
            }
            if (!descStr.equals("[I")) continue;
            arraySize = initArray.count() / 4;
            array = new int[arraySize];
            for (j = 0; j < arraySize; ++j) {
                array[i] = values.s4(i * 4);
            }
            this.getArrayInitInstrs(fieldCPEntryIndex, array, 10, 79, instructions);
        }
        if (clinitRequired) {
            instructions.add(new JCControlInstr(177, null));
            ClassMemberInfo methodInfo = new ClassMemberInfo();
            methodInfo.setAccessFlags((short)8);
            short nameIndex = (short)this.constantPool.getUtf8InfoIndex("<clinit>");
            methodInfo.setNameIndex(nameIndex);
            short descIndex = (short)this.constantPool.getUtf8InfoIndex("()V");
            methodInfo.setDescriptorIndex(descIndex);
            CodeAttribute codeAttribute = new CodeAttribute(instructions, maxStackSize, 0, this.constantPool);
            methodInfo.addAttribute(codeAttribute);
            this.classMethods.put("<clinit>()", methodInfo);
        }
    }

    private void getPrimitiveInitInstrs(int fieldCPEntryIndex, int fieldValue, Vector<Instruction> instrs) {
        this.pushValueOnStack(fieldValue, instrs);
        instrs.add(new JCFieldAccessInstr(179, fieldCPEntryIndex));
    }

    private void getArrayInitInstrs(int fieldCPEntryIndex, int[] values, int arrayType, int arrayStoreInstr, Vector<Instruction> instrs) {
        this.pushValueOnStack(values.length, instrs);
        instrs.add(new JCObjectInstr(arrayType));
        for (int i = 0; i < values.length; ++i) {
            instrs.add(new JCStackInstr(89));
            this.pushValueOnStack(i, instrs);
            this.pushValueOnStack(values[i], instrs);
            instrs.add(new JCStoreInstr(arrayStoreInstr));
        }
        instrs.add(new JCFieldAccessInstr(179, fieldCPEntryIndex));
    }

    private void pushValueOnStack(int value, Vector<Instruction> instrs) {
        if (value >= -1 && value <= 5) {
            instrs.add(new JCConstInstr(value));
        } else {
            instrs.add(new JCPushInstr(value, this.constantPool));
        }
    }

    public Enumeration getClassMethods() {
        return this.classMethods.elements();
    }

    public short getMethodCount() {
        return (short)this.classMethods.size();
    }
}

