/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.SignaturePool;
import com.sun.javacard.jcasm.SortableVector;
import com.sun.javacard.jcasm.cap.Component;
import com.sun.javacard.jcasm.cap.TypeDescriptorEntry;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Map;

public class ClassComponent
extends Component {
    protected SortableVector<JCClass> classVector = new SortableVector();

    public ClassComponent(JCPackage p) {
        super(p);
    }

    void add(JCClass c) {
        this.classVector.addElement(c);
    }

    private int assignTempAddresses() {
        int address = 0;
        int size = 0;
        this.classVector.sort();
        for (JCClass c : this.classVector) {
            c.relocate(address);
            address += c.size();
        }
        size = this.getParentPackage().getSignaturePool().getSize() + 2;
        return size;
    }

    void assignAddresses() {
        int address = 0;
        if (this.getParentPackage().is22Package()) {
            address = this.assignTempAddresses();
        }
        this.classVector.sort();
        for (JCClass c : this.classVector) {
            c.relocate(address);
            address += c.size();
            int instanceFieldRelocPc = 0;
            Enumeration<Field> f = c.fieldElements();
            while (f.hasMoreElements()) {
                Field field = f.nextElement();
                if (Modifier.isStatic(field.getAttributes())) continue;
                field.relocate(instanceFieldRelocPc);
                instanceFieldRelocPc += Math.max(2, field.size());
            }
        }
    }

    @Override
    public int dataSize() {
        int size = 0;
        for (JCClass c : this.classVector) {
            size += c.size();
        }
        if (this.getParentPackage().is22Package()) {
            SignaturePool sigPool = this.getParentPackage().getSignaturePool();
            short len = (short)sigPool.getSize();
            size += len + 2;
        }
        return size;
    }

    @Override
    protected byte[] toByteArray() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            byte[] header = super.toByteArray();
            dos.write(header, 0, header.length);
            if (this.getParentPackage().is22Package()) {
                this.getParentPackage().purgeSignaturePool();
                SignaturePool sigPool = this.getParentPackage().getSignaturePool();
                short len = (short)sigPool.getSize();
                dos.writeShort(len);
                for (int i = 0; i < sigPool.methodSignaturePool.size(); ++i) {
                    TypeDescriptorEntry desc = sigPool.methodSignaturePool.elementAt(i);
                    byte[] data = desc.getData();
                    dos.write(data);
                }
            }
            for (JCClass c : this.classVector) {
                byte[] array = c.toByteArray();
                dos.write(array, 0, array.length);
            }
            dos.flush();
        }
        catch (IOException e) {
            return null;
        }
        assert (this.size() == bos.size()) : "size() != bos.size()";
        return bos.toByteArray();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        for (JCClass c : this.classVector) {
            byte[] array = c.toByteArray();
            sb.append("Class: " + Msg.toHexString(array) + Msg.eol);
        }
        return sb.toString();
    }

    protected void getDebugOffsets(Map<String, Integer> offsets) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            if (this.getParentPackage().is22Package()) {
                this.getParentPackage().purgeSignaturePool();
                SignaturePool sigPool = this.getParentPackage().getSignaturePool();
                short len = (short)sigPool.getSize();
                dos.writeShort(len);
                for (int i = 0; i < sigPool.methodSignaturePool.size(); ++i) {
                    TypeDescriptorEntry desc = sigPool.methodSignaturePool.elementAt(i);
                    byte[] data = desc.getData();
                    dos.write(data);
                }
            }
            for (JCClass c : this.classVector) {
                byte[] array = c.toByteArray();
                offsets.put(c.getName(), new Integer(dos.size()));
                dos.write(array, 0, array.length);
            }
        }
        catch (IOException e) {
            return;
        }
    }
}

