/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.jcasm.Aid;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.PackageIdentifier;
import com.sun.javacard.jcasm.cap.Component;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;

public class ImportComponent
extends Component {
    protected Vector<ImportEntry> importVector = new Vector();

    public ImportComponent(JCPackage p) {
        super(p);
    }

    public Aid getImportComponent(int index) {
        return this.importVector.elementAt((int)index).aid;
    }

    public void add(PackageIdentifier id) {
        Aid aid = id.getAid();
        int major = id.getMajorVersion();
        int minor = id.getMinorVersion();
        if (major < 0 || major > 255 || minor < 0 || minor > 255) {
            throw new IllegalArgumentException();
        }
        if (this.importVector.size() >= 255) {
            throw new InternalError();
        }
        this.importVector.addElement(new ImportEntry(aid, major, minor));
    }

    @Override
    public int dataSize() {
        int size = 1;
        for (ImportEntry ie : this.importVector) {
            size += ie.size();
        }
        return size;
    }

    int count() {
        return this.importVector.size();
    }

    @Override
    protected byte[] toByteArray() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            byte[] header = super.toByteArray();
            dos.write(header, 0, header.length);
            dos.writeByte(this.count());
            for (ImportEntry ie : this.importVector) {
                byte[] array = ie.toByteArray();
                dos.write(array, 0, array.length);
            }
            dos.flush();
        }
        catch (IOException e) {
            return null;
        }
        assert (this.size() == bos.size()) : "size() != bos.size()";
        return bos.toByteArray();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append("Count: " + this.importVector.size() + Msg.eol);
        for (ImportEntry ie : this.importVector) {
            sb.append(ie.toString() + Msg.eol);
        }
        return sb.toString();
    }

    static class ImportEntry {
        public Aid aid;
        private int major;
        private int minor;

        ImportEntry(Aid aid, int major, int minor) {
            this.aid = aid;
            this.major = major;
            this.minor = minor;
        }

        int size() {
            return this.aid.getSize() + 3;
        }

        byte[] toByteArray() {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            try {
                dos.writeByte(this.minor);
                dos.writeByte(this.major);
                dos.writeByte(this.aid.getSize());
                byte[] array = this.aid.toByteArray();
                dos.write(array, 0, array.length);
                dos.flush();
            }
            catch (IOException e) {
                return null;
            }
            assert (this.size() == bos.size()) : "size() != bos.size()";
            return bos.toByteArray();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("minor_version: " + this.minor + ", major_version: " + this.major + ", AID_length: " + this.aid.getSize());
            sb.append(", AID: " + this.aid.toString());
            return sb.toString();
        }
    }
}

