/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.AID;
import com.sun.javacard.offcardverifier.AIDintf;
import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.PackageInfo;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.Verifier;
import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.EfConstant_Package;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;
import java.io.File;
import java.util.BitSet;
import java.util.Vector;

public class ImportComponent
extends Safeptr {
    public Vector<ExportFile> importedPackages;
    private BitSet referencedImportedPackages;
    private int numImportedPackages;
    private static Vector<ExportFile> exportFiles = new Vector();

    ImportComponent(byte[] data) {
        super(data, "Import");
    }

    int count() {
        return this.u1(0);
    }

    PackageInfo packageInfo() {
        return new PackageInfo(this.offset(1));
    }

    void verify() {
        int count;
        if (Verifier.verbose >= 2) {
            Messages.println("ImportComponent.100");
        }
        if ((count = this.count()) > 128) {
            throw new VerifierError("ImportComponent.1", count);
        }
        this.importedPackages = new Vector(count);
        this.numImportedPackages = 0;
        PackageInfo pkg = this.packageInfo();
        for (int i = 0; i < count; ++i) {
            if (!AID.isValid(pkg)) {
                throw new VerifierError("ImportComponent.2", AID.pretty(pkg));
            }
            if (AID.same((AIDintf)pkg, Cap.Header.thisPackage())) {
                throw new VerifierError("ImportComponent.2", AID.pretty(pkg));
            }
            ExportFile ef = ImportComponent.findExportByAid(pkg);
            if (ef == null) {
                throw new VerifierError("ImportComponent.3", AID.pretty(pkg));
            }
            EfConstant_Package epkg = ef.thisPackage();
            if (pkg.majorVersion() != epkg.majorVersion || pkg.minorVersion() > epkg.minorVersion) {
                throw new VerifierError("ImportComponent.4", ef.thisName(), AID.pretty(pkg), pkg.majorVersion(), pkg.minorVersion(), epkg.majorVersion, epkg.minorVersion);
            }
            if (Verifier.verbose >= 2) {
                if (pkg.minorVersion() == epkg.minorVersion) {
                    Messages.println("ImportComponent.101", ef.thisName(), AID.pretty(pkg), pkg.majorVersion(), pkg.minorVersion());
                } else {
                    Messages.println("ImportComponent.102", ef.thisName(), AID.pretty(pkg), pkg.majorVersion(), pkg.minorVersion(), epkg.majorVersion, epkg.minorVersion);
                }
                Messages.println("ImportComponent.103", ef.file);
            }
            this.importedPackages.add(ef);
            ++this.numImportedPackages;
            pkg.next();
        }
        if (!pkg.atComponentEnd()) {
            throw new VerifierError("ImportComponent.5");
        }
    }

    ExportFile importPackage(int pkgTok) {
        if (pkgTok >= 0 && pkgTok < this.numImportedPackages) {
            if (this.referencedImportedPackages != null) {
                this.referencedImportedPackages.set(pkgTok);
            }
            return this.importedPackages.get(pkgTok);
        }
        return null;
    }

    public ExportFile exportfileForPackageToken(int pkgTok) {
        if (this.importedPackages == null) {
            this.verify();
        }
        if (this.referencedImportedPackages != null) {
            this.referencedImportedPackages.set(pkgTok);
        }
        return this.importedPackages.get(pkgTok);
    }

    int tokenForPackage(String pkgname) {
        for (int i = 0; i < this.importedPackages.size(); ++i) {
            ExportFile e = this.importedPackages.get(i);
            if (!pkgname.equals(e.thisName())) continue;
            if (this.referencedImportedPackages != null) {
                this.referencedImportedPackages.set(i);
            }
            return i;
        }
        ExportFile e = ImportComponent.findExportByName(pkgname);
        if (e == null) {
            throw new VerifierError("ImportComponent.6", pkgname);
        }
        this.importedPackages.add(e);
        return this.importedPackages.size() - 1;
    }

    void initialize() {
        this.referencedImportedPackages = new BitSet(this.count());
    }

    void checkUnreferencedPackages() {
        for (int pkgTok = 0; pkgTok < this.numImportedPackages; ++pkgTok) {
            if (this.referencedImportedPackages.get(pkgTok)) continue;
            VerifierError.warning("ImportComponent.105", this.importedPackages.get(pkgTok).thisName());
        }
    }

    static void resetExportFileList() {
        exportFiles = new Vector();
    }

    public static void readExportFile(File name) {
        ExportFile ef = ExportFile.readFromFile(name);
        ef.verify();
        exportFiles.add(ef);
        if (Verifier.verbose >= 2) {
            Messages.println("ImportComponent.104", name, ef.thisName(), ef.thisPackage().majorVersion, ef.thisPackage().minorVersion);
        }
    }

    static ExportFile findExportByAid(PackageInfo p) {
        ExportFile result = null;
        for (ExportFile ef : exportFiles) {
            EfConstant_Package pkg = ef.thisPackage();
            if (!AID.same((AIDintf)p, pkg.AID)) continue;
            if (result == null) {
                result = ef;
                continue;
            }
            throw new VerifierError("ImportComponent.7", (Object)result.file, (Object)ef.file);
        }
        return result;
    }

    public static ExportFile findExportByAidAndVersion(PackageInfo p) {
        String pkgAID = AID.pretty(p);
        int major = p.majorVersion();
        int minor = p.minorVersion();
        for (ExportFile ef : exportFiles) {
            EfConstant_Package pkg = ef.thisPackage();
            int pkgMajor = p.majorVersion();
            int pkgMinor = p.minorVersion();
            if (!AID.same((AIDintf)p, pkg.AID) || p.majorVersion() != pkg.majorVersion || p.minorVersion() != pkg.minorVersion) continue;
            return ef;
        }
        return null;
    }

    static Vector<ExportFile> findAllExportByAid(PackageInfo p) {
        Vector<ExportFile> result = new Vector<ExportFile>(4);
        for (ExportFile ef : exportFiles) {
            EfConstant_Package pkg = ef.thisPackage();
            if (!AID.same((AIDintf)p, pkg.AID)) continue;
            result.add(ef);
        }
        return result;
    }

    public static ExportFile findExportByName(String pkgname) {
        for (ExportFile ef : exportFiles) {
            if (!pkgname.equals(ef.thisName())) continue;
            return ef;
        }
        return null;
    }

    public static ExportFile findExportByFileName(String fileName) {
        for (ExportFile ef : exportFiles) {
            String efFileName = ef.file;
            if (!fileName.equals(ef.file)) continue;
            return ef;
        }
        return null;
    }
}

