/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.packager.model;

import com.sun.javacard.packager.ErrorKey;
import com.sun.javacard.packager.Packager;
import com.sun.javacard.packager.model.AppletXML;
import com.sun.javacard.packager.model.Module;
import java.io.File;

public class ClassicModule
extends Module {
    private AppletXML appletXML = null;

    public ClassicModule(String path) {
        super(path);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.isOk()) {
            return;
        }
        String infFolder = "APPLET-INF";
        File appletXMLFile = new File(this.folder, "APPLET-INF/applet.xml");
        if (appletXMLFile.exists()) {
            this.appletXML = new AppletXML(appletXMLFile);
            this.addItem(this.appletXML);
            this.appletXML.initialize();
        } else {
            String path = appletXMLFile.getAbsolutePath();
            this.addError(ErrorKey.AppletXmlFileDoesNotExists, path);
        }
        File classesFolder = new File(this.folder, infFolder + "/classes");
        if (!classesFolder.exists()) {
            classesFolder = null;
        }
    }

    @Override
    public void processInternal() {
        super.processInternal();
        if (!this.isOk()) {
            return;
        }
        this.appletXML.process();
        File toFolder = new File(Packager.getPackager().getWorkDir().getAbsolutePath());
        try {
            this.appletXML.saveCanonicalizedTo(new File(toFolder, "APPLET-INF/applet.xml"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AppletXML getAppletXML() {
        return this.appletXML;
    }
}

