/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.packager.model;

import com.sun.javacard.packager.Packager;
import com.sun.javacard.packager.model.Module;
import com.sun.javacard.packager.model.WebXML;
import java.io.File;

public class WebModule
extends Module {
    private WebXML webXML;

    public WebModule(String path) {
        super(path);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.isOk()) {
            return;
        }
        String infFolder = "WEB-INF";
        File webXMLFile = new File(this.folder, "WEB-INF/web.xml");
        if (webXMLFile.exists()) {
            this.webXML = new WebXML(webXMLFile);
            this.addItem(this.webXML);
            this.webXML.initialize();
        }
    }

    @Override
    public void processInternal() {
        super.processInternal();
        if (!this.isOk()) {
            return;
        }
        this.webXML.process();
        File toFolder = new File(Packager.getPackager().getWorkDir().getAbsolutePath());
        try {
            this.webXML.saveCanonicalizedTo(new File(toFolder, "WEB-INF/web.xml"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public WebXML getWebXML() {
        return this.webXML;
    }
}

