/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    public static void zip(File baseDir, File outFile, boolean compress) throws Exception {
        FileOutputStream fos = null;
        ZipOutputStream zipOutputStream = null;
        String basePath = baseDir.getAbsolutePath();
        if (!basePath.endsWith(File.pathSeparator)) {
            basePath = basePath + File.pathSeparator;
        }
        try {
            File[] files;
            fos = new FileOutputStream(outFile);
            zipOutputStream = new ZipOutputStream(fos);
            for (File f : files = baseDir.listFiles()) {
                ZipUtils.addToZipFile(f, zipOutputStream, compress, basePath);
            }
        }
        catch (Exception ex) {
            throw new Exception(ex.getMessage());
        }
        finally {
            if (zipOutputStream != null) {
                try {
                    zipOutputStream.close();
                }
                catch (IOException e) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static void addToZipFile(File file, ZipOutputStream zipOutputStream, boolean compress, String basePath) throws Exception {
        if (!file.exists()) {
            return;
        }
        String name = file.getAbsolutePath();
        name = name.substring(basePath.length());
        name = name.replace('\\', '/');
        ZipEntry zipEntry = null;
        if (file.isDirectory()) {
            File[] files;
            if (!name.endsWith("/")) {
                name = name + "/";
            }
            for (File f : files = file.listFiles()) {
                ZipUtils.addToZipFile(f, zipOutputStream, compress, basePath);
            }
            return;
        }
        byte[] data = null;
        data = new byte[(int)file.length()];
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            int read = fis.read(data);
            if (read != data.length) {
                throw new Exception("Reading problem for file " + file);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        zipEntry = new ZipEntry(name);
        if (compress) {
            zipEntry.setMethod(8);
        } else {
            zipEntry.setMethod(0);
            CRC32 crc32 = new CRC32();
            crc32.reset();
            crc32.update(data, 0, data.length);
            zipEntry.setCrc(crc32.getValue());
            zipEntry.setCompressedSize(data.length);
            zipEntry.setSize(data.length);
        }
        zipOutputStream.putNextEntry(zipEntry);
        zipOutputStream.write(data);
        zipOutputStream.closeEntry();
    }

    public static void unzip(File file, File destination) throws Exception {
        if (!file.exists()) {
            throw new Exception("File " + file + "does not exists.");
        }
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        File entryFile = null;
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            String entryName = zipEntry.getName();
            boolean isDir = zipEntry.isDirectory();
            entryFile = new File(destination, entryName);
            if (isDir) {
                entryFile.mkdirs();
                continue;
            }
            if (!entryFile.getParentFile().exists()) {
                entryFile.getParentFile().mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(entryFile);
            int read = 0;
            byte[] buffer = new byte[1024];
            InputStream is = zipFile.getInputStream(zipEntry);
            while ((read = is.read(buffer, 0, 1024)) > 0) {
                fos.write(buffer, 0, read);
            }
            fos.close();
        }
        zipFile.close();
    }

    public static void main(String[] args) {
        try {
            ZipUtils.zip(new File("./TestApp/valid"), new File("./ankiCompress.zip"), true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            ZipUtils.unzip(new File("./anki.zip"), new File("./ankiExplodeCompress"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

