/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.validator;

import com.sun.javacard.validator.Classes;
import com.sun.javacard.validator.ClassicModule;
import com.sun.javacard.validator.ClassicModuleJCRD;
import com.sun.javacard.validator.ErrorKey;
import com.sun.javacard.validator.ExtendedModule;
import com.sun.javacard.validator.ExtendedModuleJCRD;
import com.sun.javacard.validator.FolderOrJar;
import com.sun.javacard.validator.JavaCardXML;
import com.sun.javacard.validator.ModuleJCRD;
import com.sun.javacard.validator.WebModule;
import com.sun.javacard.validator.WebModuleJCRD;
import java.io.File;
import java.io.InputStream;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;

public abstract class Module
extends FolderOrJar {
    protected Classes classes;
    private JavaCardXML javaCardXML;
    protected ModuleJCRD jcrd;

    public Module(String path) {
        super(path);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.isOk()) {
            return;
        }
        File runtimeDescriptorFile = new File(this.folder, "META-INF/MANIFEST.MF");
        if (!runtimeDescriptorFile.exists()) {
            this.addError(ErrorKey.JCRDDoesNotExist, new Object[0]);
        } else {
            if (this instanceof WebModule) {
                this.jcrd = new WebModuleJCRD(this, runtimeDescriptorFile);
            } else if (this instanceof ExtendedModule) {
                this.jcrd = new ExtendedModuleJCRD(this, runtimeDescriptorFile);
            } else if (this instanceof ClassicModule) {
                this.jcrd = new ClassicModuleJCRD(this, runtimeDescriptorFile);
            }
            this.addItem(this.jcrd);
            this.jcrd.initialize();
        }
        File javaCardDescriptorFile = new File(this.folder, "META-INF/javacard.xml");
        if (javaCardDescriptorFile.exists()) {
            this.javaCardXML = new JavaCardXML(javaCardDescriptorFile);
            this.addItem(this.javaCardXML);
            this.javaCardXML.initialize();
        }
    }

    @Override
    public void processInternal() {
        if (!this.isOk()) {
            return;
        }
        this.jcrd.process();
        if (this.javaCardXML != null) {
            this.javaCardXML.process();
        }
        this.classes.processInternal();
    }

    @Override
    public String getItemDisplayName() {
        return "Module[" + this.folder.getName() + "]";
    }

    public boolean hasClass(String name) {
        if (this.classes.containsInAPI(name)) {
            return true;
        }
        return this.classes.getNames().contains(name);
    }

    private InputStream getClassFileStream(String name) {
        return this.classes.getClassFileStream(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInterface(String name) throws Exception {
        InputStream classFile = this.getClassFileStream(name);
        if (classFile == null) {
            throw new Exception("class does not exists");
        }
        ClassParser classParser = null;
        JavaClass javaClass = null;
        try {
            classParser = new ClassParser(classFile, "dummy");
            javaClass = classParser.parse();
            boolean bl = javaClass.isInterface();
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (classFile != null) {
                try {
                    classFile.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPublic(String name) throws Exception {
        InputStream classFile = this.getClassFileStream(name);
        if (classFile == null) {
            throw new Exception("class does not exists");
        }
        ClassParser classParser = null;
        JavaClass javaClass = null;
        try {
            classParser = new ClassParser(classFile, "dummy");
            javaClass = classParser.parse();
            boolean bl = javaClass.isPublic();
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (classFile != null) {
                try {
                    classFile.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConcreteClass(String name) {
        InputStream classFile = this.getClassFileStream(name);
        if (classFile == null) {
            return false;
        }
        ClassParser classParser = null;
        JavaClass javaClass = null;
        try {
            classParser = new ClassParser(classFile, "dummy");
            javaClass = classParser.parse();
            if (javaClass.isAbstract() || javaClass.isAbstract()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (classFile != null) {
                try {
                    classFile.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShareableInterface(String name) throws Exception {
        if (name.equals("javacard.framework.Shareable")) {
            return true;
        }
        InputStream classFile = this.getClassFileStream(name);
        if (classFile == null) {
            throw new Exception("File for class " + name + " does not exists.");
        }
        ClassParser classParser = null;
        JavaClass javaClass = null;
        try {
            classParser = new ClassParser(classFile, "dummy");
            javaClass = classParser.parse();
            if (javaClass.isInterface()) {
                for (String interfaceName : javaClass.getInterfaceNames()) {
                    if (!this.isShareableInterface(interfaceName)) continue;
                    boolean bl = true;
                    return bl;
                }
            } else {
                boolean arr$ = false;
                return arr$;
            }
            boolean arr$ = false;
            return arr$;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (classFile != null) {
                try {
                    classFile.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public JavaCardXML getJavaCardXML() {
        return this.javaCardXML;
    }

    public ModuleJCRD getJCRD() {
        return this.jcrd;
    }

    public Classes getClasses() {
        return this.classes;
    }
}

