/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.validator.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;

public final class StringUtils {
    private static final String[] JAVA_KEYWORDS = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};

    public static String lpad(String str, int length, char padChar) {
        int rem = length - str.length();
        if (rem <= 0) {
            return str;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < rem; ++i) {
            sb.append(padChar);
        }
        sb.append(str);
        return sb.toString();
    }

    public static String[] getTokens(String str, String delim) {
        StringTokenizer st = new StringTokenizer(str, delim);
        String[] tokens = new String[st.countTokens()];
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = st.nextToken().trim();
        }
        return tokens;
    }

    public static String[] getTokensInReverseOrder(String str, String delim) {
        StringTokenizer st = new StringTokenizer(str, delim);
        String[] tokens = new String[st.countTokens()];
        for (int i = tokens.length - 1; i >= 0; --i) {
            tokens[i] = st.nextToken().trim();
        }
        return tokens;
    }

    public static String replace(String str, String find, String rep) {
        int findIndex = -1;
        int startIndex = 0;
        StringBuffer sb = new StringBuffer(str);
        while ((findIndex = (str = sb.toString()).indexOf(find, startIndex)) != -1) {
            sb.replace(findIndex, findIndex + find.length(), rep);
            startIndex = findIndex + find.length();
        }
        return sb.toString();
    }

    public static String readFromFile(String fileName) {
        return StringUtils.readFromFile(new File(fileName));
    }

    public static String readFromFile(File file) {
        String content = "";
        try {
            int len = (int)file.length();
            byte[] b = new byte[len];
            FileInputStream fis = new FileInputStream(file);
            fis.read(b);
            content = new String(b);
            fis.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return content;
    }

    public static void writeToFile(String content, String fileName) {
        StringUtils.writeToFile(content, new File(fileName));
    }

    public static void writeToFile(String content, File file) {
        try {
            File f = file.getParentFile();
            if (!f.exists()) {
                f.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(content.getBytes());
            fos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String indentString(int indent) {
        return StringUtils.indentString(indent, 4);
    }

    public static String indentString(int indent, int indentSize) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < indent; ++i) {
            sb.append(StringUtils.getSpaces(indentSize));
        }
        return sb.toString();
    }

    public static String getSpaces(int size) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String arrayListToString(ArrayList<?> al, String seperator) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < al.size(); ++i) {
            if (i > 0) {
                sb.append(seperator);
            }
            sb.append(al.get(i));
        }
        return sb.toString();
    }

    public static ArrayList<String> stringToArrayList(String s, String seperator) {
        ArrayList<String> al = new ArrayList<String>();
        String[] tokens = StringUtils.getTokens(s, seperator);
        for (int i = 0; i < tokens.length; ++i) {
            al.add(tokens[i]);
        }
        return al;
    }

    public static String escapeString(String s) {
        s = s.replaceAll("\\\\n", "\n");
        s = s.replaceAll("\\\\t", "\t");
        return s;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(JAVA_KEYWORDS.length);
        System.out.println(StringUtils.isValidClassName("int"));
        System.out.println(StringUtils.isValidClassName("com.sun.Abcd"));
    }

    public static final boolean isValidClassName(String id) {
        if (id == null || id.equals("")) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(id.charAt(0))) {
            return false;
        }
        for (int i = 1; i < id.length(); ++i) {
            if (Character.isJavaIdentifierPart(id.charAt(i)) || id.charAt(i) == '.') continue;
            return false;
        }
        boolean keyword = Arrays.asList(JAVA_KEYWORDS).contains(id);
        return !keyword;
    }

    public static String getRIDFromAID(String aid) {
        String RID = aid.substring(6, aid.lastIndexOf("/"));
        return RID;
    }
}

