/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.EfNames;
import com.sun.javacard.jcasm.FieldDescriptor;
import com.sun.javacard.jcasm.FieldIdentifier;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.Member;
import com.sun.javacard.jcasm.StaticFieldInitializer;
import java.lang.reflect.Modifier;

public class Field
extends Member {
    protected FieldIdentifier fieldIdentifier;
    protected JCClass parentClass;
    protected FieldDescriptor descriptor;
    protected StaticFieldInitializer initializer;

    public Field(JCClass parentClass, int attributes, FieldDescriptor descriptor, String name, StaticFieldInitializer init, int line) {
        super(attributes, name, line, 0);
        assert (descriptor != null) : "descriptor != null";
        this.parentClass = parentClass;
        this.descriptor = descriptor;
        this.initializer = init;
    }

    public Field(JCClass parentClass, int attributes, FieldDescriptor descriptor, String name, FieldIdentifier fieldIdentifier, StaticFieldInitializer init, int line) {
        this(parentClass, attributes, descriptor, name, init, line);
        this.fieldIdentifier = fieldIdentifier;
    }

    public FieldIdentifier getFieldIdentifier() {
        return this.fieldIdentifier;
    }

    public JCClass getParentClass() {
        return this.parentClass;
    }

    public FieldDescriptor getDescriptor() {
        return this.descriptor;
    }

    public StaticFieldInitializer getFieldInitializer() {
        return this.initializer;
    }

    public boolean isExportCompCandidate() {
        return Modifier.isStatic(this.attributes) && (Modifier.isPublic(this.attributes) || Modifier.isProtected(this.attributes));
    }

    public int size() {
        int size = 0;
        if (!this.descriptor.isPrimitive()) {
            size = 2;
        } else {
            String descString = this.descriptor.getDescriptorString();
            if (descString.equals("B") || descString.equals("Z")) {
                size = 1;
            } else if (descString.equals("S")) {
                size = 2;
            } else if (descString.equals("I")) {
                size = 4;
            } else assert (false) : descString;
        }
        return size;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(Modifier.toString(this.attributes));
        sb.append(" " + this.descriptor + " " + this.name);
        if (this.fieldIdentifier != null) {
            sb.append(" <" + this.fieldIdentifier + ">");
        }
        return sb.toString();
    }

    public String getFormattedField(String d) {
        String s = this.getName();
        int classIndex = this.parentClass.getName().length() + 1;
        String fieldName = s = s.substring(classIndex);
        int a = this.getAttributes();
        String attributeString = Modifier.toString(a);
        String desc = this.descriptor.toString();
        if (this.descriptor.getDescriptorString() == null) {
            desc = d;
        }
        return attributeString + " " + EfNames.prettyField(fieldName, desc);
    }
}

