/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcbytecodeprofiler;

import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.PackageIdentifier;
import com.sun.javacard.jcasm.SymbolTable;
import java.util.Enumeration;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputPackageInfo {
    protected Vector<JCPackage> packageVector = new Vector();
    protected SymbolTable<Object, JCClass> classSymbolTable = new SymbolTable();
    protected SymbolTable<Object, JCMethod> methodSymbolTable = new SymbolTable();
    protected SymbolTable<Object, Field> fieldSymbolTable = new SymbolTable();

    public void addPackage(JCPackage p) {
        if (p == null) {
            return;
        }
        if (this.containsPackage(p.getIdentifier())) {
            Object[] args = new Object[]{p.getIdentifier().toString()};
            Msg.error("mask.1", args);
            return;
        }
        if (this.containsPackage(p.getName())) {
            Object[] args = new Object[]{p.getName()};
            Msg.error("mask.1", args);
            return;
        }
        this.packageVector.addElement(p);
        this.classSymbolTable.merge(p.symbolTable);
        Enumeration<JCClass> e = p.classElements();
        while (e.hasMoreElements()) {
            JCClass c = e.nextElement();
            this.methodSymbolTable.merge(c.methodSymbolTable);
            this.fieldSymbolTable.merge(c.fieldSymbolTable);
        }
    }

    public boolean containsPackage(PackageIdentifier id) {
        for (JCPackage q : this.packageVector) {
            if (!q.getIdentifier().equals(id)) continue;
            return true;
        }
        return false;
    }

    public boolean containsPackage(String pkgName) {
        for (JCPackage q : this.packageVector) {
            if (!q.getName().equals(pkgName)) continue;
            return true;
        }
        return false;
    }

    public Enumeration<JCPackage> packageElements() {
        return this.packageVector.elements();
    }

    public Vector<JCPackage> getPackages() {
        return this.packageVector;
    }

    public SymbolTable<Object, JCClass> getClassSymbolTable() {
        return this.classSymbolTable;
    }

    public SymbolTable<Object, JCMethod> getMethodSymbolTable() {
        return this.methodSymbolTable;
    }

    public int getSymbolCount() {
        return this.classSymbolTable.size() + this.fieldSymbolTable.size() + this.methodSymbolTable.size();
    }
}

