/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcbytecodeprofiler;

import com.sun.javacard.jcasm.Globals;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.ParseException;
import com.sun.javacard.jcasm.Parser;
import com.sun.javacard.jcbytecodeprofiler.InputPackageInfo;
import com.sun.javacard.jcbytecodeprofiler.JCAllCodeNMethodProfiler;
import com.sun.javacard.jcbytecodeprofiler.JCByteCodeProfiler;
import com.sun.javacard.jcbytecodeprofiler.MaskLinker;
import com.sun.javacard.jcbytecodeprofiler.RomMask;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    public static boolean noBanner;
    private static boolean all;

    public static void main(String[] argv) {
        int i;
        String outputFile = "a.out";
        Vector<String> inputList = new Vector<String>();
        for (i = 0; i < argv.length && argv[i].startsWith("-"); ++i) {
            if (argv[i].equals("-help")) {
                Main.usage(false);
                System.exit(0);
                continue;
            }
            if (argv[i].equals("-o")) {
                if (++i < argv.length) {
                    outputFile = argv[i];
                    continue;
                }
                Main.usage(true);
                continue;
            }
            if (!argv[i].equals("-a")) continue;
            all = true;
        }
        if (!noBanner) {
            Main.banner();
        }
        File folder = null;
        while (i < argv.length) {
            String fName;
            if ((fName = argv[i++]).startsWith("@")) {
                Main.readListFromFile(inputList, fName.substring(1));
                folder = new File(fName.substring(1)).getParentFile();
                continue;
            }
            inputList.addElement(fName);
            folder = new File(fName).getParentFile();
        }
        if (inputList.size() == 0) {
            Main.usage(true);
        }
        InputPackageInfo inputPackages = new InputPackageInfo();
        RomMask mask = new RomMask();
        Parser parser = null;
        BufferedInputStream bis = null;
        for (String inSpec : inputList) {
            try {
                bis = new BufferedInputStream(new FileInputStream(inSpec));
            }
            catch (FileNotFoundException ex) {
                System.err.println(ex);
                ++Globals.errors;
                continue;
            }
            if (parser == null) {
                parser = new Parser(bis);
            } else {
                Parser.ReInit(bis);
            }
            Parser.inputSpec = inSpec;
            try {
                JCPackage pack = Parser.PackageDeclaration();
                inputPackages.addPackage(pack);
                mask.addPackage(pack);
                try {
                    bis.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            catch (ParseException ex) {
                System.err.println(ex);
                ++Globals.errors;
            }
        }
        if (Globals.errors == 0) {
            MaskLinker.link(mask);
            if (!all) {
                JCByteCodeProfiler profiler = new JCByteCodeProfiler();
                profiler.generateReport(inputPackages, folder);
            } else {
                JCAllCodeNMethodProfiler nativeProfiler = new JCAllCodeNMethodProfiler();
                nativeProfiler.generateAllReport(inputPackages, folder);
            }
        }
        Main.printStatus();
    }

    static void printStatus() {
    }

    private static void usage(boolean isError) {
        System.out.println("Usage: \nMain [@inputfile or jca files listed on the command line]");
        if (isError) {
            System.exit(1);
        }
    }

    private static void banner() {
    }

    static void readListFromFile(Vector<String> list, String fName) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(fName));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                list.addElement(line);
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            System.err.println(e);
            ++Globals.errors;
        }
        catch (IOException e) {
            e.printStackTrace();
            ++Globals.errors;
        }
    }

    static {
        all = false;
    }
}

