/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.classfile;

import com.sun.javacard.basicstructure.PackageDefinition;
import com.sun.javacard.classfile.JClassFile;
import com.sun.javacard.classfile.JField;
import com.sun.javacard.classfile.JMethod;
import com.sun.javacard.converter.PrecheckException;
import com.sun.javacard.converter.util.Notifier;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class JPackage
extends PackageDefinition {
    private JClassFile[] java_classes;

    public JClassFile[] getClasses() {
        return this.java_classes;
    }

    public void setClasses(JClassFile[] java_classes) {
        this.java_classes = java_classes;
    }

    public JPackage(String package_name) {
        this.package_name = package_name;
    }

    public void parse(File[] classes) {
        this.java_classes = new JClassFile[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            JClassFile java_class = new JClassFile();
            DataInputStream dis = null;
            try {
                Notifier.progress("progress.1", classes[i].getCanonicalPath());
                dis = new DataInputStream(new BufferedInputStream(new FileInputStream(classes[i])));
                java_class.parse(dis);
                this.java_classes[i] = java_class;
                continue;
            }
            catch (IOException e) {
                Notifier.error("converter.1", classes[i].getName());
            }
        }
    }

    public void resolve() throws PrecheckException {
        for (JClassFile element : this.java_classes) {
            element.resolve();
        }
    }

    public JClassFile getClass(String class_name) {
        for (JClassFile element : this.java_classes) {
            if (!element.getClassName().equals(class_name)) continue;
            return element;
        }
        return null;
    }

    public JMethod getMethod(String class_name, String method_name, String descriptor) {
        JMethod[] java_methods;
        JClassFile java_class = this.getClass(class_name);
        if (java_class == null) {
            return null;
        }
        for (JMethod element : java_methods = java_class.getMethods()) {
            if (!element.getMethodName().equals(method_name) || !element.getMethodDescriptor().equals(descriptor)) continue;
            return element;
        }
        return null;
    }

    public JField getField(String class_name, String field_name, String descriptor) {
        JField[] java_fields;
        JClassFile java_class = this.getClass(class_name);
        if (java_class == null) {
            return null;
        }
        for (JField element : java_fields = java_class.getFields()) {
            if (!element.getFieldName().equals(field_name) || !element.getFieldDescriptor().equals(descriptor)) continue;
            return element;
        }
        return null;
    }
}

