/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.converter.ConversionException;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.converters.InstrContainer;
import com.sun.javacard.converter.converters.InstructionConverter;
import com.sun.javacard.converter.converters.MethodConverter;
import com.sun.javacard.converter.converters.OperandStackEntry;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.jcfile.instructions.JcInstrNoOperands;
import com.sun.javacard.jcfile.instructions.JcInstruction;

class InstrArithmeticConverter
extends InstructionConverter {
    private static final int SHORT_FLAVOR_BC = 1;
    private static final int INT_FLAVOR_BC = 2;
    private int[][] conversion_table = new int[][]{{96, 65, 66}, {100, 67, 68}, {104, 69, 70}, {108, 71, 72}, {112, 73, 74}, {116, 75, 76}, {120, 77, 78}, {122, 79, 80}, {124, 81, 82}, {126, 83, 84}, {128, 85, 86}, {130, 87, 88}};
    private boolean operands_overflow = false;
    private boolean result_overflow = false;
    private int result_type;

    public InstrArithmeticConverter(InstrContainer instr_container, MethodConverter method_converter) {
        super(instr_container, method_converter);
    }

    private int getJcOpcode(int java_opcode, int flavor) {
        for (int[] element : this.conversion_table) {
            if (element[0] != java_opcode) continue;
            return element[flavor];
        }
        throw new ConverterInternalError();
    }

    @Override
    public JcInstruction convert() throws Exception {
        int java_opcode = this.java_instr.getOpcode();
        OperandStackEntry entry1 = this.operand_stack.peek(1);
        OperandStackEntry entry2 = null;
        if (java_opcode != 116) {
            entry2 = this.operand_stack.peek(2);
        }
        this.operands_overflow = this.checkOperandsAndOperator(java_opcode, entry2, entry1);
        this.result_type = this.determineResultType(java_opcode, entry2, entry1);
        if (this.result_type == 3) {
            if (java_opcode == 116) {
                if (entry1.getType() != 3) {
                    entry1.rollBack();
                }
            } else {
                if (entry1.getType() != 3) {
                    entry1.rollBack();
                }
                if (entry2.getType() != 3) {
                    entry2.rollBack();
                }
            }
            this.jc_instr = new JcInstrNoOperands(this.getJcOpcode(java_opcode, 2));
        } else {
            this.jc_instr = new JcInstrNoOperands(this.getJcOpcode(java_opcode, 1));
        }
        this.determineResultOverflow(entry1, entry2);
        if (java_opcode == 116) {
            this.operand_stack.pop();
        } else {
            this.operand_stack.pop();
            this.operand_stack.pop();
        }
        OperandStackEntry result_entry = new OperandStackEntry(this.result_type, this.instr_container);
        result_entry.setOverflow(this.result_overflow);
        if (!this.result_overflow && entry1.isTypeKnown() && (entry2 == null || entry2.isTypeKnown())) {
            result_entry.setTypeKnown(true);
        }
        this.determineRollBackPoint(entry2, entry1, result_entry);
        this.operand_stack.push(result_entry);
        return this.jc_instr;
    }

    private boolean checkOperandsAndOperator(int opcode, OperandStackEntry entry1, OperandStackEntry entry2) throws Exception {
        switch (opcode) {
            case 108: 
            case 112: {
                if (entry1.hasOverflowPotential()) {
                    if (this.method_converter.isIntSupported()) {
                        entry1.rollBack();
                    } else {
                        this.reportError();
                    }
                }
                if (entry2.hasOverflowPotential()) {
                    if (this.method_converter.isIntSupported()) {
                        entry2.rollBack();
                    } else {
                        this.reportError();
                    }
                }
                return false;
            }
            case 122: 
            case 124: {
                if (entry1.hasOverflowPotential()) {
                    if (this.method_converter.isIntSupported()) {
                        entry1.rollBack();
                    } else {
                        this.reportError();
                    }
                }
                return false;
            }
            case 116: {
                if (entry2.hasOverflowPotential()) {
                    if (this.method_converter.isIntSupported()) {
                        entry2.rollBack();
                    } else {
                        this.reportError();
                    }
                }
                return false;
            }
        }
        if (entry1.hasOverflowPotential()) {
            return true;
        }
        return entry2.hasOverflowPotential();
    }

    private void reportError() throws Exception {
        Notifier.error(this.java_instr.getSourceLineNumber(), "int.21", this.method_converter.getClassName().replace('/', '.'));
        throw new ConversionException();
    }

    private int determineResultType(int opcode, OperandStackEntry entry1, OperandStackEntry entry2) {
        this.result_overflow = false;
        switch (opcode) {
            case 96: 
            case 100: 
            case 104: {
                if (entry1.getType() == 1 && entry2.getType() == 1) {
                    return 2;
                }
                if (entry1.getType() == 3 || entry2.getType() == 3) {
                    return 3;
                }
                this.result_overflow = true;
                return 2;
            }
            case 108: {
                if (entry1.getType() == 1 && entry2.getType() == 1) {
                    return 2;
                }
                if (entry1.getType() == 1 && entry2.getType() == 2) {
                    return 2;
                }
                if (entry1.getType() == 3 || entry2.getType() == 3) {
                    return 3;
                }
                this.result_overflow = true;
                return 2;
            }
            case 120: {
                if (entry1.getType() == 3) {
                    return 3;
                }
                if (entry2.getType() == 3) {
                    return 3;
                }
                this.result_overflow = true;
                return 2;
            }
            case 112: {
                if (entry1.getType() == 1 && entry2.getType() == 1) {
                    return 1;
                }
                if (entry1.getType() == 2 && entry2.getType() == 1) {
                    return 1;
                }
                if (entry1.getType() == 1 && entry2.getType() == 2) {
                    return 1;
                }
                if (entry1.getType() == 2 && entry2.getType() == 2) {
                    return 2;
                }
                return 3;
            }
            case 116: {
                if (entry2.getType() == 1) {
                    return 2;
                }
                if (entry2.getType() == 2) {
                    this.result_overflow = true;
                    return 2;
                }
                return 3;
            }
            case 122: {
                if (entry1.getType() == 3) {
                    return 3;
                }
                if (entry2.getType() == 3) {
                    return 3;
                }
                return entry1.getType();
            }
            case 124: {
                if (entry1.getType() == 3) {
                    return 3;
                }
                if (entry2.getType() == 3) {
                    return 3;
                }
                this.result_overflow = true;
                return 2;
            }
            case 126: 
            case 128: 
            case 130: {
                if (entry1.getType() == 1 && entry2.getType() == 1) {
                    return 1;
                }
                if (entry1.getType() == 2 && entry2.getType() == 1) {
                    return 2;
                }
                if (entry1.getType() == 1 && entry2.getType() == 2) {
                    return 2;
                }
                if (entry1.getType() == 2 && entry2.getType() == 2) {
                    return 2;
                }
                return 3;
            }
        }
        throw new ConverterInternalError();
    }

    private void determineResultOverflow(OperandStackEntry entry1, OperandStackEntry entry2) {
        if (entry1.hasOverflowPotential() || entry1.hasOverflowPotential()) {
            this.result_overflow = true;
        }
    }

    private void determineRollBackPoint(OperandStackEntry entry1, OperandStackEntry entry2, OperandStackEntry result_entry) {
        this.result_overflow = false;
        if (false) {
            return;
        }
        if (this.java_instr.getOpcode() == 116) {
            if (entry2.getRollBackPoint() != null) {
                result_entry.setRollBackPoint(entry2.getRollBackPoint());
            } else {
                result_entry.setRollBackPoint(entry2.getInstrContainer());
            }
        } else if (entry1.getRollBackPoint() != null) {
            result_entry.setRollBackPoint(entry1.getRollBackPoint());
        } else if (entry2.getRollBackPoint() != null) {
            result_entry.setRollBackPoint(entry2.getRollBackPoint());
        } else {
            result_entry.setRollBackPoint(entry1.getInstrContainer());
        }
    }
}

