/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.jcawriter;

import com.sun.javacard.ToolsVersion;
import com.sun.javacard.basicstructure.MethodDefinition;
import com.sun.javacard.basicstructure.PackageDefinition;
import com.sun.javacard.converter.AppletProfile;
import com.sun.javacard.converter.ConversionProfile;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.PackageProfile;
import com.sun.javacard.converter.jcawriter.Comment;
import com.sun.javacard.converter.util.DataType;
import com.sun.javacard.converter.util.MethodDescriptor;
import com.sun.javacard.converter.util.Names;
import com.sun.javacard.converter.util.Strings;
import com.sun.javacard.exportfile.EfClass;
import com.sun.javacard.exportfile.ExportFileManager;
import com.sun.javacard.jcfile.JcAppletInfo;
import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcException;
import com.sun.javacard.jcfile.JcField;
import com.sun.javacard.jcfile.JcImplementedInterfaceInfo;
import com.sun.javacard.jcfile.JcImportTokenTable;
import com.sun.javacard.jcfile.JcImportTokenTableEntry;
import com.sun.javacard.jcfile.JcMethod;
import com.sun.javacard.jcfile.JcMethodTable;
import com.sun.javacard.jcfile.JcPackage;
import com.sun.javacard.jcfile.constants.JcConstant;
import com.sun.javacard.jcfile.constants.JcConstantClassRef;
import com.sun.javacard.jcfile.constants.JcConstantFieldRef;
import com.sun.javacard.jcfile.constants.JcConstantInstanceFieldRef;
import com.sun.javacard.jcfile.constants.JcConstantMethodRef;
import com.sun.javacard.jcfile.constants.JcConstantSuperMethodRef;
import com.sun.javacard.jcfile.constants.JcConstantVirtualMethodRef;
import com.sun.javacard.jcfile.instructions.JcByteCode;
import com.sun.javacard.jcfile.instructions.JcInstrBranch;
import com.sun.javacard.jcfile.instructions.JcInstrByteIndex;
import com.sun.javacard.jcfile.instructions.JcInstrByteValue;
import com.sun.javacard.jcfile.instructions.JcInstrClassRef;
import com.sun.javacard.jcfile.instructions.JcInstrFieldRef;
import com.sun.javacard.jcfile.instructions.JcInstrIncrement;
import com.sun.javacard.jcfile.instructions.JcInstrIntValue;
import com.sun.javacard.jcfile.instructions.JcInstrInterfaceRef;
import com.sun.javacard.jcfile.instructions.JcInstrLookupSwitch;
import com.sun.javacard.jcfile.instructions.JcInstrMethodRef;
import com.sun.javacard.jcfile.instructions.JcInstrNoOperands;
import com.sun.javacard.jcfile.instructions.JcInstrShortValue;
import com.sun.javacard.jcfile.instructions.JcInstrTableSwitch;
import com.sun.javacard.jcfile.instructions.JcInstrTypeClassRef;
import com.sun.javacard.jcfile.instructions.JcInstruction;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.util.Date;

public class JcaWriter {
    private JcPackage jc_package;
    private JcImportTokenTable token_table;
    private ExportFileManager export_file_manager;
    private PackageProfile package_profile;
    private AppletProfile[] applets_profile;
    private PrintWriter pw;
    private static char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public JcaWriter(JcPackage jc_package, ConversionProfile conversion_profile, ExportFileManager export_file_manager) {
        this.jc_package = jc_package;
        this.token_table = jc_package.getImportTokenTable();
        this.package_profile = conversion_profile.package_profile;
        this.applets_profile = conversion_profile.applets_profile;
        this.export_file_manager = export_file_manager;
    }

    public void write(PrintWriter pw) throws Exception {
        this.pw = pw;
        pw.println("// converted by version " + ToolsVersion.getVersion(1));
        pw.println("// on " + new Date());
        pw.println();
        int tag_level = 0;
        this.writePackage(tag_level);
    }

    private String getIndent(int tag_level) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < tag_level; ++i) {
            sb.append("\t");
        }
        return sb.toString();
    }

    private void writePackage(int tab_level) throws Exception {
        String indent = this.getIndent(tab_level);
        this.pw.println(".package " + this.jc_package.getPackageName() + " {");
        byte[] aid = this.package_profile.aid;
        this.pw.println("\t.aid " + Strings.toHexString(aid, ":") + ";");
        this.pw.print(indent + "\t.version " + Integer.toString(this.jc_package.getPackageMajorVersion()));
        this.pw.println("." + Integer.toString(this.jc_package.getPackageMinorVersion()) + ";");
        this.pw.println();
        this.writeImportPackages(tab_level + 1);
        this.writeApplets(tab_level + 1);
        this.writeConstantPool(tab_level + 1);
        this.writeClasses(tab_level + 1);
        this.pw.println("}");
        this.pw.flush();
    }

    private void writeImportPackages(int tab_level) {
        PackageDefinition[] import_packages = this.token_table.getImportPackageInfos();
        if (import_packages.length == 0) {
            return;
        }
        String indent = this.getIndent(tab_level);
        this.pw.println(indent + ".imports {");
        for (PackageDefinition element : import_packages) {
            String aid_string = Strings.toHexString(element.getAID(), ":");
            String version_string = Integer.toString(element.getPackageMajorVersion()) + "." + Integer.toString(element.getPackageMinorVersion());
            this.pw.print(indent + "\t" + aid_string + " " + version_string + ";");
            this.pw.println("\t\t//" + element.getPackageName());
        }
        this.pw.println(indent + "}");
        this.pw.println();
        this.pw.flush();
    }

    private void writeApplets(int tab_level) {
        JcAppletInfo[] applet_infos = this.jc_package.getAppletInfos();
        if (applet_infos.length == 0) {
            return;
        }
        String indent = this.getIndent(tab_level);
        this.pw.println(indent + ".applet {");
        for (JcAppletInfo element : applet_infos) {
            String aid_string = Strings.toHexString(element.getAppletAID(), ":");
            String install_class = Names.getClassName(element.getInstallClass(), 47);
            this.pw.println(indent + "\t" + aid_string + " " + install_class + ";");
        }
        this.pw.println(indent + "}");
        this.pw.println();
        this.pw.flush();
    }

    private void writeConstantPool(int tab_level) throws Exception {
        String indent = this.getIndent(tab_level);
        JcConstant[] constants = this.jc_package.getConstantPool().getConstants();
        if (constants.length == 0) {
            return;
        }
        this.pw.println(indent + ".constantPool {");
        for (int i = 0; i < constants.length; ++i) {
            String tag;
            JcConstant constant = constants[i];
            this.pw.println(indent + "\t// " + i);
            if (constant instanceof JcConstantClassRef) {
                JcConstantClassRef class_ref = (JcConstantClassRef)constant;
                String class_name = class_ref.getClassName();
                this.pw.print(indent + "\t.classRef " + this.getClassRep(class_name) + ";");
                if (this.thisPackage(class_name)) {
                    this.pw.println();
                    continue;
                }
                this.pw.println(Comment.getComment(class_ref));
                continue;
            }
            if (constant instanceof JcConstantMethodRef) {
                JcConstantMethodRef method_ref = (JcConstantMethodRef)constant;
                tag = constant instanceof JcConstantVirtualMethodRef ? new String("virtualMethodRef ") : (constant instanceof JcConstantSuperMethodRef ? new String("superMethodRef ") : new String("staticMethodRef "));
                String method_rep = this.getMethodRep(method_ref.getClassName(), method_ref.getMethodName(), method_ref.getDescriptor());
                this.pw.print(indent + "\t" + tag + method_rep + ";");
                if (this.thisPackage(method_ref.getClassName())) {
                    this.pw.println();
                } else {
                    this.pw.println(Comment.getComment(method_ref));
                }
                this.writeMethodDescriptor(method_ref.getDescriptor(), tab_level + 2);
                continue;
            }
            if (!(constant instanceof JcConstantFieldRef)) continue;
            JcConstantFieldRef field_ref = (JcConstantFieldRef)constant;
            tag = field_ref instanceof JcConstantInstanceFieldRef ? new String("instanceFieldRef ") : new String("staticFieldRef ");
            String field_rep = this.getFieldRep(field_ref.getClassName(), field_ref.getFieldName(), field_ref.getDescriptor());
            String field_des = this.getFieldDescriptorString(field_ref.getDescriptor());
            this.pw.print(indent + "\t" + tag + field_des + " " + field_rep + ";");
            if (this.thisPackage(field_ref.getClassName())) {
                this.pw.println();
                continue;
            }
            this.pw.println(Comment.getComment(field_ref));
        }
        this.pw.println(indent + "}");
        this.pw.println();
        this.pw.flush();
    }

    private void writeClasses(int tab_level) throws Exception {
        JcClass[] jc_classes = this.jc_package.getClasses();
        if (jc_classes.length == 0) {
            return;
        }
        for (JcClass jc_class : jc_classes) {
            if (jc_class.isInterfaceType()) {
                this.writeInterface(jc_class, tab_level);
                continue;
            }
            this.writeClass(jc_class, tab_level);
        }
    }

    private void writeInterface(JcClass jc_class, int tab_level) throws Exception {
        String indent = this.getIndent(tab_level);
        if (jc_class.isAnnotation()) {
            this.pw.println(indent + "// .annotation " + Names.getClassName(jc_class.getClassName(), 47));
            this.pw.println();
            this.pw.flush();
            return;
        }
        String access_flags_string = Modifier.toString(jc_class.getAccessFlags() & 0xFFFFFDFF);
        String token_string = this.getClassTokenString(jc_class.getAccessFlags(), jc_class.getClassToken());
        this.pw.println(indent + ".interface " + access_flags_string + " " + Names.getClassName(jc_class.getClassName(), 47) + token_string + " {");
        this.pw.println();
        if (jc_class.isShareableType()) {
            this.pw.println(indent + "\t" + ".shareable;");
            this.pw.println();
        }
        if (jc_class.isRemote()) {
            this.pw.println(indent + "\t" + ".remote;");
            this.pw.println();
        }
        this.writeSuperInterfaces(jc_class, tab_level + 1);
        this.writeFields(jc_class, tab_level + 1);
        this.writeMethods(jc_class, tab_level + 1);
        this.pw.println(indent + "}");
        this.pw.println();
        this.pw.flush();
    }

    private void writeClass(JcClass jc_class, int tab_level) throws Exception {
        String indent = this.getIndent(tab_level);
        String access_flags_string = Modifier.toString(jc_class.getAccessFlags());
        String token_string = this.getClassTokenString(jc_class.getAccessFlags(), jc_class.getClassToken());
        this.pw.print(indent + ".class " + access_flags_string + " " + Names.getClassName(jc_class.getClassName(), 47) + token_string + " ");
        String super_class = jc_class.getSuperClassName();
        if (super_class != null) {
            String class_rep = this.getClassRep(super_class);
            this.pw.print("extends " + class_rep + " {");
            if (this.thisPackage(super_class)) {
                this.pw.println();
            } else {
                this.pw.println(Comment.getComment("extends " + super_class));
            }
        } else {
            this.pw.println("{");
        }
        this.pw.println();
        if (jc_class.isShareableType()) {
            this.pw.println(indent + "\t" + ".shareable;");
            this.pw.println();
        }
        if (jc_class.isRemote()) {
            this.pw.println(indent + "\t" + ".remote;");
            this.pw.println();
        }
        this.writeFields(jc_class, tab_level + 1);
        this.writeMethodTables(jc_class, tab_level + 1);
        this.writeImplementedInterfaceInfos(jc_class, tab_level + 1);
        if (jc_class.isRemote() && !jc_class.isInterfaceType()) {
            this.writeImplementedRemoteInterfaceInfos(jc_class, tab_level + 1);
        }
        this.writeMethods(jc_class, tab_level + 1);
        this.pw.println(indent + "}");
        this.pw.println();
        this.pw.flush();
    }

    private void writeSuperInterfaces(JcClass jc_class, int tab_level) throws Exception {
        String indent = this.getIndent(tab_level);
        String[] super_interfaces = jc_class.getSuperInterfaces();
        if (super_interfaces.length == 0) {
            return;
        }
        this.pw.println(indent + ".superInterfaces {");
        for (String super_interface : super_interfaces) {
            String class_rep = this.getClassRep(super_interface);
            this.pw.print(indent + "\t" + class_rep + ";");
            if (this.thisPackage(super_interface)) {
                this.pw.println();
                continue;
            }
            this.pw.println(Comment.getComment(super_interface));
        }
        this.pw.println(indent + "}");
        this.pw.println();
        this.pw.flush();
    }

    private void writeImplementedInterfaceInfos(JcClass jc_class, int tab_level) throws Exception {
        JcImplementedInterfaceInfo[] impl_interface_infos = jc_class.getImplementedInterfaceInfos();
        if (impl_interface_infos.length == 0) {
            return;
        }
        String indent = this.getIndent(tab_level);
        this.pw.println(indent + ".implementedInterfaceInfoTable { ");
        for (JcImplementedInterfaceInfo impl_interface_info : impl_interface_infos) {
            String class_rep = this.getClassRep(impl_interface_info.getInterfaceName());
            this.pw.print(indent + "\t" + ".interface " + class_rep + " { ");
            if (this.thisPackage(impl_interface_info.getInterfaceName())) {
                this.pw.println();
            } else {
                this.pw.println(Comment.getComment(impl_interface_info.getInterfaceName()));
            }
            MethodDefinition[] interface_methods = impl_interface_info.getInterfaceMethods();
            int[] indexes = impl_interface_info.getMethodTableIndexes();
            for (int j = 0; j < interface_methods.length; ++j) {
                this.pw.print(indent + "\t\t" + indexes[j] + ";");
                this.pw.println(Comment.getComment(interface_methods[j]));
            }
            this.pw.println(indent + "\t" + "}");
            this.pw.println();
        }
        this.pw.println(indent + "}");
        this.pw.println();
    }

    private void writeImplementedRemoteInterfaceInfos(JcClass jc_class, int tab_level) throws Exception {
        JcImplementedInterfaceInfo[] impl_interface_infos = jc_class.getImplementedRemoteInterfaceInfos();
        if (impl_interface_infos.length == 0) {
            return;
        }
        String indent = this.getIndent(tab_level);
        this.pw.println(indent + ".implementedRemoteInterfaceInfoTable { ");
        for (JcImplementedInterfaceInfo impl_interface_info : impl_interface_infos) {
            if (impl_interface_info == null) continue;
            String class_rep = this.getClassRep(impl_interface_info.getInterfaceName());
            this.pw.print(indent + "\t" + ".interface " + class_rep + " { ");
            if (this.thisPackage(impl_interface_info.getInterfaceName())) {
                this.pw.println();
            } else {
                this.pw.println(Comment.getComment(impl_interface_info.getInterfaceName()));
            }
            MethodDefinition[] interface_methods = impl_interface_info.getInterfaceMethods();
            int[] indexes = impl_interface_info.getMethodTableIndexes();
            for (int j = 0; j < interface_methods.length; ++j) {
                this.pw.print(indent + "\t\t" + interface_methods[j].getMethodName() + interface_methods[j].getMethodDescriptor() + " " + indexes[j] + ";");
                this.pw.println(Comment.getComment(interface_methods[j]));
            }
            this.pw.println(indent + "\t" + "}");
            this.pw.println();
        }
        this.pw.println(indent + "}");
        this.pw.println();
    }

    private void writeFields(JcClass jc_class, int tab_level) {
        String indent = this.getIndent(tab_level);
        JcField[] fields = jc_class.getFields();
        if (fields.length == 0) {
            return;
        }
        this.pw.println(indent + ".fields {");
        for (JcField field : fields) {
            int access_flags = field.getAccessFlags();
            String access_flags_string = Modifier.toString(access_flags);
            String token_string = this.getFieldTokenString(access_flags, field.getFieldDescriptor(), field.getFieldToken());
            String descriptor_string = this.getFieldDescriptorString(field.getFieldDescriptor());
            this.pw.print(indent + "\t" + access_flags_string + " " + descriptor_string + " " + JcaWriter.prepare(field.getFieldName()) + token_string);
            int[] values = field.getValue();
            if (values != null) {
                if (field.getFieldDescriptor().equals("Ljava/lang/Object;")) {
                    int atype = field.getAtype();
                    String datatype = null;
                    switch (atype) {
                        case 4: {
                            datatype = "boolean[]";
                            break;
                        }
                        case 8: {
                            datatype = "byte[]";
                            break;
                        }
                        case 9: {
                            datatype = "short[]";
                            break;
                        }
                        case 10: {
                            datatype = "int[]";
                        }
                    }
                    if (atype > 0) {
                        this.pw.print(" = " + datatype + " {");
                        if (values.length > 0) {
                            this.pw.print(values[0]);
                            for (int j = 1; j < values.length; ++j) {
                                this.pw.print("," + values[j]);
                            }
                        }
                        this.pw.print("}");
                    }
                } else if (DataType.isArrayType(field.getFieldDescriptor())) {
                    if (values.length == 0) {
                        this.pw.print(" = {}");
                    } else {
                        this.pw.print(" = {");
                        this.pw.print(values[0]);
                        for (int j = 1; j < values.length; ++j) {
                            this.pw.print("," + values[j]);
                        }
                        this.pw.print("}");
                    }
                } else if (values.length == 1) {
                    this.pw.print(" = " + values[0]);
                }
            } else if (field.isStatic() && field.isFinal()) {
                this.pw.print(" = 0 ");
            }
            this.pw.println(";\t\t// " + field.getFieldDescriptor());
        }
        this.pw.println(indent + "}");
        this.pw.println();
        this.pw.flush();
    }

    private void writeMethodTables(JcClass jc_class, int tab_level) {
        String indent = this.getIndent(tab_level);
        JcMethodTable pub_method_table = jc_class.getPublicMethodTable();
        MethodDefinition[] pub_methods = pub_method_table.getMethods();
        int pub_table_base = pub_method_table.getMethodTableBase();
        this.pw.println(indent + ".publicMethodTable " + Integer.toString(pub_table_base) + " {");
        for (MethodDefinition element : pub_methods) {
            this.pw.println(JcaWriter.prepare(indent + "\t" + element.getMethodName() + element.getMethodDescriptor() + ";"));
        }
        this.pw.println(indent + "}");
        this.pw.println();
        JcMethodTable pac_method_table = jc_class.getPackageMethodTable();
        MethodDefinition[] pac_methods = pac_method_table.getMethods();
        int pac_table_base = pac_method_table.getMethodTableBase();
        this.pw.println(indent + ".packageMethodTable " + Integer.toString(pac_table_base) + " {");
        for (MethodDefinition element : pac_methods) {
            this.pw.println(indent + "\t" + element.getMethodName() + element.getMethodDescriptor() + ";");
        }
        this.pw.println(indent + "}");
        this.pw.println();
        this.pw.flush();
    }

    private void writeMethods(JcClass jc_class, int tab_level) {
        String indent = this.getIndent(tab_level);
        MethodDefinition[] methods = jc_class.getMethods();
        if (jc_class.isInterfaceType()) {
            methods = jc_class.getPublicMethodTable().getMethods();
        }
        if (methods.length == 0) {
            return;
        }
        for (MethodDefinition method : methods) {
            int access_flags = method.getAccessFlags();
            String access_flags_string = Modifier.toString(access_flags);
            if (method.isRemote()) {
                access_flags_string = access_flags_string + " .remote ";
            }
            String token_string = this.getMethodTokenString(method.getMethodName(), method.getAccessFlags(), method.getMethodToken());
            this.pw.println(JcaWriter.prepare(indent + ".method " + access_flags_string + " " + method.getMethodName() + method.getMethodDescriptor() + token_string + " {"));
            if (Modifier.isNative(access_flags) || Modifier.isAbstract(access_flags)) {
                this.writeMethodDescriptor(method.getMethodDescriptor(), tab_level + 1);
            } else {
                JcMethod jc_method = (JcMethod)method;
                this.pw.println(indent + "\t.stack " + Integer.toString(jc_method.getMaxStack()) + ";");
                this.pw.println(indent + "\t.locals " + Integer.toString(jc_method.getMaxLocals()) + ";");
                this.pw.println();
                this.writeMethodDescriptor(jc_method.getMethodDescriptor(), tab_level + 1);
                this.writeInstructions(jc_method, tab_level + 1);
                this.writeExceptionTable(jc_method, tab_level + 1);
            }
            this.pw.println(indent + "}");
            this.pw.println();
        }
        this.pw.flush();
    }

    private void writeMethodDescriptor(String method_desc, int table_level) {
        String[] param_descs = MethodDescriptor.getParamDescriptors(method_desc);
        int num = 0;
        String[] ext_classes = new String[param_descs.length + 1];
        for (String element : param_descs) {
            String ref_class = Names.getClassNameFromDescriptor(element);
            if (ref_class == null || this.thisPackage(ref_class)) continue;
            ext_classes[num++] = ref_class;
        }
        String return_desc = MethodDescriptor.getReturnDescriptor(method_desc);
        String ref_class = Names.getClassNameFromDescriptor(return_desc);
        if (ref_class != null && !this.thisPackage(ref_class)) {
            ext_classes[num++] = ref_class;
        }
        if (num == 0) {
            return;
        }
        String indent = this.getIndent(table_level);
        for (int i = 0; i < num; ++i) {
            JcImportTokenTableEntry class_entry = this.token_table.getClassEntry(ext_classes[i]);
            this.pw.println(indent + ".descriptor\t" + "L" + ext_classes[i] + ";" + "\t" + class_entry.getTokenString() + ";");
        }
        this.pw.println();
    }

    private void writeInstructions(JcMethod method, int tab_level) {
        String indent = this.getIndent(tab_level);
        for (JcInstruction jc_instr = method.getCode(); jc_instr != null; jc_instr = jc_instr.getNextInstr()) {
            JcConstantClassRef class_ref;
            JcInstruction instr;
            String label_string = jc_instr.getLabel() == -1 ? new String("\t\t") : new String("\tL" + jc_instr.getLabel() + ":" + "\t");
            String opcode_string = JcByteCode.getMnemonic(jc_instr.getOpcode());
            String prefix_string = indent + label_string + opcode_string + " ";
            if (jc_instr instanceof JcInstrNoOperands) {
                this.pw.println(indent + label_string + opcode_string + ";");
                continue;
            }
            if (jc_instr instanceof JcInstrBranch) {
                this.pw.println(prefix_string + "L" + ((JcInstrBranch)jc_instr).getBranchLabel() + ";");
                continue;
            }
            if (jc_instr instanceof JcInstrByteIndex) {
                this.pw.println(prefix_string + ((JcInstrByteIndex)jc_instr).getIndex() + ";");
                continue;
            }
            if (jc_instr instanceof JcInstrByteValue) {
                this.pw.println(prefix_string + ((JcInstrByteValue)jc_instr).getValue() + ";");
                continue;
            }
            if (jc_instr instanceof JcInstrInterfaceRef) {
                instr = (JcInstrInterfaceRef)jc_instr;
                class_ref = ((JcInstrClassRef)instr).getClassRef();
                int nargs = ((JcInstrInterfaceRef)instr).getNargs();
                int method_token = ((JcInstrInterfaceRef)instr).getMethodToken();
                this.pw.println(prefix_string + nargs + " " + class_ref.getIndex() + " " + method_token + ";" + Comment.getComment(class_ref));
                continue;
            }
            if (jc_instr instanceof JcInstrTypeClassRef) {
                instr = (JcInstrTypeClassRef)jc_instr;
                class_ref = ((JcInstrClassRef)instr).getClassRef();
                if (class_ref == null) {
                    this.pw.println(prefix_string + ((JcInstrTypeClassRef)instr).getAtype() + " " + 0 + ";" + Comment.getComment(((JcInstrTypeClassRef)instr).getAtype(), class_ref));
                    continue;
                }
                this.pw.println(prefix_string + ((JcInstrTypeClassRef)instr).getAtype() + " " + class_ref.getIndex() + ";" + Comment.getComment(((JcInstrTypeClassRef)instr).getAtype(), class_ref));
                continue;
            }
            if (jc_instr instanceof JcInstrClassRef) {
                JcConstantClassRef class_ref2 = ((JcInstrClassRef)jc_instr).getClassRef();
                this.pw.println(prefix_string + class_ref2.getIndex() + ";" + Comment.getComment(class_ref2));
                continue;
            }
            if (jc_instr instanceof JcInstrFieldRef) {
                JcConstantFieldRef field_ref = ((JcInstrFieldRef)jc_instr).getFieldRef();
                this.pw.println(prefix_string + field_ref.getIndex() + ";" + Comment.getComment(field_ref));
                continue;
            }
            if (jc_instr instanceof JcInstrIntValue) {
                this.pw.println(prefix_string + ((JcInstrIntValue)jc_instr).getValue() + ";");
                continue;
            }
            if (jc_instr instanceof JcInstrLookupSwitch) {
                instr = (JcInstrLookupSwitch)jc_instr;
                int[] match_values = ((JcInstrLookupSwitch)instr).getMatchValues();
                int[] match_labels = ((JcInstrLookupSwitch)instr).getMatchLabels();
                this.pw.print(prefix_string + "L" + ((JcInstrLookupSwitch)instr).getDefaultLabel() + " " + ((JcInstrLookupSwitch)instr).getNumMatchPairs());
                for (int i = 0; i < match_values.length; ++i) {
                    this.pw.print(" " + match_values[i] + " " + "L" + match_labels[i]);
                }
                this.pw.println(";");
                continue;
            }
            if (jc_instr instanceof JcInstrMethodRef) {
                instr = (JcInstrMethodRef)jc_instr;
                JcConstantMethodRef method_ref = ((JcInstrMethodRef)instr).getMethodRef();
                this.pw.println(prefix_string + method_ref.getIndex() + ";" + Comment.getComment(method_ref));
                continue;
            }
            if (jc_instr instanceof JcInstrShortValue) {
                this.pw.println(prefix_string + ((JcInstrShortValue)jc_instr).getValue() + ";");
                continue;
            }
            if (jc_instr instanceof JcInstrTableSwitch) {
                int[] branch_labels;
                instr = (JcInstrTableSwitch)jc_instr;
                this.pw.print(prefix_string + "L" + ((JcInstrTableSwitch)instr).getDefaultLabel() + " ");
                this.pw.print(((JcInstrTableSwitch)instr).getLowValue() + " " + ((JcInstrTableSwitch)instr).getHighValue());
                for (int element : branch_labels = ((JcInstrTableSwitch)instr).getBranchLabels()) {
                    this.pw.print(" L" + element);
                }
                this.pw.println(";");
                continue;
            }
            if (jc_instr instanceof JcInstrIncrement) {
                instr = (JcInstrIncrement)jc_instr;
                this.pw.println(prefix_string + ((JcInstrIncrement)instr).getIndex() + " " + ((JcInstrIncrement)instr).getConstant() + ";");
                continue;
            }
            throw new ConverterInternalError();
        }
    }

    private void writeExceptionTable(JcMethod method, int tab_level) {
        JcException[] exceptions = method.getExceptions();
        if (exceptions.length == 0) {
            return;
        }
        String indent = this.getIndent(tab_level);
        this.pw.println(indent + ".exceptionTable {");
        this.pw.println(indent + "\t// start_block end_block handler_block catch_type_index");
        for (JcException element : exceptions) {
            int start_block = element.getStartBlock();
            int end_block = element.getEndBlock();
            int handler_block = element.getHandlerBlock();
            int catch_type_index = element.getCatchTypeClassRef().getIndex();
            this.pw.println(indent + "\t" + "L" + start_block + " L" + end_block + " L" + handler_block + " " + catch_type_index + ";");
        }
        this.pw.println(indent + "}");
    }

    private String getClassRep(String class_name) throws Exception {
        if (this.thisPackage(class_name)) {
            return Names.getClassName(class_name, 47);
        }
        EfClass ef_class = this.export_file_manager.getClass(class_name);
        JcImportTokenTableEntry class_entry = this.token_table.getClassEntry(class_name);
        if (class_entry == null) {
            throw new ConverterInternalError();
        }
        return class_entry.getTokenString();
    }

    private String getMethodRep(String class_name, String method_name, String descriptor) {
        if (this.thisPackage(class_name)) {
            return new String(Names.getClassName(class_name, 47) + "/" + method_name + descriptor);
        }
        JcImportTokenTableEntry method_entry = this.token_table.getMethodEntry(class_name, method_name, descriptor);
        if (method_entry == null) {
            throw new ConverterInternalError();
        }
        return method_entry.getTokenString() + descriptor;
    }

    private String getFieldRep(String class_name, String field_name, String descriptor) {
        if (this.thisPackage(class_name)) {
            return new String(Names.getClassName(class_name, 47) + "/" + field_name);
        }
        JcImportTokenTableEntry field_entry = this.token_table.getFieldEntry(class_name, field_name);
        if (field_entry == null) {
            throw new ConverterInternalError();
        }
        return field_entry.getTokenString();
    }

    private String getClassTokenString(int access_flags, int token) {
        if (Modifier.isPublic(access_flags)) {
            return new String(" " + Integer.toString(token));
        }
        return new String("");
    }

    private String getFieldTokenString(int access_flags, String descriptor, int token) {
        if (Modifier.isStatic(access_flags)) {
            if (Modifier.isPublic(access_flags) || Modifier.isProtected(access_flags)) {
                if (Modifier.isFinal(access_flags)) {
                    if (descriptor.startsWith("[") || descriptor.startsWith("L")) {
                        return new String(" " + Integer.toString(token));
                    }
                    return new String("");
                }
                return new String(" " + Integer.toString(token));
            }
            return new String("");
        }
        return new String(" " + Integer.toString(token));
    }

    private String getMethodTokenString(String method_name, int access_flags, int token) {
        if (method_name.equals("<init>")) {
            if (Modifier.isPublic(access_flags) || Modifier.isProtected(access_flags)) {
                return new String(" " + Integer.toString(token));
            }
            return new String("");
        }
        if (Modifier.isStatic(access_flags)) {
            if (Modifier.isPublic(access_flags) || Modifier.isProtected(access_flags)) {
                return new String(" " + Integer.toString(token));
            }
            return new String("");
        }
        if (Modifier.isPrivate(access_flags)) {
            return new String("");
        }
        return new String(" " + Integer.toString(token));
    }

    private boolean thisPackage(String class_name) {
        String package_name = Names.getPackageName(class_name);
        return this.jc_package.getPackageName().equals(package_name);
    }

    private String getFieldDescriptorString(String descriptor) {
        int type = DataType.getType(descriptor);
        switch (type) {
            case 1: {
                if (DataType.isBooleanType(descriptor)) {
                    return "boolean";
                }
                return "byte";
            }
            case 2: {
                return "short";
            }
            case 3: {
                return "int";
            }
            case 10: {
                String descriptor_string;
                String class_name;
                if (descriptor.equals("[B")) {
                    return "byte[]";
                }
                if (descriptor.equals("[Z")) {
                    return "boolean[]";
                }
                if (descriptor.equals("[S")) {
                    return "short[]";
                }
                if (descriptor.equals("[I")) {
                    return "int[]";
                }
                boolean is_array = false;
                if (descriptor.startsWith("[")) {
                    is_array = true;
                    descriptor = descriptor.substring(1);
                }
                if (this.thisPackage(class_name = descriptor.substring(1, descriptor.length() - 1))) {
                    descriptor_string = Names.getClassName(class_name, 47);
                } else {
                    JcImportTokenTableEntry class_entry = this.token_table.getClassEntry(class_name);
                    if (class_entry == null) {
                        throw new ConverterInternalError();
                    }
                    descriptor_string = class_entry.getTokenString();
                }
                if (is_array) {
                    return descriptor_string + "[]";
                }
                return descriptor_string;
            }
        }
        throw new ConverterInternalError();
    }

    public static String prepare(String input) {
        StringBuffer res = new StringBuffer("");
        for (int charOff = 0; charOff < input.length(); ++charOff) {
            if (input.charAt(charOff) < '\u0080') {
                res.append(input.charAt(charOff));
                continue;
            }
            res.append('\\');
            res.append('u');
            res.append(JcaWriter.toHex(input.charAt(charOff) >> 12 & 0xF));
            res.append(JcaWriter.toHex(input.charAt(charOff) >> 8 & 0xF));
            res.append(JcaWriter.toHex(input.charAt(charOff) >> 4 & 0xF));
            res.append(JcaWriter.toHex(input.charAt(charOff) >> 0 & 0xF));
        }
        return res.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }
}

