/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.SymbolTable;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class MethodTable {
    protected boolean optimize = true;
    public static final int MAX_ENTRIES = 128;
    protected JCClass parentClass;
    protected int base;
    protected boolean isPublic;
    protected Vector<String> nameVector;
    protected JCMethod[] methods;
    protected int fixedPkgMethodTableBase = -1;

    public MethodTable(JCClass parentClass, int base, boolean isPublic) {
        assert (base <= 128) : "base <= MAX_ENTRIES";
        this.parentClass = parentClass;
        this.base = base;
        this.isPublic = isPublic;
        this.nameVector = new Vector();
    }

    public void addMethod(String m) {
        this.nameVector.addElement(m);
        if (this.nameVector.size() > 128) {
            String table = this.isPublic ? Msg.getMessage("methodTable.public") : Msg.getMessage("methodTable.package");
            Object[] args = new Object[]{table, this.parentClass.getName()};
            Msg.error("methodTable.0", args);
        }
    }

    public void resolve(SymbolTable<Object, JCMethod> symtab, boolean isCapFile) {
        if (this.base > this.nameVector.size()) {
            String table = this.isPublic ? Msg.getMessage("methodTable.public") : Msg.getMessage("methodTable.package");
            Object[] args = new Object[]{table, this.parentClass.getName()};
            Msg.error("methodTable.1", args);
            return;
        }
        Enumeration<String> e = this.nameVector.elements();
        if (this.optimize) {
            for (int i = 0; i < this.base; ++i) {
                e.nextElement();
            }
        }
        this.methods = new JCMethod[this.getCount()];
        int index = 0;
        int expectedToken = this.base - 1;
        block1: while (e.hasMoreElements()) {
            String methodName = e.nextElement();
            ++expectedToken;
            JCClass currentClass = this.parentClass;
            JCMethod m = (JCMethod)symtab.get(currentClass.getName() + "/" + methodName);
            while (m == null) {
                if ((currentClass = currentClass.getSuperClass()) == null) {
                    if (!isCapFile || isCapFile && !this.isPublic) {
                        Object[] args = new Object[]{methodName, this.parentClass.getName()};
                        Msg.error("methodTable.2", args);
                        ++index;
                        continue block1;
                    }
                    ++index;
                    continue block1;
                }
                m = (JCMethod)symtab.get(currentClass.getName() + "/" + methodName);
            }
            if (Modifier.isStatic(m.getAttributes())) {
                Object[] args = new Object[]{methodName, this.parentClass.getName()};
                Msg.error("methodTable.2", args);
                ++index;
                continue;
            }
            int token = m.getMethodIdentifier().getMethodToken();
            if ((token & 0x7F) != expectedToken) {
                String table = this.isPublic ? Msg.getMessage("methodTable.public") : Msg.getMessage("methodTable.package");
                Object[] args = new Object[]{new Integer(token), m.getName(), table, m.getParentClass().getName()};
                Msg.error("methodTable.3", args);
                ++index;
                continue;
            }
            this.methods[index++] = m;
        }
    }

    public int getBase() {
        if (this.optimize) {
            return this.base;
        }
        return 0;
    }

    public int getCount() {
        int count = this.optimize ? this.nameVector.size() - this.base : this.nameVector.size();
        assert (count >= 0) : "count < 0: " + this.parentClass.getName();
        return count;
    }

    public Enumeration<JCMethod> elements() {
        return new MethodTableEnumerator(this.methods);
    }

    public Enumeration<String> nameElements() {
        return this.nameVector.elements();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.isPublic) {
            sb.append(".publicMethodTable ");
        } else {
            sb.append(".packageMethodTable ");
        }
        sb.append(this.getBase() + " {" + Msg.eol);
        Enumeration<String> e = this.nameElements();
        while (e.hasMoreElements()) {
            sb.append("\t" + e.nextElement() + Msg.eol);
        }
        sb.append("}" + Msg.eol);
        return sb.toString();
    }

    public int getFixedPkgMethodTableBase() {
        if (this.isPublic) {
            return -1;
        }
        if (this.fixedPkgMethodTableBase != -1) {
            return this.fixedPkgMethodTableBase;
        }
        JCClass superClass = this.parentClass.superClass;
        this.fixedPkgMethodTableBase = superClass == null ? this.base : (superClass.parentPackage.equals(this.parentClass.parentPackage) ? this.base + superClass.packageMethodTable.getFixedPkgMethodTableBase() : this.base + superClass.packageMethodTable.getFixedPkgMethodTableBase() + superClass.packageMethodTable.getCount());
        return this.fixedPkgMethodTableBase;
    }

    public boolean isPkgMethod(JCMethod m) {
        if (this.isPublic) {
            return false;
        }
        for (JCMethod element : this.methods) {
            if (!element.equals(m)) continue;
            return true;
        }
        return false;
    }

    static class MethodTableEnumerator
    implements Enumeration<JCMethod> {
        private int index;
        private JCMethod[] table;

        MethodTableEnumerator(JCMethod[] table) {
            this.table = table;
        }

        @Override
        public boolean hasMoreElements() {
            return this.table != null && this.index < this.table.length;
        }

        @Override
        public JCMethod nextElement() {
            if (this.table == null || this.index >= this.table.length) {
                throw new NoSuchElementException("MethodTableEnumerator");
            }
            return this.table[this.index++];
        }
    }
}

