/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.jcasm.ExceptionTable;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.cap.Component;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;

public class MethodComponent
extends Component {
    public static final int ACC_EXTENDED = 8;
    public static final int ACC_ABSTRACT = 4;
    protected Vector<JCMethod> methodVector = new Vector();
    protected Vector<ExceptionTable> exceptionVector = new Vector();
    protected int handlerCount;

    public MethodComponent(JCPackage p) {
        super(p);
    }

    @Override
    public int dataSize() {
        int size = 1;
        for (ExceptionTable tbl : this.exceptionVector) {
            size += tbl.size();
        }
        for (JCMethod m : this.methodVector) {
            size += m.size();
        }
        return size;
    }

    public void add(JCClass c) {
        if (Modifier.isInterface(c.getAttributes())) {
            return;
        }
        Enumeration<JCMethod> g = c.methodElements();
        while (g.hasMoreElements()) {
            JCMethod method = g.nextElement();
            this.methodVector.addElement(method);
            ExceptionTable e = method.getExceptionTable();
            if (e == null) continue;
            this.exceptionVector.addElement(e);
            this.handlerCount += e.count();
            if (this.handlerCount <= 255) continue;
            Msg.error(Msg.getMessage("package.5"));
            return;
        }
    }

    void assignAddresses() {
        int address = 1;
        for (ExceptionTable tbl : this.exceptionVector) {
            tbl.relocate(address);
            address += tbl.size();
        }
        for (JCMethod m : this.methodVector) {
            m.relocate(address);
            address += m.size();
        }
    }

    @Override
    protected byte[] toByteArray() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            byte[] array;
            byte[] header = super.toByteArray();
            dos.write(header, 0, header.length);
            dos.writeByte(this.handlerCount);
            for (ExceptionTable tbl : this.exceptionVector) {
                array = tbl.toByteArray();
                dos.write(array, 0, array.length);
            }
            for (JCMethod m : this.methodVector) {
                array = m.toByteArray();
                dos.write(array, 0, array.length);
            }
            dos.flush();
        }
        catch (IOException e) {
            return null;
        }
        assert (this.size() == bos.size()) : "size() != bos.size()";
        return bos.toByteArray();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append("Handler count: " + this.handlerCount + Msg.eol);
        for (ExceptionTable tbl : this.exceptionVector) {
            sb.append(tbl.toString() + Msg.eol);
        }
        for (JCMethod me : this.methodVector) {
            sb.append(me.toString());
        }
        return sb.toString();
    }

    protected void getDebugOffsets(Map<String, Integer> offsets) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            byte[] array;
            dos.writeByte(this.handlerCount);
            for (ExceptionTable tbl : this.exceptionVector) {
                array = tbl.toByteArray();
                dos.write(array, 0, array.length);
            }
            for (JCMethod m : this.methodVector) {
                array = m.toByteArray();
                offsets.put(m.getName(), new Integer(dos.size()));
                dos.write(array, 0, array.length);
            }
        }
        catch (IOException e) {
            return;
        }
    }
}

