/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.mask.jrefmask;

import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.Info;
import com.sun.javacard.jcasm.Instruction;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.MethodIdentifier;
import com.sun.javacard.jcasm.Operand;
import com.sun.javacard.jcasm.Statement;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Enumeration;

class MethodFormatter {
    JCMethod method;
    ByteArrayOutputStream bos;
    DataOutputStream dos;

    public MethodFormatter(JCMethod m) {
        this.method = m;
    }

    public byte[] toByteArray() {
        this.bos = new ByteArrayOutputStream();
        this.dos = new DataOutputStream(this.bos);
        try {
            this.dos.write(this.method.getMethodHeader());
            if (Modifier.isNative(this.method.getAttributes())) {
                MethodIdentifier mid = this.method.getMethodIdentifier();
                this.dos.writeShort(this.method.getNativeToken());
            }
            Enumeration<Statement> h = this.method.statementElements();
            while (h.hasMoreElements()) {
                Statement s = h.nextElement();
                this.format(s);
            }
            this.dos.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.bos.toByteArray();
    }

    protected void format(Statement s) throws IOException {
        if (s.getInstruction() == null) {
            return;
        }
        this.format(s.getInstruction());
    }

    protected void format(Instruction i) throws IOException {
        this.dos.writeByte(i.getOpcode());
        Enumeration<Operand> e = i.operandElements();
        while (e.hasMoreElements()) {
            Operand o = e.nextElement();
            this.format(o);
        }
    }

    protected void format(Operand o) throws IOException {
        if (o.getType() == 8) {
            Info info = o.resolve();
            switch (info.getType()) {
                case 1: 
                case 4: 
                case 6: {
                    int addr = info.resolve().getRelocAddr();
                    this.dos.writeShort(addr);
                    break;
                }
                case 5: {
                    int addr = info.resolve().getRelocAddr();
                    this.dos.writeShort(addr);
                    break;
                }
                case 3: {
                    JCMethod m = (JCMethod)info.resolve();
                    MethodIdentifier mid = m.getMethodIdentifier();
                    int token = mid.getMethodToken();
                    int params = m.getParams();
                    this.dos.writeByte(params);
                    this.dos.writeByte(token);
                    break;
                }
                case 2: {
                    Field f = (Field)info.resolve();
                    JCClass c = f.getParentClass();
                    int fToken = f.getFieldIdentifier().getFieldToken();
                    int offset = fToken + c.getInstanceBase();
                    this.dos.writeShort(offset);
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        } else if (o.getType() == 7) {
            Info info = o.resolve();
            switch (info.getType()) {
                case 2: {
                    Field f = (Field)info.resolve();
                    JCClass c = f.getParentClass();
                    int fToken = f.getFieldIdentifier().getFieldToken();
                    int offset = fToken + c.getInstanceBase();
                    this.dos.writeByte(offset);
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        } else if (o.size() == 1) {
            this.dos.writeByte(o.getValue());
        } else if (o.size() == 2) {
            this.dos.writeShort(o.getValue());
        } else if (o.size() == 4) {
            this.dos.writeInt(o.getValue());
        }
    }
}

