/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ClassDescriptor;
import com.sun.javacard.offcardverifier.ClassInfo;
import com.sun.javacard.offcardverifier.ExportedClass;
import com.sun.javacard.offcardverifier.ImportComponent;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.EfClass;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;

public class Classref {
    static int multiSelectable = -1;
    public static int Object;
    public static int Throwable;
    public static int Shareable;
    public static int Remote;

    public static boolean isExternal(int cr) {
        return (cr & 0x8000) != 0;
    }

    public static int packageToken(int cr) {
        return cr >> 8 & 0x7F;
    }

    public static int classToken(int cr) {
        return cr & 0xFF;
    }

    public static ClassDescriptor checkInternal(int ref) {
        ClassDescriptor p = Cap.Descriptor.firstClassDescriptor();
        for (int i = Cap.Descriptor.classCount(); i > 0; --i) {
            if (ref == p.thisClass()) {
                return p;
            }
            p.next();
        }
        throw new VerifierError("Classref.1", ref);
    }

    public static EfClass checkExternal(int ref) {
        int pkgTok = Classref.packageToken(ref);
        int clsTok = Classref.classToken(ref);
        ExportFile ef = Cap.Import.importPackage(pkgTok);
        if (ef == null) {
            throw new VerifierError("Classref.2", ref, pkgTok);
        }
        for (EfClass ec : ef.classes) {
            if (ec.token != clsTok) continue;
            return ec;
        }
        throw new VerifierError("Classref.3", ref, clsTok);
    }

    public static EfClass exportclassForExternal(int ref) {
        int pkgTok = Classref.packageToken(ref);
        int clsTok = Classref.classToken(ref);
        ExportFile ef = Cap.Import.exportfileForPackageToken(pkgTok);
        if (ef == null) {
            throw new VerifierError("Classref.4", ref, pkgTok);
        }
        for (EfClass ec : ef.classes) {
            if (ec.token != clsTok) continue;
            return ec;
        }
        throw new VerifierError("Classref.5", ref, clsTok);
    }

    static void check(int ref) {
        if (Classref.isExternal(ref)) {
            Classref.checkExternal(ref);
        } else {
            Classref.checkInternal(ref);
        }
    }

    public static int checkAndGetAccessFlags(int ref) {
        if (!Classref.isExternal(ref)) {
            ClassDescriptor cdesc = Classref.checkInternal(ref);
            return cdesc.flags();
        }
        EfClass ec = Classref.checkExternal(ref);
        int flags = 0;
        if ((ec.accessFlag & 1) != 0) {
            flags |= 1;
        }
        if ((ec.accessFlag & 0x10) != 0) {
            flags |= 0x10;
        }
        if ((ec.accessFlag & 0x200) != 0) {
            flags |= 0x40;
        }
        if ((ec.accessFlag & 0x400) != 0) {
            flags |= 0x80;
        }
        return flags;
    }

    public static boolean isSubclass(int ref1, int ref2) {
        while (!Classref.isExternal(ref1)) {
            if (ref1 == ref2) {
                return true;
            }
            ref1 = Cap.Class.infoOfs(ref1).superclass();
        }
        if (ref1 == ref2) {
            return true;
        }
        if (!Classref.isExternal(ref2)) {
            return false;
        }
        EfClass ec1 = Classref.exportclassForExternal(ref1);
        EfClass ec2 = Classref.exportclassForExternal(ref2);
        for (int i = 0; i < ec1.supers.length; ++i) {
            if (!ec1.superName(i).equals(ec2.thisName())) continue;
            return true;
        }
        return false;
    }

    static int lub(int ref1, int ref2) {
        int j;
        int i;
        int i2;
        EfClass ec2;
        String ec2name;
        while (!Classref.isExternal(ref1) && !Classref.isExternal(ref2)) {
            if (ref1 == ref2) {
                return ref1;
            }
            if (Classref.isSubclass(ref1, ref2)) {
                return ref2;
            }
            if (Classref.isSubclass(ref2, ref1)) {
                return ref1;
            }
            ref1 = Cap.Class.infoOfs(ref1).superclass();
            ref2 = Cap.Class.infoOfs(ref2).superclass();
        }
        while (!Classref.isExternal(ref1)) {
            ref1 = Cap.Class.infoOfs(ref1).superclass();
        }
        while (!Classref.isExternal(ref2)) {
            ref2 = Cap.Class.infoOfs(ref2).superclass();
        }
        if (ref1 == ref2) {
            return ref1;
        }
        EfClass ec1 = Classref.exportclassForExternal(ref1);
        String ec1name = ec1.thisName();
        if (ec1name.equals(ec2name = (ec2 = Classref.exportclassForExternal(ref2)).thisName())) {
            return ref1;
        }
        for (i2 = 0; i2 < ec1.supers.length; ++i2) {
            if (!ec1.superName(i2).equals(ec2name)) continue;
            return ref2;
        }
        for (i2 = 0; i2 < ec2.supers.length; ++i2) {
            if (!ec2.superName(i2).equals(ec1name)) continue;
            return ref1;
        }
        int[] supclasses = new int[ec1.supers.length + ec2.supers.length];
        int numSupclasses = 0;
        block5: for (i = 0; i < ec1.supers.length; ++i) {
            String sup1 = ec1.superName(i);
            for (j = 0; j < ec2.supers.length; ++j) {
                if (!sup1.equals(ec2.superName(j))) continue;
                supclasses[numSupclasses] = Classref.refForName(sup1);
                ++numSupclasses;
                continue block5;
            }
        }
        for (i = 0; i < numSupclasses; ++i) {
            int c = supclasses[i];
            for (j = 0; j < numSupclasses && Classref.isSubclass(c, supclasses[j]); ++j) {
            }
            if (j != numSupclasses) continue;
            return c;
        }
        throw new VerifierError("Classref.9", (Object)ec1.thisName(), (Object)ec2.thisName());
    }

    public static boolean isSameOrSuper(int ref1, int ref2) {
        if (ref1 == ref2) {
            return true;
        }
        if (!Classref.isExternal(ref1)) {
            return ref2 == Cap.Class.infoOfs(ref1).superclass();
        }
        if (!Classref.isExternal(ref2)) {
            return false;
        }
        EfClass ec1 = Classref.exportclassForExternal(ref1);
        EfClass ec2 = Classref.exportclassForExternal(ref2);
        for (int i = 0; i < ec1.supers.length; ++i) {
            if (!ec1.superName(i).equals(ec2.thisName())) continue;
            return true;
        }
        return false;
    }

    public static EfClass exportclassForName(String classname) {
        int lastslash = classname.lastIndexOf(47);
        if (lastslash == -1) {
            throw new VerifierError("Classref.6", classname);
        }
        String pkgname = classname.substring(0, lastslash);
        int pkgtok = Cap.Import.tokenForPackage(pkgname);
        ExportFile ef = Cap.Import.exportfileForPackageToken(pkgtok);
        for (EfClass ec : ef.classes) {
            if (!classname.equals(ec.thisName())) continue;
            return ec;
        }
        return null;
    }

    public static int refForName(String classname) {
        int lastslash = classname.lastIndexOf(47);
        if (lastslash == -1) {
            throw new VerifierError("Classref.6", classname);
        }
        String pkgname = classname.substring(0, lastslash);
        if (Cap.Export != null && pkgname.equals(Cap.Export.exportfile.thisName())) {
            for (EfClass ec : Cap.Export.exportfile.classes) {
                if (!classname.equals(ec.thisName())) continue;
                return Classref.forExportToken(ec.token);
            }
        }
        int pkgtok = Cap.Import.tokenForPackage(pkgname);
        ExportFile ef = Cap.Import.exportfileForPackageToken(pkgtok);
        for (EfClass ec : ef.classes) {
            if (!classname.equals(ec.thisName())) continue;
            return 0x8000 | pkgtok << 8 | ec.token;
        }
        throw new VerifierError("Classref.7", (Object)classname, (Object)pkgname);
    }

    static int forExportToken(int token) {
        ExportedClass ecls = Cap.Export.firstExportedClass();
        for (int t = 0; t < Cap.Export.classCount(); ++t) {
            if (t == token) {
                return ecls.classOffset();
            }
            ecls.next();
        }
        throw new VerifierError("Classref.8", token);
    }

    public static EfClass toExportClass(int ref) {
        if (Classref.isExternal(ref)) {
            return Classref.checkExternal(ref);
        }
        ClassDescriptor cdesc = Classref.checkInternal(ref);
        int token = cdesc.token();
        if (token == 255) {
            return null;
        }
        if (Cap.Export == null) {
            return null;
        }
        return Cap.Export.exportclassForToken(token);
    }

    public static EfClass checkExportedAndReturnExportClass(int ref) {
        if (Classref.isExternal(ref)) {
            return Classref.checkExternal(ref);
        }
        ClassDescriptor cdesc = Classref.checkInternal(ref);
        int token = cdesc.token();
        if (token == 255) {
            return null;
        }
        if (Cap.Export == null) {
            return null;
        }
        if (!Cap.Export.isExported(ref)) {
            return null;
        }
        return Cap.Export.exportclassForToken(token);
    }

    static boolean implementsInterface(int ref1, int ref2) {
        if (Classref.isExternal(ref1)) {
            int i;
            if (!Classref.isExternal(ref2)) {
                return false;
            }
            EfClass ec1 = Classref.exportclassForExternal(ref1);
            EfClass ec2 = Classref.exportclassForExternal(ref2);
            for (i = 0; i < ec1.interfaces.length; ++i) {
                if (!ec1.interfaceName(i).equals(ec2.thisName())) continue;
                return true;
            }
            for (i = 0; i < ec1.supers.length; ++i) {
                EfClass sup = Classref.exportclassForName(ec1.superName(i));
                if (sup == null) continue;
                int j = 0;
                while (i < sup.interfaces.length) {
                    if (sup.interfaceName(j).equals(ec2.thisName())) {
                        return true;
                    }
                    ++j;
                }
            }
            return false;
        }
        ClassDescriptor cdescr = Classref.checkInternal(ref1);
        for (int i = 0; i < cdescr.interfaceCount(); ++i) {
            if (!Classref.extendsInterface(cdescr.interfaceRef(i), ref2)) continue;
            return true;
        }
        if ((cdescr.flags() & 0x40) != 0) {
            return false;
        }
        int superref = Cap.Class.infoOfs(ref1).superclass();
        if (superref == 65535) {
            return false;
        }
        return Classref.implementsInterface(superref, ref2);
    }

    static boolean extendsInterface(int ref1, int ref2) {
        if (ref1 == ref2) {
            return true;
        }
        if (Classref.isExternal(ref1)) {
            if (!Classref.isExternal(ref2)) {
                return false;
            }
            EfClass ec1 = Classref.exportclassForExternal(ref1);
            EfClass ec2 = Classref.exportclassForExternal(ref2);
            for (int i = 0; i < ec1.interfaces.length; ++i) {
                if (!ec1.interfaceName(i).equals(ec2.thisName())) continue;
                return true;
            }
            return false;
        }
        ClassInfo cinfo = Cap.Class.infoOfs(ref1);
        for (int i = 0; i < cinfo.interfaceCount(); ++i) {
            if (cinfo.superinterface(i) != ref2) continue;
            return true;
        }
        return false;
    }

    static int numberOfMethods(int ref) {
        if (Classref.isExternal(ref)) {
            return Classref.checkExternal((int)ref).methods.length;
        }
        return Classref.checkInternal(ref).methodCount();
    }

    static int totalInstanceSize(int ref) {
        if (Classref.isExternal(ref)) {
            EfClass ec = Classref.checkExternal(ref);
            int size = ec.declaredInstanceSize();
            for (int i = 0; i < ec.supers.length; ++i) {
                size += Classref.exportclassForName(ec.superName(i)).declaredInstanceSize();
            }
            return size;
        }
        ClassInfo cinfo = Cap.Class.infoOfs(ref);
        if ((cinfo.flags() & 8) != 0) {
            return 0;
        }
        if (cinfo.superclass() == 65535) {
            return cinfo.declaredInstanceSize();
        }
        return Classref.totalInstanceSize(cinfo.superclass()) + cinfo.declaredInstanceSize();
    }

    static String pretty(int ref) {
        if (Classref.isExternal(ref)) {
            EfClass ec = Classref.checkExternal(ref);
            return ec.thisName().replace('/', '.');
        }
        return Messages.format("Classref.10", ref);
    }

    static boolean isMultiSelectable(int ref) {
        return Classref.implementsInterface(ref, multiSelectable);
    }

    static boolean isRemote(int ref, boolean forClass) {
        if (Remote == -1) {
            try {
                Remote = Classref.refForName("java/rmi/Remote");
            }
            catch (VerifierError e) {
                return false;
            }
        }
        if (forClass) {
            return Classref.implementsInterface(ref, Remote);
        }
        return Classref.extendsInterface(ref, Remote);
    }

    static void initialize() {
        Object = Classref.refForName("java/lang/Object");
        Throwable = Classref.refForName("java/lang/Throwable");
        try {
            Shareable = Classref.refForName("javacard/framework/Shareable");
            multiSelectable = Classref.refForName("javacard/framework/MultiSelectable");
        }
        catch (VerifierError e) {
            if (ImportComponent.findExportByName("javacard/framework") != null) {
                VerifierError.warning("Classref.100");
            }
            Shareable = -1;
            multiSelectable = -1;
        }
    }

    static {
        Remote = -1;
    }
}

