/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier.exportfile;

import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.EfClass;
import com.sun.javacard.offcardverifier.exportfile.EfConstantInfo;
import com.sun.javacard.offcardverifier.exportfile.EfConstant_ClassRef;
import com.sun.javacard.offcardverifier.exportfile.EfConstant_Integer;
import com.sun.javacard.offcardverifier.exportfile.EfConstant_Package;
import com.sun.javacard.offcardverifier.exportfile.EfConstant_Utf8;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.BitSet;
import java.util.HashSet;

public class ExportFile {
    DataInputStream in;
    static final byte CONSTANT_PACKAGE = 13;
    static final byte CONSTANT_CLASS_REF = 7;
    static final byte CONSTANT_INTEGER = 3;
    static final byte CONSTANT_UTF8 = 1;
    public static final short ACC_PUBLIC = 1;
    public static final short ACC_PROTECTED = 4;
    public static final short ACC_STATIC = 8;
    public static final short ACC_FINAL = 16;
    public static final short ACC_INTERFACE = 512;
    public static final short ACC_ABSTRACT = 1024;
    public static final short ACC_SHAREABLE = 2048;
    public static final short ACC_LIBRARY = 1;
    public static final short ACC_REMOTE = 4096;
    public String file;
    EfConstantInfo[] constantPool;
    int thisPackage;
    int minorVersion;
    public EfClass[] classes;
    private boolean sameVersion;
    static final int MAGIC_NUMBER = 16435934;
    static final int MAJOR_VERSION = 2;
    static final int MINOR_VERSION = 2;
    static final int MIN_MINOR_VERSION = 1;

    void checkPackageIndex(int index) {
        if (index < 0 || index >= this.constantPool.length || !(this.constantPool[index] instanceof EfConstant_Package)) {
            throw new VerifierError("ExportFile.3", index);
        }
    }

    void checkClassrefIndex(int index) {
        if (index < 0 || index >= this.constantPool.length || !(this.constantPool[index] instanceof EfConstant_ClassRef)) {
            throw new VerifierError("ExportFile.4", index);
        }
    }

    void checkIntegerIndex(int index) {
        if (index < 0 || index >= this.constantPool.length || !(this.constantPool[index] instanceof EfConstant_Integer)) {
            throw new VerifierError("ExportFile.5", index);
        }
    }

    void checkUtf8Index(int index) {
        if (index < 0 || index >= this.constantPool.length || !(this.constantPool[index] instanceof EfConstant_Utf8)) {
            throw new VerifierError("ExportFile.6", index);
        }
    }

    public EfConstant_Package thisPackage() {
        return (EfConstant_Package)this.constantPool[this.thisPackage];
    }

    public String thisName() {
        EfConstant_Package thisPkg = this.thisPackage();
        return ((EfConstant_Utf8)this.constantPool[thisPkg.nameIndex]).contents;
    }

    void read() throws IOException {
        int i;
        int magic = this.in.readInt();
        if (magic != 16435934) {
            throw new VerifierError("ExportFile.2");
        }
        this.minorVersion = this.in.readUnsignedByte();
        int majorVersion = this.in.readUnsignedByte();
        if (majorVersion != 2 || this.minorVersion > 2 || this.minorVersion < 1) {
            throw new VerifierError("ExportFile.7", majorVersion, this.minorVersion);
        }
        int constantPoolCount = this.in.readUnsignedShort();
        this.constantPool = new EfConstantInfo[constantPoolCount];
        for (i = 0; i < constantPoolCount; ++i) {
            EfConstantInfo ci;
            int tag = this.in.readUnsignedByte();
            switch (tag) {
                case 3: {
                    ci = new EfConstant_Integer(this);
                    break;
                }
                case 1: {
                    ci = new EfConstant_Utf8(this);
                    break;
                }
                case 7: {
                    ci = new EfConstant_ClassRef(this);
                    break;
                }
                case 13: {
                    ci = new EfConstant_Package(this);
                    break;
                }
                default: {
                    throw new VerifierError("ExportFile.8", tag);
                }
            }
            ci.read();
            this.constantPool[i] = ci;
        }
        for (i = 0; i < constantPoolCount; ++i) {
            this.constantPool[i].validate();
        }
        this.thisPackage = this.in.readUnsignedShort();
        this.checkPackageIndex(this.thisPackage);
        int exportClassCount = this.in.readUnsignedByte();
        this.classes = new EfClass[exportClassCount];
        for (int i2 = 0; i2 < exportClassCount; ++i2) {
            EfClass cl = new EfClass(this);
            cl.read();
            this.classes[i2] = cl;
        }
    }

    public void verify() {
        try {
            BitSet classTokens = new BitSet();
            HashSet<String> classNames = new HashSet<String>();
            for (EfClass element : this.classes) {
                element.verify(classNames, classTokens);
            }
        }
        catch (VerifierError e) {
            throw new VerifierError("ExportFile.52", (Object)this.file, (Object)e.getMessage());
        }
    }

    public static ExportFile readFromFile(File filename) {
        try {
            FileInputStream fs = new FileInputStream(filename);
            ExportFile ef = new ExportFile();
            ef.file = filename.toString();
            ef.in = new DataInputStream(new BufferedInputStream(fs));
            ef.read();
            fs.close();
            return ef;
        }
        catch (FileNotFoundException e) {
            throw new VerifierError("ExportFile.50", filename.toString());
        }
        catch (IOException e) {
            throw new VerifierError("ExportFile.51", filename.toString());
        }
        catch (VerifierError e) {
            throw new VerifierError("ExportFile.52", (Object)filename.toString(), (Object)e.getMessage());
        }
    }

    public EfClass findClassByName(String className) {
        for (EfClass element : this.classes) {
            if (!className.equals(element.thisName())) continue;
            return element;
        }
        return null;
    }

    public EfClass findClassByToken(short tok) {
        for (EfClass element : this.classes) {
            if (tok != element.token) continue;
            return element;
        }
        return null;
    }

    public void compareTo(ExportFile ef) {
        this.sameVersion = false;
        this.thisPackage().compareTo(ef.thisPackage());
        this.compareClasses(ef);
    }

    public void checkEquality(ExportFile ef) {
        this.sameVersion = true;
        this.thisPackage().checkEquality(ef.thisPackage());
        this.compareClasses(ef);
    }

    private void compareClasses(ExportFile ef) {
        boolean found = false;
        int oldSize = this.classes.length;
        int newSize = ef.classes.length;
        if (this.sameVersion && oldSize != newSize) {
            throw new VerifierError("RevisionError.2");
        }
        for (int i = 0; i < oldSize; ++i) {
            found = false;
            EfClass oldClass = this.classes[i];
            String className1 = oldClass.thisName();
            for (int j = 0; j < newSize; ++j) {
                EfClass newClass = ef.classes[j];
                String className2 = newClass.thisName();
                if (!className2.equals(className1)) continue;
                found = true;
                if (this.sameVersion) {
                    oldClass.checkEquality(newClass);
                    break;
                }
                oldClass.compareTo(newClass);
                break;
            }
            if (found) continue;
            throw new VerifierError("RevisionError.3", className1);
        }
    }
}

