/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.packager;

import com.sun.javacard.cli.CommandOption;
import com.sun.javacard.cli.SubCommand;
import com.sun.javacard.packager.ErrorKey;
import com.sun.javacard.packager.OptionNames;
import com.sun.javacard.packager.Packager;
import com.sun.javacard.packager.model.ClassicLibrary;
import com.sun.javacard.packager.model.ClassicModule;
import com.sun.javacard.packager.model.ExtendedModule;
import com.sun.javacard.packager.model.ExtensionLibrary;
import com.sun.javacard.packager.model.ValidValues;
import com.sun.javacard.packager.model.WebModule;
import com.sun.javacard.tools.util.JCToolsLogger;
import com.sun.javacard.util.AIDUtils;
import com.sun.javacard.util.Diagnostics;
import com.sun.javacard.util.FileUtils;
import com.sun.javacard.validator.Validator;
import java.io.File;
import java.util.Vector;
import org.apache.commons.cli.Option;

public class CreateCommand
extends SubCommand {
    private boolean nowarn = false;

    public CreateCommand() {
        super("create");
    }

    @Override
    public void setup() {
        this.addOption(new CommandOption("t", "type"));
        this.addOption(new CommandOption("e", "exportpath"));
        this.addOption(new CommandOption("p", "packageaid"));
        this.addOption(new CommandOption("s", "sign", false));
        this.addOption(new CommandOption("A", "alias"));
        this.addOption(new CommandOption("K", "keystore"));
        this.addOption(new CommandOption("S", "storepass"));
        this.addOption(new CommandOption("P", "passkey"));
        this.addOption(new CommandOption("f", "force", false));
        this.addOption(new CommandOption("c", "compress", false));
        this.addOption(new CommandOption("o", "out"));
        this.addOption(new CommandOption("n", "nowarn", false));
        this.addOption(new CommandOption("k", "keepproxysource"));
        this.addOption(new CommandOption("u", "useproxyclass", false));
    }

    @Override
    public int execute() throws Exception {
        Packager packager = Packager.getPackager();
        packager.setVerbose(this.verbose);
        block17: for (Option option : this.optionsArray) {
            switch (OptionNames.valueOf(option.getLongOpt().toUpperCase())) {
                case XTRA: {
                    packager.addXtraOption(option.getValue());
                    continue block17;
                }
                case TYPE: {
                    packager.setType(option.getValue());
                    continue block17;
                }
                case PACKAGEAID: {
                    packager.setPackageAID(option.getValue());
                    continue block17;
                }
                case EXPORTPATH: {
                    packager.setExportPath(option.getValue());
                    continue block17;
                }
                case SIGN: {
                    packager.setSign(true);
                    continue block17;
                }
                case KEYSTORE: {
                    packager.setKeystore(option.getValue());
                    continue block17;
                }
                case ALIAS: {
                    packager.setAlias(option.getValue());
                    continue block17;
                }
                case STOREPASS: {
                    packager.setStorepass(option.getValue());
                    continue block17;
                }
                case PASSKEY: {
                    packager.setPasskey(option.getValue());
                    continue block17;
                }
                case FORCE: {
                    packager.setForce(true);
                    continue block17;
                }
                case COMPRESS: {
                    packager.setCompress(true);
                    continue block17;
                }
                case OUT: {
                    packager.setOut(new File(option.getValue()));
                    continue block17;
                }
                case NOWARN: {
                    this.nowarn = true;
                    continue block17;
                }
                case KEEPPROXYSOURCE: {
                    packager.setKeepDir(option.getValue());
                    continue block17;
                }
                case USEPROXYCLASS: {
                    packager.setUseProxyClass();
                    continue block17;
                }
                default: {
                    String str1 = option.getOpt();
                    String str2 = option.getLongOpt();
                    String str3 = "";
                    if (str1 != null) {
                        str3 = str3 + str1;
                    }
                    if (str1 != null && str2 != null) {
                        str3 = str3 + " (or) ";
                    }
                    if (str2 != null) {
                        str3 = str3 + str2;
                    }
                    this.toolsLogger.severe("Unknown option:" + str3, new Object[0]);
                    throw new Exception("Unknown option " + str3);
                }
            }
        }
        if (this.argumentsArray == null || this.argumentsArray.length != 1) {
            this.toolsLogger.severe(ErrorKey.ModuleOrLibFileOrFolderNotSpecified.getMessage(new Object[0]), new Object[0]);
            throw new Exception(ErrorKey.ModuleOrLibFileOrFolderNotSpecified.getMessage(new Object[0]));
        }
        String s = this.argumentsArray[0];
        if (new File(s).isFile()) {
            throw new Exception(ErrorKey.IsNotADirectory.getMessage("\"" + s + "\""));
        }
        this.toolsLogger.info("create.info.1", new Object[0]);
        if (packager.getKeepDir() != null && packager.isUseProxyClass()) {
            throw new Exception(ErrorKey.OptionConflict.getMessage(new Object[0]));
        }
        if (this.validateCommandLine(packager) != 0) {
            return 1;
        }
        this.toolsLogger.info("create.info.2", new Object[0]);
        int type = 0;
        if (packager.getType().equals("web")) {
            packager.setPackageItem(new WebModule(this.argumentsArray[0]));
            type = 10;
        } else if (packager.getType().equals("classic-applet")) {
            packager.setPackageItem(new ClassicModule(this.argumentsArray[0]));
            type = 12;
        } else if (packager.getType().equals("extended-applet")) {
            packager.setPackageItem(new ExtendedModule(this.argumentsArray[0]));
            type = 11;
        } else if (packager.getType().equals("extension-lib")) {
            packager.setPackageItem(new ExtensionLibrary(this.argumentsArray[0]));
            type = 1;
        } else if (packager.getType().equals("classic-lib")) {
            packager.setPackageItem(new ClassicLibrary(this.argumentsArray[0]));
            type = 0;
        }
        packager.initialize();
        this.toolsLogger.info("create.info.3", new Object[0]);
        Diagnostics diagnostics = new Diagnostics();
        if (packager.getType().equals("classic-applet") || packager.getType().equals("classic-lib")) {
            diagnostics.ok = true;
        } else {
            Validator v = new Validator();
            diagnostics = v.validate(this.argumentsArray[0], type, packager.getWorkDir());
        }
        boolean ok = false;
        if (diagnostics.isOk()) {
            packager.process();
            packager.gatherDiagnostics(diagnostics);
            FileUtils.deleteDir(packager.getWorkDir());
            ok = packager.isOk(true);
            if (this.nowarn && packager.countWarnings() > 0) {
                this.toolsLogger.info(ErrorKey.noWarnMessage.getMessage(new Object[0]), new Object[0]);
            }
        }
        ok = ok && diagnostics.isOk();
        String status = ok ? ErrorKey.SUCCESS.getMessage(new Object[0]) : ErrorKey.FAILED.getMessage(new Object[0]);
        this.toolsLogger = JCToolsLogger.getLogger("com/sun/javacard/packager", "com/sun/javacard/packager/messages");
        this.toolsLogger.info("create.info.4", new Object[0]);
        diagnostics.printDiagnostics(status, "Packager/create", ErrorKey.Error2.getMessage(new Object[0]), ErrorKey.Warning2.getMessage(new Object[0]), ErrorKey.Error1.getMessage(new Object[0]), ErrorKey.Warning1.getMessage(new Object[0]));
        return ok ? 0 : 1;
    }

    private int validateCommandLine(Packager packager) {
        Vector<String> errorMessages = new Vector<String>();
        String type = packager.getType();
        if (type == null) {
            errorMessages.add(ErrorKey.MissingType.getMessage(new Object[0]));
        } else if (!ValidValues.isValidAppType(type) && !ValidValues.isValidLibType(type)) {
            errorMessages.add(ErrorKey.InvalidModuleOrLibType.getMessage(type));
        }
        if (packager.getOut() == null) {
            errorMessages.add(ErrorKey.OutFileNotSpecified.getMessage(new Object[0]));
        }
        if (packager.getPackageAID() != null) {
            try {
                AIDUtils.getAsPrintableHex(packager.getPackageAID());
            }
            catch (Throwable ex) {
                errorMessages.add(ErrorKey.InvalidPackageAID.getMessage(packager.getPackageAID()));
            }
        }
        if (packager.isSign()) {
            if (packager.getKeystore() == null) {
                errorMessages.add(ErrorKey.MissingKeystore.getMessage(new Object[0]));
            }
            if (packager.getAlias() == null) {
                errorMessages.add(ErrorKey.MissingAlias.getMessage(new Object[0]));
            }
            if (packager.getPasskey() == null) {
                errorMessages.add(ErrorKey.MissingPassword.getMessage(new Object[0]));
            }
            if (packager.getStorepass() == null) {
                errorMessages.add(ErrorKey.MissingStorepass.getMessage(new Object[0]));
            }
        }
        if (!errorMessages.isEmpty()) {
            for (String str : errorMessages) {
                this.toolsLogger.severe("[ " + ErrorKey.Error1.getMessage(new Object[0]) + "] " + str.trim(), new Object[0]);
            }
            return 1;
        }
        return 0;
    }
}

