/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.packager;

import com.sun.javacard.cli.CommandOption;
import com.sun.javacard.cli.SubCommand;
import com.sun.javacard.packager.ErrorKey;
import com.sun.javacard.packager.OptionNames;
import com.sun.javacard.packager.Packager;
import com.sun.javacard.packager.model.Signer;
import com.sun.javacard.util.Diagnostics;
import java.io.File;
import java.util.Vector;
import org.apache.commons.cli.Option;

public class SignCommand
extends SubCommand {
    Signer signer = new Signer();

    public SignCommand() {
        super("sign");
    }

    @Override
    public void setup() {
        this.addOption(new CommandOption("A", "alias"));
        this.addOption(new CommandOption("K", "keystore"));
        this.addOption(new CommandOption("S", "storepass"));
        this.addOption(new CommandOption("P", "passkey"));
    }

    @Override
    public int execute() throws Exception {
        Packager packager = Packager.getPackager();
        this.toolsLogger.info("sign.info.1", new Object[0]);
        block6: for (Option option : this.optionsArray) {
            switch (OptionNames.valueOf(option.getLongOpt().toUpperCase())) {
                case KEYSTORE: {
                    this.signer.setKeystore(option.getValue());
                    continue block6;
                }
                case ALIAS: {
                    this.signer.setAlias(option.getValue());
                    continue block6;
                }
                case STOREPASS: {
                    this.signer.setStorepass(option.getValue());
                    continue block6;
                }
                case PASSKEY: {
                    this.signer.setPasskey(option.getValue());
                    continue block6;
                }
                default: {
                    String str1 = option.getOpt();
                    String str2 = option.getLongOpt();
                    String str3 = "";
                    if (str1 != null) {
                        str3 = str3 + str1;
                    }
                    if (str1 != null && str2 != null) {
                        str3 = str3 + " (or) ";
                    }
                    if (str2 != null) {
                        str3 = str3 + str2;
                    }
                    throw new Exception("Unknown option " + str3);
                }
            }
        }
        if (this.argumentsArray == null || this.argumentsArray.length != 1) {
            this.toolsLogger.severe(ErrorKey.ModuleOrLibFileOrFolderNotSpecified.getMessage(new Object[0]), new Object[0]);
            throw new Exception(ErrorKey.ModuleOrLibFileOrFolderNotSpecified.getMessage(new Object[0]));
        }
        if (this.validateCommandLine(this.signer) != 0) {
            return 1;
        }
        packager.setOut(new File(this.argumentsArray[0]));
        this.toolsLogger.info("sign.info.2", new Object[0]);
        this.signer.setRequired(true);
        this.signer.initialize();
        if (this.signer.isOk(false)) {
            this.signer.process();
        }
        this.toolsLogger.info("sign.info.3", new Object[0]);
        Diagnostics diagnostics = new Diagnostics();
        this.signer.gatherDiagnostics(diagnostics);
        boolean ok = this.signer.isOk(true);
        String status = ok ? ErrorKey.SUCCESS.getMessage(new Object[0]) : ErrorKey.FAILED.getMessage(new Object[0]);
        diagnostics.printDiagnostics(status, "Packager/sign", ErrorKey.Error2.getMessage(new Object[0]), ErrorKey.Warning2.getMessage(new Object[0]), ErrorKey.Error1.getMessage(new Object[0]), ErrorKey.Warning1.getMessage(new Object[0]));
        return ok ? 0 : 1;
    }

    private int validateCommandLine(Signer packager) {
        Vector<String> errorMessages = new Vector<String>();
        if (packager.getKeystore() == null) {
            errorMessages.add(ErrorKey.MissingKeystore.getMessage(new Object[0]));
        }
        if (packager.getAlias() == null) {
            errorMessages.add(ErrorKey.MissingAlias.getMessage(new Object[0]));
        }
        if (packager.getPasskey() == null) {
            errorMessages.add(ErrorKey.MissingPassword.getMessage(new Object[0]));
        }
        if (packager.getStorepass() == null) {
            errorMessages.add(ErrorKey.MissingStorepass.getMessage(new Object[0]));
        }
        if (!errorMessages.isEmpty()) {
            for (String str : errorMessages) {
                this.toolsLogger.severe("[ " + ErrorKey.Error1.getMessage(new Object[0]) + "] " + str.trim(), new Object[0]);
            }
            return 1;
        }
        return 0;
    }
}

