/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javacard.jcdebugproxy;

import com.oracle.javacard.jcdebugproxy.ClassFileTokens;
import com.oracle.javacard.jcdebugproxy.IDEClassPath;
import com.oracle.javacard.tools.interfaces.DebugProxyToolInterface;
import com.oracle.tee.tools.util.Utils;
import com.sun.javacard.debugproxy.Log;
import com.sun.javacard.debugproxy.classic.ClassicProxyProtocol;
import com.sun.javacard.debugproxy.classic.VMPacketHandler;
import com.sun.javacard.debugproxy.classparser.VMClassPool;
import com.sun.javacard.debugproxy.comm.StreamVMConnection;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DebugProxyMain
implements Runnable,
DebugProxyToolInterface {
    private static final int MAX_ATTEMPT = 100;
    private int port = 8000;
    private int vmPort = 9090;
    private String vmHost = "localhost";
    private ClassicProxyProtocol proxy;
    private IDEClassPath idePath = new IDEClassPath();
    private File restoreDir;
    private File romDebugInfo;
    public boolean isStandAlone = false;
    private String jcApiExpFilesPath;
    private String jcDebugInfoDestFile;
    private static boolean isGenerateDebugInfo = false;
    private static boolean hasDebugInfo = false;
    private String capPath;
    private static boolean ideDebugger = true;

    public static boolean isGenerateDebugInfo() {
        return isGenerateDebugInfo;
    }

    public static boolean hasDebugInfo() {
        return hasDebugInfo;
    }

    public static boolean isInSystemClassesDebuggingMode() {
        return false;
    }

    public static boolean isInIdeDebugger() {
        return ideDebugger;
    }

    @Override
    public void setDebugInfo(String fileName) {
        this.romDebugInfo = fileName == null ? null : new File(fileName);
    }

    @Override
    public void setPath(String path) throws IOException {
        this.idePath.setPath(path);
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public void setVmHost(String vmHost) {
        this.vmHost = vmHost;
    }

    @Override
    public void setVmPort(int vmPort) {
        this.vmPort = vmPort;
    }

    @Override
    public void run() {
        System.out.println("--------------- run ----------------");
        try {
            this.proxy.setInitImage(this.romDebugInfo);
            this.proxy.setVm(new StreamVMConnection(this.openVMSocket()));
            this.proxy.setRestoreDir(this.restoreDir);
            this.proxy.init();
            if (this.proxy.start()) {
                try {
                    this.initPackageList();
                    if (isGenerateDebugInfo) {
                        this.proxy.genDebugInfo(this.jcDebugInfoDestFile);
                    }
                    VMClassPool classPool = this.proxy.state().classes();
                    classPool.sendDebugInfo(this.proxy);
                }
                catch (Exception ex) {
                    Logger.getLogger(DebugProxyMain.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        catch (Exception e) {
            Log.LOG(3, e.getMessage());
        }
    }

    public void stop() throws Exception {
        this.proxy.close();
    }

    @Override
    public void interrupt() {
    }

    @Override
    public void init(Logger log) {
    }

    public void processArgs(String ... list) throws Exception {
        System.out.println("--------------- processArgs ----------------");
        this.loadOptions(list);
        this.init();
        this.proxy.addProxyStateChangeListener(new ClassicProxyProtocol.ProxyStateChangeListener(){

            @Override
            public void stateChanged(ClassicProxyProtocol.ConnectionState newState) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(DebugProxyMain.class.getName()).log(Level.SEVERE, null, ex);
                }
                if (DebugProxyMain.this.isStandAlone && newState == ClassicProxyProtocol.ConnectionState.TERMINATED) {
                    System.exit(0);
                }
            }
        });
    }

    public static void main(String[] args) throws Exception {
        System.out.println("--------------- main ----------------");
        DebugProxyMain tool = new DebugProxyMain();
        tool.processArgs(args);
        tool.run();
    }

    private void init() {
        if (this.proxy == null) {
            this.proxy = new ClassicProxyProtocol(this.port, this.idePath);
        }
        this.isStandAlone = true;
    }

    private Socket openVMSocket() {
        System.out.println("--------------- openVMSocket ----------------");
        for (int i = 0; i < 100; ++i) {
            try {
                return new Socket(this.vmHost, this.vmPort);
            }
            catch (Exception ex) {
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (Exception ex2) {
                    break;
                }
            }
        }
        throw new IllegalArgumentException("Can not connect to " + this.vmHost + ":" + this.vmPort);
    }

    public boolean initPackageList() throws IOException, InterruptedException {
        System.out.println("Initializing package list ...");
        String p = "";
        if (isGenerateDebugInfo) {
            p = p.concat(this.jcApiExpFilesPath) + ";";
        }
        p = p.concat(this.capPath);
        this.setPath(p);
        int index = 0;
        int aid_length = -1;
        VMClassPool classPool = this.proxy.state().classes();
        do {
            DataInputStream data;
            if ((aid_length = 0xFF & (data = this.proxy.sendToVmSync(new byte[]{(byte)VMPacketHandler.CommandCode.GET_PACKAGES_LIST.getTag(), 1, (byte)index})).read()) != 0) {
                byte[] aid = new byte[aid_length];
                for (int i = 0; i < aid_length; ++i) {
                    aid[i] = (byte)(0xFF & data.read());
                }
                ClassFileTokens classes = this.idePath.getByAID(Utils.canonize(aid));
                classPool.addIDEClassPathPackage(index, classes);
                if (classes != null) {
                    int numClasses = data.read();
                    for (int classIndex = 0; classIndex < numClasses; ++classIndex) {
                        int offset = data.readShort() & 0xFFFF;
                        classes.updateClassLocation(classIndex, offset);
                    }
                }
            }
            ++index;
        } while (aid_length != 0);
        classPool.resolveDirectSuperClasses();
        return true;
    }

    private void printUsage() {
        System.out.println("--------------------Usage-----------------");
        System.out.println("jc-debug-proxy");
        System.out.println("command line arguments for debugging:");
        System.out.println("-help");
        System.out.println("-debug-info [source debug info file]");
        System.out.println("-gen-debug-info [api exp files path] [destination debug info file]");
        System.out.println("-port [ide port] (8000 if not specified)");
        System.out.println("-vmPort [vm port] (9090 if not specified)");
        System.out.println("-vmHost [vm address] (localhost if not specified)");
        System.out.println("-capPath [*.cap;*.cap ] - mandatory");
        System.exit(0);
    }

    private void loadOptions(String[] options) {
        if (options.length == 0) {
            System.out.println("no options were specified");
            this.printUsage();
        }
        if (options[0].equals("-help")) {
            this.printUsage();
        }
        block18: for (int i = 0; i < options.length - 1; ++i) {
            switch (options[i]) {
                case "-gen-debug-info": {
                    isGenerateDebugInfo = true;
                    this.jcApiExpFilesPath = options[++i];
                    this.jcDebugInfoDestFile = options[++i];
                    Logger.getLogger(DebugProxyMain.class.getName()).log(Level.INFO, "parse JC args: -gen-debug-info: {0}, {1}", new Object[]{this.jcApiExpFilesPath, this.jcDebugInfoDestFile});
                    continue block18;
                }
                case "-debug-info": {
                    hasDebugInfo = true;
                    this.romDebugInfo = new File(options[++i]);
                    Log.LOG(3, "parse JC args: debug-info:" + this.romDebugInfo.getAbsolutePath());
                    continue block18;
                }
                case "-capPath": {
                    this.capPath = options[++i];
                    Log.LOG(3, "parse JC args: capPath:" + this.capPath);
                    continue block18;
                }
                case "-port": {
                    this.port = Integer.parseInt(options[++i]);
                    Log.LOG(3, "parse JC args: port:" + this.port);
                    continue block18;
                }
                case "-vmPort": {
                    this.vmPort = Integer.parseInt(options[++i]);
                    Log.LOG(3, "parse JC args: vmPort:" + this.vmPort);
                    continue block18;
                }
                case "-vmHost": {
                    this.vmHost = options[++i];
                    Log.LOG(3, "parse JC args: vmHost:" + this.vmHost);
                    continue block18;
                }
                case "-debugger-jdb": {
                    ideDebugger = false;
                    Log.LOG(2, "parse JC args: JDB mode");
                    Log.LOG(2, "Warning: switching to JDB mode. This will stop debugging with IDE!\n");
                    continue block18;
                }
                default: {
                    System.out.println("parse unknown option:" + options[i]);
                    this.printUsage();
                }
            }
        }
        this.checkCapPath();
    }

    private void checkCapPath() {
        String[] caps;
        if (this.capPath == null) {
            System.out.println("mandatory option capPath was not specified");
            this.printUsage();
        }
        for (String cap : caps = this.capPath.split(File.pathSeparator)) {
            if (cap.endsWith(".cap") && new File(cap).exists()) continue;
            System.out.println("incorrect capPath option");
            this.printUsage();
        }
    }
}

