/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javacard.jcdebugproxy.events;

import com.oracle.javacard.jcdebugproxy.events.BreakPointsPool;
import com.oracle.javacard.jcdebugproxy.events.EncodingUtils;
import com.oracle.javacard.jcdebugproxy.events.EventFilter;
import com.oracle.javacard.jcdebugproxy.events.EventHandlerImpl;
import com.oracle.javacard.jcdebugproxy.events.JDWPEvent;
import com.oracle.javacard.jcdebugproxy.events.Kind;
import com.oracle.javacard.jcdebugproxy.events.OnCardEvent;
import com.sun.javacard.debugproxy.Log;
import com.sun.javacard.debugproxy.classic.ClassicPacketHandler;
import com.sun.javacard.debugproxy.classic.HandlerState;
import com.sun.javacard.debugproxy.classic.InvalidRequestException;
import com.sun.javacard.debugproxy.classic.VMPacketHandler;
import com.sun.javacard.debugproxy.classic.VmState;
import com.sun.javacard.debugproxy.classic.handlers.ClassicPacketHandlerImpl;
import com.sun.javacard.debugproxy.classparser.ClassDebugInfo;
import com.sun.javacard.debugproxy.types.Location;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class BreakPointsHandler
extends EventHandlerImpl {
    static final byte LOCATION_MODIFIER = 7;
    protected BreakPointsPool locations;
    public static final int BREAKPOINT_COUNT = 82;
    ClassicPacketHandler clearAllBreakpointsHandler = new ClassicPacketHandlerImpl(VMPacketHandler.CommandCode.CLEAR_EVENTS){

        @Override
        public ClassicPacketHandler.DeliveryType handleRequest(HandlerState state, DataOutputStream toVm) throws Exception {
            Integer offsetRef = (Integer)state.args.get("breakpoints-offset");
            int offset = offsetRef == null ? 0 : offsetRef;
            ArrayList<Location> toRm = (ArrayList<Location>)state.args.get("breakpoints");
            List<EventFilter> filters = (List<EventFilter>)state.args.get("event-filters");
            if (toRm == null) {
                toRm = new ArrayList<Location>();
                filters = BreakPointsHandler.this.locations.unregisterAll(toRm, new BreakPointsPool.KindFilter(Kind.BreakPoint));
                state.args.put("event-filters", filters);
                state.args.put("breakpoints", toRm);
                if (toRm.isEmpty()) {
                    return ClassicPacketHandler.DeliveryType.NONE;
                }
            }
            for (EventFilter filter : filters) {
                filter.state = EventFilter.State.DisablingInProcess;
            }
            offset += BreakPointsHandler.this.encodeBreakPointCommands(VMPacketHandler.CommandCode.CLEAR_EVENTS, toVm, toRm, offset);
            state.args.put("breakpoints-offset", offset);
            return offset >= toRm.size() ? ClassicPacketHandler.DeliveryType.IMMEDIATELY : ClassicPacketHandler.DeliveryType.NOT_COMPLETED;
        }

        @Override
        public void processResponseData(HandlerState state, DataInputStream in, int length) throws Exception {
            if (state.receipt == ClassicPacketHandler.DeliveryType.NOT_COMPLETED) {
                return;
            }
            for (Object o : (List)state.args.get("event-filters")) {
                ((EventFilter)o).state = EventFilter.State.Disabled;
            }
        }
    };

    public BreakPointsHandler(BreakPointsPool locations) {
        Log.setLogLevel(8);
        this.locations = locations;
    }

    @Override
    public ClassicPacketHandler.DeliveryType handleSetEventRequest(EventFilter filter, HandlerState state, DataOutputStream toVm) throws Exception {
        EncodingUtils utils = EncodingUtils.getInstance();
        Location loc = ((EventFilter.LocationModifier)filter.getModifier((int)7)).location;
        this.proxy.state().classes().initLocation(loc);
        Log.LOG(4, "BP:SET-BP:" + filter + " " + loc);
        filter.setID(BreakPointsPool.locationToId(loc));
        if (this.locations.register(loc, filter)) {
            Log.LOG(4, "BP:SET-BP-ON-CARD:" + filter + " " + loc);
            utils.encodeBreakPointRequest(toVm, loc);
            return ClassicPacketHandler.DeliveryType.NORMAL;
        }
        Log.LOG(4, "BP:ALREADY-SET-ON-CARD:" + filter + " " + loc);
        return ClassicPacketHandler.DeliveryType.NONE;
    }

    @Override
    public void handleSetConfirmation(HandlerState state, DataInputStream fromVM, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            int code = fromVM.read() & 0xFF;
            if (code == 16 || code == 0) continue;
            throw new InvalidRequestException(24);
        }
    }

    @Override
    public ClassicPacketHandler.DeliveryType handleClearEventRequest(int id, HandlerState state, DataOutputStream toVm) throws Exception {
        ArrayList<EventFilter> filters = new ArrayList<EventFilter>();
        state.args.put("event-filters", filters);
        if (this.locations.unregister(id, filters, new BreakPointsPool.IDFilter(id))) {
            EncodingUtils.getInstance().encodeBreakPoint(toVm, id);
            return ClassicPacketHandler.DeliveryType.IMMEDIATELY;
        }
        return ClassicPacketHandler.DeliveryType.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleEventFromCard(OnCardEvent event) throws IOException {
        int id = BreakPointsPool.locationToId(event.location);
        Log.LOG(3, "handleEventFromCard - id: " + id);
        ArrayList<JDWPEvent> events = new ArrayList<JDWPEvent>();
        Set<EventFilter> requests = this.locations.getRequests(id);
        boolean resumeVM = false;
        Set<EventFilter> set = requests;
        synchronized (set) {
            for (EventFilter filter : requests) {
                if (!filter.filter(event)) continue;
                if (event.state == VmState.State.SUSPENDED && filter.hasCountModifier()) {
                    EventFilter.CountModifier cm = (EventFilter.CountModifier)filter.getModifier(1);
                    cm.decrementCount();
                    if (cm.skipEventAndResumeVM()) {
                        resumeVM = true;
                        break;
                    }
                }
                Log.LOG(4, "BP:HIT-BP:" + filter + " " + event.location);
                events.add(new JDWPEvent(event, filter));
            }
        }
        if (resumeVM) {
            this.proxy.requestVMStateChange(VmState.State.RUNNING);
        } else {
            this.proxy.sendEventsToIDE((byte)2, events);
        }
    }

    protected void sendBreakPoints(VMPacketHandler.CommandCode code, List<Location> locations) throws Exception {
        int length;
        byte[] toVm = null;
        for (int offset = 0; offset < locations.size(); offset += length) {
            length = Math.min(this.getNumberOfBpPerPacket(), locations.size() - offset);
            int size = length * 3 + 1 + 2;
            toVm = toVm == null || toVm.length != size ? new byte[size] : toVm;
            int pos = 0;
            toVm[pos++] = (byte)code.getTag();
            toVm[pos++] = (byte)(toVm.length - 2);
            toVm[pos++] = 1;
            int upper = offset + length;
            for (int i = offset; i < upper; ++i) {
                int id = BreakPointsPool.locationToId(locations.get(i));
                toVm[pos++] = (byte)(id >> 16);
                toVm[pos++] = (byte)(id >> 8);
                toVm[pos++] = (byte)id;
            }
            this.proxy.sendToVm(toVm, null);
        }
    }

    protected int encodeBreakPointCommands(VMPacketHandler.CommandCode code, DataOutputStream toVm, List<Location> locations, int offset) throws Exception {
        int length = Math.min(this.getNumberOfBpPerPacket(), locations.size() - offset);
        EncodingUtils utils = EncodingUtils.getInstance();
        utils.encodeBreakPoints(toVm, locations, offset, length);
        return length;
    }

    private int getNumberOfBpPerPacket() {
        return 82;
    }

    void clearUnloadedBreakpoints(List<ClassDebugInfo> list) {
        final HashSet<Integer> unloaded = new HashSet<Integer>();
        for (ClassDebugInfo cl : list) {
            unloaded.add(cl.getClassID());
        }
        this.locations.clearLocations(new BreakPointsPool.Filter<Location>(){

            @Override
            public boolean accept(Location location) {
                return unloaded.contains(location.classId);
            }
        });
    }
}

