/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tee.tools.util;

import java.io.ByteArrayOutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class Utils {
    public static String canonize(byte[] path) {
        if (path == null) {
            return null;
        }
        return Utils.canonize(path, 0, path.length);
    }

    public static String canonize(byte[] path, int offset, int length) {
        if (path == null) {
            return null;
        }
        StringBuilder retVal = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            String e = Integer.toHexString(path[i + offset] & 0xFF);
            if (e.length() == 1) {
                retVal.append('0');
            }
            retVal.append(e);
        }
        return retVal.toString();
    }

    public static ExecutorService newCachedThreadPool(String name) {
        return Utils.newCachedThreadPool(name, false);
    }

    public static ExecutorService newCachedThreadPool(final String name, final boolean daemon) {
        return Executors.newCachedThreadPool(new ThreadFactory(){
            private int counter;

            private synchronized int counter() {
                return this.counter++;
            }

            @Override
            public Thread newThread(Runnable r) {
                Thread retVal = new Thread(r, name + "-" + this.counter());
                if (daemon) {
                    retVal.setDaemon(daemon);
                }
                return retVal;
            }
        });
    }

    public static boolean isHexString(String val) {
        char[] data = val.toCharArray();
        boolean retVal = true;
        for (int i = 0; i < data.length; ++i) {
            char c = data[i];
            retVal = retVal && (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F');
        }
        return retVal;
    }

    public static byte[] parse(String line) {
        return Utils.parse(line, 0, line.length());
    }

    public static byte[] parse(String line, String defValue) {
        return Utils.parse(line == null ? defValue : line);
    }

    public static byte[] parse(String line, int offset, int length) {
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        char[] chars = line.toCharArray();
        char previous = '\u0000';
        boolean hasPrevious = false;
        for (int i = offset + length - 1; i >= offset; --i) {
            char c = chars[i];
            if (Utils.isHexChar(c)) {
                if (hasPrevious) {
                    buff.write(Utils.parseByte(c, previous));
                } else {
                    previous = c;
                }
                hasPrevious = !hasPrevious;
                continue;
            }
            if (!hasPrevious) continue;
            buff.write(Utils.parseByte('0', previous));
            hasPrevious = false;
        }
        if (hasPrevious) {
            buff.write(Utils.parseByte('0', previous));
        }
        return Utils.reverse(buff.toByteArray());
    }

    private static byte[] reverse(byte[] data) {
        int upper = data.length - 1;
        for (int i = 0; i < upper; ++i) {
            byte b = data[i];
            data[i] = data[upper];
            data[upper--] = b;
        }
        return data;
    }

    public static byte parseByte(char high, char low) {
        return (byte)(Utils.read(high) * 16 + Utils.read(low));
    }

    private static int read(char c) {
        switch (c) {
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        return c - 48;
    }

    private static boolean isHexChar(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }
}

