/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugproxy.classic;

import com.sun.javacard.debugproxy.Log;
import com.sun.javacard.debugproxy.classic.ClassicPacketHandler;
import com.sun.javacard.debugproxy.classic.ClassicProxyProtocol;
import com.sun.javacard.debugproxy.classic.HandlerState;
import com.sun.javacard.debugproxy.classic.VMPacketHandler;
import com.sun.javacard.debugproxy.classic.handlers.ClassicPacketHandlerImpl;
import com.sun.javacard.debugproxy.classparser.ClassDebugInfo;
import com.sun.javacard.debugproxy.comm.EncodingUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;

public class StringReferenceConverters {
    static void registerStringReferenceConverters(ClassicProxyProtocol proxy) {
        proxy.addConverter(10, 1, new ClassicPacketHandlerImpl(VMPacketHandler.CommandCode.GET_STRING_VALUE){

            @Override
            public ClassicPacketHandler.DeliveryType handleRequest(HandlerState state, DataOutputStream toVm) throws Exception {
                int stringObjectID = state.in.readInt();
                Log.LOG(3, "StringReference:GetReferenceValue (handleRequest stringObjectID: " + stringObjectID + ")");
                ClassDebugInfo cdi = this.proxy.state().classes().getClassByID(stringObjectID);
                if (cdi != null) {
                    EncodingUtils.writeString(state.out, cdi.getClassName());
                    return ClassicPacketHandler.DeliveryType.NONE;
                }
                toVm.writeShort((short)stringObjectID);
                return ClassicPacketHandler.DeliveryType.NORMAL;
            }

            @Override
            public void processResponseData(HandlerState state, DataInputStream in, int length) throws Exception {
                Log.LOG(3, "StringReference:GetReferenceValue (processResponseData)");
                String str = EncodingUtils.readJDWPStringValue(in);
                EncodingUtils.writeString(state.out, str);
            }
        });
    }
}

