/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugproxy.classic;

import com.oracle.javacard.jcdebugproxy.DebugProxyMain;
import com.oracle.javacard.jcdebugproxy.events.OnCardEvent;
import com.sun.javacard.debugproxy.Log;
import com.sun.javacard.debugproxy.classic.InvalidRequestException;
import com.sun.javacard.debugproxy.classparser.VMClassPool;
import com.sun.javacard.debugproxy.types.Location;
import java.util.ArrayList;
import java.util.LinkedList;

public class VmState {
    private int suspendCounter = 0;
    private final LinkedList<OnCardEvent> eventQueue = new LinkedList();
    private static int requestID;
    private int vmStateRequestCounter = 0;
    private State state = State.RUNNING;
    private Location[] stack;
    public VMClassPool pool;

    public VmState(VMClassPool pool) {
        this.pool = pool;
    }

    public synchronized int suspend() {
        ++this.suspendCounter;
        return this.suspendCounter;
    }

    public synchronized int resume() {
        if (this.suspendCounter > 0) {
            --this.suspendCounter;
        }
        return this.suspendCounter;
    }

    public synchronized int getSuspendCount() {
        return this.suspendCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(State state) {
        if (state == State.UNCHANGED) {
            return;
        }
        Log.LOG(3, "VM STATE:" + (Object)((Object)state) + " *** stack = null;");
        VmState vmState = this;
        synchronized (vmState) {
            this.state = state;
            this.stack = null;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State getState() {
        VmState vmState = this;
        synchronized (vmState) {
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStack(int[] stack) {
        VmState vmState = this;
        synchronized (vmState) {
            this.stack = this.convertStack(stack);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location[] getStack() {
        VmState vmState = this;
        synchronized (vmState) {
            if (DebugProxyMain.isInIdeDebugger()) {
                if (this.stack == null && this.state == State.SUSPENDED) {
                    Log.LOG(3, "TODO: maybe ask VM for stack - VMPacketHandler.CommandCode.GET_STACK?");
                    throw new InvalidRequestException(101, "(stack == null) && (state == State.SUSPENDED)");
                }
            } else {
                while (this.stack == null && this.state == State.SUSPENDED) {
                    try {
                        Log.LOG(3, "JDB mode => block current thread (" + Thread.currentThread().getName() + ") until setStack is called");
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        throw new IllegalStateException("cannot get stack");
                    }
                }
            }
            if (this.state != State.SUSPENDED) {
                throw new IllegalStateException("VM is not suspended");
            }
            return this.stack;
        }
    }

    private Location[] convertStack(int[] stack) {
        ArrayList<Location> list = new ArrayList<Location>();
        if (stack.length > 0) {
            int i;
            for (i = 0; i < stack.length; ++i) {
                Location frame;
                byte packageId = (byte)(stack[i] >> 16);
                int offset = stack[i] & 0xFFFF;
                System.out.println("*convertStack: " + packageId + ":" + offset);
                this.pool.doesPackageExist("convertStack", packageId, null);
                if (i != 0) {
                    offset -= 3;
                }
                if ((frame = this.pool.getLocation(packageId, (short)offset)) == null) continue;
                list.add(frame);
                System.out.println("*" + frame.meth.getName());
            }
            for (i = list.size() - 1; i >= 0 && this.pool.isSystem(list.get((int)i).cl); --i) {
                list.remove(i);
            }
            this.validateStackTrace(list);
        }
        return list.toArray(new Location[list.size()]);
    }

    private void validateStackTrace(ArrayList<Location> stacktrace) {
        if (stacktrace.size() <= 0) {
            Log.LOG(3, "converted stacktrace is 0 length (an error if a BP event)");
        } else {
            for (int i = 0; i < stacktrace.size(); ++i) {
                short pId = stacktrace.get((int)i).cl.getPackageID();
                boolean exists = this.pool.doesPackageExist("vadlidte stacktrace failed:", pId, null);
                if (exists || i != 0) continue;
                Log.LOG(1, "Error: converted stacktrace head is corrupt (id: " + pId + "). IDE may go into undefined mode.");
            }
        }
    }

    public VMClassPool classes() {
        return this.pool;
    }

    public int findNextLineLocation() {
        Location pos = this.getStack()[0];
        if (pos.cl.getPackageID() == 255) {
            pos = this.getStack()[1];
        }
        int[][] lines = pos.meth.getBreakableLineNumbers();
        int nextLine = -1;
        for (int i = lines.length - 1; i >= 0; --i) {
            if (pos.offset < (long)lines[i][1]) continue;
            nextLine = i + 1;
            break;
        }
        int loc = pos.cl.getPackageID() << 16;
        int offset = pos.meth.getCodeOffset();
        offset = nextLine == lines.length ? (int)((long)offset + pos.meth.getCodeAttributeLength()) : (offset += lines[nextLine][1]);
        return loc |= offset & 0xFFFF;
    }

    public LinkedList<OnCardEvent> eventQueue() {
        return this.eventQueue;
    }

    public synchronized int getNextRequestCounter() {
        return ++this.vmStateRequestCounter;
    }

    public synchronized int createProxyNameSpaceRequestID() {
        return 0x1000000 | ++requestID;
    }

    public static enum State {
        RUNNING(1),
        SUSPENDED(2),
        UNCHANGED(128),
        UNKNOWN(255);

        private static final int CHANGE_REQUESTED_MASK = 128;
        private byte code;

        private State(int code) {
            this.code = (byte)code;
        }

        public byte getCode() {
            return this.code;
        }

        public static State findByCode(byte code) {
            for (State state : State.values()) {
                if (code != state.code) continue;
                return state;
            }
            return (code & 0x80) != 0 ? UNCHANGED : UNKNOWN;
        }
    }
}

