/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.debugproxy.classic.handlers;

import com.oracle.javacard.jcdebugproxy.ClassFileTokens;
import com.oracle.tee.tools.util.Utils;
import com.sun.javacard.debugproxy.Log;
import com.sun.javacard.debugproxy.classic.ClassicPacketHandler;
import com.sun.javacard.debugproxy.classic.HandlerState;
import com.sun.javacard.debugproxy.classic.VMPacketHandler;
import com.sun.javacard.debugproxy.classic.handlers.ClassicPacketHandlerImpl;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.HashMap;
import java.util.Map;

public abstract class ClassAccessHandler
extends ClassicPacketHandlerImpl {
    private Map<String, ClassFileTokens> map;

    public ClassAccessHandler(Map<String, ClassFileTokens> map) {
        super(VMPacketHandler.CommandCode.GET_PACKAGES_LIST);
        this.map = map;
    }

    @Override
    public ClassicPacketHandler.DeliveryType handleRequest(HandlerState state, DataOutputStream toVm) throws Exception {
        return this.proxy.state().classes().isInitialized() ? ClassicPacketHandler.DeliveryType.NONE : ClassicPacketHandler.DeliveryType.IMMEDIATELY;
    }

    @Override
    public void processResponseData(HandlerState state, DataInputStream in, int length) throws Exception {
        if (!this.proxy.state().classes().isInitialized()) {
            this.decodeResponseData(in);
            this.proxy.state().classes().init();
        }
        this.processParameters(state.out, state.args);
    }

    public void decodeResponseData(DataInputStream in) throws Exception {
        byte[] buff = new byte[16];
        int count = in.readByte() & 0xFF;
        int index = 0;
        for (int i = 0; i < count; ++i) {
            int length = in.readByte() & 0xFF;
            if (in.read(buff, 0, length) == -1) {
                throw new Exception("Read failed");
            }
            String key = Utils.canonize(buff, 0, length);
            ClassFileTokens pack = this.map.get(key);
            if (!this.proxy.state().classes().addLoadedPackage(index, pack)) {
                Log.LOG(3, "WARNING: cannot find a cap file for the AID=" + key);
            }
            ++index;
        }
    }

    public abstract void processParameters(DataOutputStream var1, HashMap<String, Object> var2) throws Exception;
}

